/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.ConfigurationOverviewContribution;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.customcolumn.CustomColumnConfig;
import com.pmease.quickbuild.setting.configuration.customcolumn.build.BuildCustomColumn;
import com.pmease.quickbuild.setting.configuration.customcolumn.buildrequest.BuildRequestCustomColumn;
import com.pmease.quickbuild.taskschedule.schedule.NoSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.ProgressBar;
import com.pmease.quickbuild.web.component.build.BuildDurationPanel;
import com.pmease.quickbuild.web.component.build.BuildErrorMessage;
import com.pmease.quickbuild.web.component.build.BuildInfoPanel;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.page.build.HistoryBuildsPage;
import com.pmease.quickbuild.web.page.configuration.BuildRequestWaitingReasonPanel;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationOverview
extends ConfigurationPage {
    private static final int RECENT_BUILDS_COUNT = 10;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationOverview.class);
    private IModel<Map<String, BuildRequest>> buildRequestsModel;
    private SelectionColumn<BuildRequest> selectionColumn;

    public ConfigurationOverview(Long configurationId) {
        super(configurationId);
    }

    @Override
    protected void onInitialize() {
        Object link;
        Configuration override;
        WebMarkupContainer summary;
        Label label;
        block17: {
            super.onInitialize();
            label = new Label("description", this.getConfiguration().getDescription());
            label.setEscapeModelStrings(false);
            label.setVisible(this.getConfiguration().getDescription() != null);
            this.add(new Component[]{label});
            summary = new WebMarkupContainer("summary"){

                protected void onBeforeRender() {
                    int successRate = ConfigurationManager.instance.getSuccessRate(ConfigurationOverview.this.getConfigurationId(), null, null);
                    if (successRate >= 0) {
                        this.addOrReplace(new Component[]{new ProgressBar("successRate", (IModel<Integer>)new Model((Serializable)Integer.valueOf(successRate)))});
                    } else {
                        Label label = new Label("successRate", "<i>N/A</i>");
                        label.setEscapeModelStrings(false);
                        this.addOrReplace(new Component[]{label});
                    }
                    super.onBeforeRender();
                }
            };
            this.add(new Component[]{summary});
            summary.add(new Component[]{new Label("id", String.valueOf(this.getConfigurationId()))});
            if (!this.getConfiguration().isDisabled()) {
                try {
                    String nextBuildVersion = this.getConfiguration().getNextVersion(true);
                    if (nextBuildVersion != null) {
                        label = new Label("nextBuildVersion", StringUtils.formatAsHtml(nextBuildVersion));
                        break block17;
                    }
                    label = new Label("nextBuildVersion", "<i>Can not be determined</i>");
                }
                catch (Exception e) {
                    logger.error("Error calculating next build version.", (Throwable)e);
                    label = new Label("nextBuildVersion", "<i class='red'>Error calculating. Check server log for details</i>");
                }
            } else {
                label = new Label("nextBuildVersion", "<i>N/A</i>");
            }
        }
        label.setEscapeModelStrings(false);
        summary.add(new Component[]{label});
        Schedule schedule = null;
        Configuration current = this.getConfiguration();
        while ((schedule = current.getSchedule()) == null && (current = current.getParent()) != null) {
        }
        Validate.notNull((Object)schedule);
        for (override = this.getConfiguration().getParent(); override != null && override.getSchedule() == null; override = override.getParent()) {
        }
        summary.add(new Component[]{new InheritIndicator("scheduleInheritLink", current, override, null)});
        if (current == this.getConfiguration() && !(schedule instanceof NoSchedule) && SecurityHelper.isAdmin()) {
            Component[] componentArray = new Component[1];
            link = new Link<Void>("scheduleLink"){

                public void onClick() {
                    String previousContent = VersionedDocument.fromBean(ConfigurationOverview.this.getConfiguration().getSchedule()).toXML();
                    ConfigurationOverview.this.getConfiguration().getSchedule().setPaused(!ConfigurationOverview.this.getConfiguration().getSchedule().isPaused());
                    AuditManager.instance.audit(ConfigurationOverview.this.getConfiguration(), "Schedule status is changed.", VersionedDocument.fromBean(ConfigurationOverview.this.getConfiguration().getSchedule()).toXML(), previousContent);
                    ConfigurationManager.instance.saveSchedule(ConfigurationOverview.this.getConfiguration());
                }
            };
            componentArray[0] = link;
            summary.add(componentArray);
            link.add(new Component[]{new WebMarkupContainer("icon"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (ConfigurationOverview.this.getConfiguration().getSchedule().isPaused()) {
                        tag.put("src", (CharSequence)"/images/play.gif");
                        tag.put("title", (CharSequence)"Schedule paused, click to resume");
                    } else {
                        tag.put("src", (CharSequence)"/images/pause.gif");
                        tag.put("title", (CharSequence)"Scheduled, click to pause");
                    }
                }
            }});
        } else {
            Component[] componentArray = new Component[1];
            link = new WebMarkupContainer("scheduleLink");
            componentArray[0] = link;
            summary.add(componentArray);
            link.setVisible(false);
            link.add(new Component[]{new WebMarkupContainer("icon")});
        }
        if (schedule instanceof NoSchedule) {
            summary.add(new Component[]{new Label("scheduleInfo", "No schedule")});
        } else {
            summary.add(new Component[]{new Label("scheduleInfo", (IModel)new LoadableDetachableModel<String>(){

                public String load() {
                    Schedule schedule = ConfigurationOverview.this.getConfiguration().findSchedule();
                    if (schedule.isPaused()) {
                        return schedule.toString() + " (paused)";
                    }
                    return schedule.toString();
                }
            }){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    Schedule schedule = ConfigurationOverview.this.getConfiguration().findSchedule();
                    if (schedule.isPaused()) {
                        tag.put("class", (CharSequence)"red");
                    } else {
                        tag.put("class", (CharSequence)"green");
                    }
                }
            }});
        }
        label = new Label("averageDuration", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                int duration = ConfigurationManager.instance.getAverageDuration(ConfigurationOverview.this.getConfigurationId(), null, null);
                if (duration != -1) {
                    return DateUtils.formatDuration(duration);
                }
                return "<i>N/A</i>";
            }
        });
        label.setEscapeModelStrings(false);
        summary.add(new Component[]{label});
        WebMarkupContainer errorContainer = new WebMarkupContainer("errorContainer"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ConfigurationOverview.this.getConfiguration().getErrorMessage() != null);
            }
        };
        this.add(new Component[]{errorContainer});
        label = new BuildErrorMessage("errorMessage", (IModel<String>)new LoadableDetachableModel<String>(){

            public String load() {
                return ConfigurationOverview.this.getConfiguration().getErrorMessage();
            }
        });
        errorContainer.add(new Component[]{label});
        errorContainer.add(new Component[]{new Link<Void>("errorDetail"){

            public void onClick() {
                PageParameters params = GridPage.params4(Grid.instance.getLocalNode().getAddress(), "log", String.valueOf(ConfigurationOverview.this.getConfiguration().getStatusDate().getTime()));
                this.setResponsePage(GridPage.class, params);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isSystemLogAllowed() && ConfigurationOverview.this.getConfiguration().getErrorMessage() != null);
            }
        }});
        errorContainer.add(new Component[]{new Link<Void>("clearError"){

            public void onClick() {
                ConfigurationManager.instance.saveStatus(ConfigurationOverview.this.getConfiguration(), null, new Date());
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isEditSettingAllowed() && ConfigurationOverview.this.getConfiguration().isInError());
            }
        }});
        errorContainer.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Configuration cached = CacheManager.instance.getConfiguration(ConfigurationOverview.this.getConfigurationId());
                return cached != null && cached.getStatusDate().after(lastRefreshDate);
            }
        }});
        this.buildRequestsModel = new LoadableDetachableModel<Map<String, BuildRequest>>(){

            protected Map<String, BuildRequest> load() {
                LinkedHashMap<String, BuildRequest> requests = new LinkedHashMap<String, BuildRequest>();
                for (BuildRequest request : BuildEngine.instance.getBuildRequests(ConfigurationOverview.this.getConfigurationId())) {
                    requests.put(request.getId(), request);
                }
                return requests;
            }
        };
        WebMarkupContainer buildRequestsContainer = new WebMarkupContainer("buildRequestsContainer"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!ConfigurationOverview.this.getBuildRequests().isEmpty());
            }
        };
        this.add(new Component[]{buildRequestsContainer});
        buildRequestsContainer.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                return BuildEngine.instance.getActivityDate(ConfigurationOverview.this.getConfigurationId()).after(lastRefreshDate);
            }
        }});
        ArrayList<Object> buildRequestColumns = new ArrayList<Object>();
        if (SecurityHelper.hasPermission(ConfigurationPermission.STOP_BUILD.name())) {
            this.selectionColumn = new SelectionColumn();
            buildRequestColumns.add(this.selectionColumn);
        }
        buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Requested By"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((BuildRequest)rowModel.getObject()).getRequesterName())});
            }
        });
        buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Schedule Date"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                String scheduleDateStr = DateUtils.formatDateTime(((BuildRequest)rowModel.getObject()).getRequestDate());
                cellItem.add(new Component[]{new Label(componentId, scheduleDateStr)});
            }
        });
        buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Priority"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(((BuildRequest)rowModel.getObject()).getPriority()))});
            }
        });
        buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Process Status"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                BuildRequest request = (BuildRequest)rowModel.getObject();
                Fragment fragment = new Fragment(componentId, "requestStatusFrag", (MarkupContainer)ConfigurationOverview.this);
                fragment.add(new Component[]{new Label("statusName", request.getStatus().name())});
                fragment.add(new Component[]{new BuildRequestWaitingReasonPanel("waitingReason", rowModel)});
                cellItem.add(new Component[]{fragment});
            }
        });
        buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Master Node"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                String masterNode = ((BuildRequest)rowModel.getObject()).getBuild().getMasterStep().getNodeAddress();
                if (masterNode != null) {
                    cellItem.add(new Component[]{new BookmarkableTextLink(componentId, masterNode, GridPage.class, GridPage.params4(masterNode)).add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"link"))})});
                } else {
                    cellItem.add(new Component[]{new Label(componentId, "<i>Not determined</i>").setEscapeModelStrings(false)});
                }
            }
        });
        buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)"Build Version"))){

            public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, final IModel<BuildRequest> rowModel) {
                BuildRequest request = (BuildRequest)rowModel.getObject();
                if (request.getBuild().getId() != null) {
                    final Long buildId = request.getBuild().getId();
                    cellItem.add(new Component[]{new BuildLink(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                        protected Build load() {
                            if (rowModel.getObject() == null) {
                                return (Build)BuildManager.instance.load(buildId);
                            }
                            return ((BuildRequest)rowModel.getObject()).getBuild();
                        }
                    })});
                } else {
                    Label label = new Label(componentId, "<i>Not determined</i>");
                    label.setEscapeModelStrings(false);
                    cellItem.add(new Component[]{label});
                }
            }
        });
        CustomColumnConfig customColumnConfig = this.getConfiguration().findCustomColumnConfig();
        if (customColumnConfig != null && customColumnConfig.getBuildRequestCustomColumns() != null) {
            for (final BuildRequestCustomColumn customField : customColumnConfig.getBuildRequestCustomColumns()) {
                buildRequestColumns.add(new AbstractColumn<BuildRequest>((IModel)new Model((Serializable)((Object)customField.getName()))){

                    public void populateItem(Item<ICellPopulator<BuildRequest>> cellItem, String componentId, IModel<BuildRequest> rowModel) {
                        BuildRequest request = (BuildRequest)rowModel.getObject();
                        cellItem.add(new Component[]{new Label(componentId, customField.getValueProvider().getValue(request)).setEscapeModelStrings(false)});
                    }
                });
            }
        }
        buildRequestsContainer.add(new Component[]{new DefaultDataTable("buildRequests", buildRequestColumns, (ISortableDataProvider)new DataProvider<BuildRequest>(){

            @Override
            public IModel<BuildRequest> model(BuildRequest object) {
                final String requestId = object.getId();
                return new LoadableDetachableModel<BuildRequest>(){

                    protected BuildRequest load() {
                        return (BuildRequest)ConfigurationOverview.this.getBuildRequests().get(requestId);
                    }
                };
            }

            public Iterator<? extends BuildRequest> iterator(int first, int count) {
                return new ArrayList(ConfigurationOverview.this.getBuildRequests().values()).subList(first, first + count).iterator();
            }

            public int size() {
                return ConfigurationOverview.this.getBuildRequests().size();
            }
        }, Integer.MAX_VALUE)});
        Component[] componentArray = new Component[1];
        link = new Link<Void>("cancelSelected"){

            public void onClick() {
                if (!ConfigurationOverview.this.selectionColumn.getSelections().isEmpty()) {
                    for (BuildRequest request : ConfigurationOverview.this.selectionColumn.getSelections()) {
                        if (request == null) continue;
                        BuildEngine.instance.cancelRequest(request.getId());
                    }
                    AuditManager.instance.audit(ConfigurationOverview.this.getConfiguration(), ConfigurationOverview.this.selectionColumn.getSelections().size() + " build requests were cancelled.");
                    this.getSession().warn((Serializable)((Object)"Cancel command issued. The request may take a while to be cancelled."));
                } else {
                    this.getSession().warn((Serializable)((Object)"Please select build requests to cancel."));
                }
                this.setResponsePage(ConfigurationOverview.class, ConfigurationOverview.params4(ConfigurationOverview.this.getConfigurationId()));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.STOP_BUILD.name()));
            }
        };
        componentArray[0] = link;
        buildRequestsContainer.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to cancel selected build requests?")});
        Component[] componentArray2 = new Component[1];
        link = new Link<Void>("cancelAll"){

            public void onClick() {
                if (!ConfigurationOverview.this.getBuildRequests().isEmpty()) {
                    for (BuildRequest request : ConfigurationOverview.this.getBuildRequests().values()) {
                        BuildEngine.instance.cancelRequest(request.getId());
                    }
                    AuditManager.instance.audit(ConfigurationOverview.this.getConfiguration(), ConfigurationOverview.this.getBuildRequests().size() + " build requests were cancelled.");
                    this.getSession().warn((Serializable)((Object)"Cancel command issued. The build may take a while to be cancelled."));
                }
                this.setResponsePage(ConfigurationOverview.class, ConfigurationOverview.params4(ConfigurationOverview.this.getConfigurationId()));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.STOP_BUILD.name()));
            }
        };
        componentArray2[0] = link;
        buildRequestsContainer.add(componentArray2);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to cancel all build requests?")});
        final WebMarkupContainer recentBuildsContainer = new WebMarkupContainer("recentBuildsContainer"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(CacheManager.instance.getHistoryCount(ConfigurationOverview.this.getConfigurationId()) != 0L);
            }
        };
        this.add(new Component[]{recentBuildsContainer});
        recentBuildsContainer.add(new Component[]{new BookmarkablePageLink("buildHistory", HistoryBuildsPage.class, HistoryBuildsPage.params4(this.getConfigurationId(), null))});
        recentBuildsContainer.add(new Component[]{new WebMarkupContainer("rss"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("href", (CharSequence)(Quickbuild.getInstance().getUrl() + "/rss_feed" + "/" + ConfigurationOverview.this.getConfigurationId()));
            }
        }});
        ArrayList<AbstractColumn> recentBuildColumns = new ArrayList<AbstractColumn>();
        recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Id"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, IModel<Build> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, String.valueOf(HibernateUtils.getId((AbstractEntity)rowModel.getObject())))});
            }

            public String getCssClass() {
                return "id";
            }
        });
        recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Version"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, final IModel<Build> rowModel) {
                cellItem.add(new Component[]{new BuildInfoPanel(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                    public Build load() {
                        Long buildId = HibernateUtils.getId((AbstractEntity)rowModel.getObject());
                        Build build = BuildEngine.instance.getBuild(buildId);
                        if (build == null) {
                            build = (Build)BuildManager.instance.load(buildId);
                        }
                        return build;
                    }
                }).showAge(false).showDuration(false)});
            }
        });
        Build latestBuild = CacheManager.instance.getLatestBuild(this.getConfigurationId());
        if (latestBuild != null && latestBuild.getShortBranch() != null) {
            recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Branch"))){

                public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, IModel<Build> rowModel) {
                    cellItem.add(new Component[]{new Label(componentId, ((Build)rowModel.getObject()).getShortBranch())});
                }
            });
        }
        recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Master Node"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, IModel<Build> rowModel) {
                String masterNode = ((Build)rowModel.getObject()).getMasterStep().getNodeAddress();
                cellItem.add(new Component[]{new BookmarkableTextLink(componentId, masterNode, GridPage.class, GridPage.params4(masterNode)).add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"link"))})});
            }
        });
        recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Begin Date"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, final IModel<Build> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (IModel)new LoadableDetachableModel<String>(){

                    public String load() {
                        return DateUtils.formatDateTime(((Build)rowModel.getObject()).getBeginDate());
                    }
                })});
            }
        });
        recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Duration"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, final IModel<Build> rowModel) {
                cellItem.add(new Component[]{new BuildDurationPanel(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                    public Build load() {
                        Long buildId = HibernateUtils.getId((AbstractEntity)rowModel.getObject());
                        Build build = BuildEngine.instance.getBuild(buildId);
                        if (build == null) {
                            build = (Build)BuildManager.instance.load(buildId);
                        }
                        return build;
                    }
                })});
            }
        });
        recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)"Triggered By"))){

            public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, IModel<Build> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((Build)rowModel.getObject()).getRequesterName())});
            }
        });
        if (customColumnConfig != null && customColumnConfig.getBuildCustomColumns() != null) {
            for (final BuildCustomColumn customField : customColumnConfig.getBuildCustomColumns()) {
                recentBuildColumns.add(new AbstractColumn<Build>((IModel)new Model((Serializable)((Object)customField.getName()))){

                    public void populateItem(Item<ICellPopulator<Build>> cellItem, String componentId, IModel<Build> rowModel) {
                        Build build = (Build)rowModel.getObject();
                        cellItem.add(new Component[]{new Label(componentId, customField.getValueProvider().getValue(build)).setEscapeModelStrings(false)});
                    }
                });
            }
        }
        recentBuildsContainer.add(new Component[]{new DefaultDataTable("recentBuilds", recentBuildColumns, (ISortableDataProvider)new DataProvider<Build>(){

            @Override
            public IModel<Build> model(Build object) {
                final Long buildId = object.getId();
                return new LoadableDetachableModel<Build>(){

                    protected Build load() {
                        return (Build)BuildManager.instance.load(buildId);
                    }
                };
            }

            public Iterator<? extends Build> iterator(int first, int count) {
                SearchCriteria criteria = new SearchCriteria(new Criterion[]{Restrictions.eq((String)"configuration", (Object)ConfigurationOverview.this.getConfiguration())}, new Order[]{Order.desc((String)"id")});
                return BuildManager.instance.search(criteria, 0, 10).iterator();
            }

            public int size() {
                return 10;
            }
        }, Integer.MAX_VALUE)});
        recentBuildsContainer.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Build latestBuild = CacheManager.instance.getLatestBuild(ConfigurationOverview.this.getConfigurationId());
                if (latestBuild != null && latestBuild.getBeginDate().after(lastRefreshDate)) {
                    recentBuildsContainer.setVisible(true);
                    return true;
                }
                return false;
            }
        }});
        this.add(new Component[]{new ListView<PanelCreator>("contributions", (IModel)new LoadableDetachableModel<List<PanelCreator>>(){

            protected List<PanelCreator> load() {
                List<ConfigurationOverviewContribution> contributions = PluginManager.instance.getExtensions(ConfigurationOverviewContribution.class);
                Collections.sort(contributions, new Comparator<ConfigurationOverviewContribution>(){

                    @Override
                    public int compare(ConfigurationOverviewContribution contrib1, ConfigurationOverviewContribution contrib2) {
                        return contrib1.getOrder() - contrib2.getOrder();
                    }
                });
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                for (ConfigurationOverviewContribution contrib : contributions) {
                    List<PanelCreator> contribCreators = contrib.getPanelCreators();
                    if (contribCreators == null) continue;
                    creators.addAll(contribCreators);
                }
                return creators;
            }
        }){

            protected void populateItem(ListItem<PanelCreator> item) {
                PanelCreator creator = (PanelCreator)item.getModelObject();
                item.add(new Component[]{creator.newPanel("panel").setRenderBodyOnly(true)});
            }
        }});
    }

    public ConfigurationOverview(PageParameters params) {
        this(params.get(0).toLong());
    }

    @Override
    protected void onDetach() {
        if (this.buildRequestsModel != null) {
            this.buildRequestsModel.detach();
        }
        super.onDetach();
    }

    private Map<String, BuildRequest> getBuildRequests() {
        return (Map)this.buildRequestsModel.getObject();
    }
}

