/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.MultilineText;
import com.pmease.quickbuild.web.component.build.BuildInfoPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationChooser;
import com.pmease.quickbuild.web.component.configuration.ConfigurationStatusPanel;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class ChildrenPage
extends ConfigurationPage {
    private SelectionColumn<Configuration> selectionColumn;

    public ChildrenPage(PageParameters params) {
        super(params.get(0).toLong());
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.hasPermission(ConfigurationPermission.DELETE_CHILDREN.name()) || SecurityHelper.hasPermission(ConfigurationPermission.MOVE_CHILDREN.name())) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new AbstractColumn<Configuration>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, IModel<Configuration> rowModel) {
                Configuration configuration = (Configuration)rowModel.getObject();
                final Long configurationId = configuration.getId();
                Fragment fragment = new Fragment(componentId, "configurationFrag", (MarkupContainer)ChildrenPage.this);
                fragment.add(new Component[]{new ConfigurationStatusPanel("status", configuration.getId())});
                Link<?> link = ChildrenPage.this.newSwitchLink("link", configuration.getId());
                link.add(new Component[]{new Label("label", configuration.getName())});
                fragment.add(new Component[]{link});
                fragment.add(new Component[]{new Link<Void>("copy"){

                    public void onClick() {
                        Configuration newConfiguration = ConfigurationManager.instance.copyAsNew((Configuration)ConfigurationManager.instance.load(configurationId), false);
                        newConfiguration.setParent(((Configuration)ConfigurationManager.instance.load(configurationId)).getParent());
                        this.setResponsePage((Page)new ConfigurationSettingPage(newConfiguration, configurationId, new PageBack(){

                            @Override
                            public void go() {
                                this.setResponsePage(ChildrenPage.class, ChildrenPage.params4(ChildrenPage.this.getConfigurationId()));
                            }
                        }));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.ADD_CHILDREN.name()));
                    }
                }});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new AbstractColumn<Configuration>((IModel)new Model((Serializable)((Object)"Description"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, IModel<Configuration> rowModel) {
                Configuration configuration = (Configuration)rowModel.getObject();
                cellItem.add(new Component[]{new MultilineText(componentId, configuration.getDescription())});
            }
        });
        columns.add(new AbstractColumn<Configuration>((IModel)new Model((Serializable)((Object)"Latest Build"))){

            public void populateItem(Item<ICellPopulator<Configuration>> cellItem, String componentId, final IModel<Configuration> rowModel) {
                cellItem.add(new Component[]{new BuildInfoPanel(componentId, (IModel<Build>)new LoadableDetachableModel<Build>(){

                    protected Build load() {
                        Configuration configuration = (Configuration)rowModel.getObject();
                        configuration = BasePage.get().getConfigurations().get(configuration.getId());
                        Build build = CacheManager.instance.cloneLatestBuild(configuration.getId());
                        if (build != null) {
                            build.setConfiguration(configuration);
                        }
                        return build;
                    }
                })});
            }
        });
        this.add(new Component[]{new DefaultDataTable("children", columns, (ISortableDataProvider)new DataProvider<Configuration>(){

            @Override
            public IModel<Configuration> model(Configuration object) {
                final Long configurationId = object.getId();
                return new LoadableDetachableModel<Configuration>(){

                    protected Configuration load() {
                        return (Configuration)ConfigurationManager.instance.load(configurationId);
                    }
                };
            }

            public Iterator<Configuration> iterator(int first, int count) {
                List<Configuration> children = CacheManager.instance.getChildren(ChildrenPage.this.getConfiguration().getId());
                Collections.sort(children, new Comparator<Serializable>(){

                    @Override
                    public int compare(Serializable o1, Serializable o2) {
                        Configuration configuration1 = (Configuration)o1;
                        Configuration configuration2 = (Configuration)o2;
                        return configuration1.getName().compareTo(configuration2.getName());
                    }
                });
                return children.iterator();
            }

            public int size() {
                return CacheManager.instance.getChildrenCount(ChildrenPage.this.getConfiguration().getId());
            }
        }, Integer.MAX_VALUE)});
        this.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                Configuration configuration = new Configuration(true);
                configuration.setParent(ChildrenPage.this.getConfiguration());
                this.setResponsePage((Page)new ConfigurationSettingPage(configuration, null, new PageBack(){

                    @Override
                    public void go() {
                        this.setResponsePage(ChildrenPage.class, ChildrenPage.params4(ChildrenPage.this.getConfigurationId()));
                    }
                }));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.ADD_CHILDREN.name()));
            }
        }});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteSelected"){

            public void onClick() {
                for (Configuration configuration : ChildrenPage.this.selectionColumn.getSelections()) {
                    Configuration reloaded = (Configuration)ConfigurationManager.instance.load(configuration.getId());
                    Configuration found = null;
                    for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
                        Configuration requestConfiguration = (Configuration)ConfigurationManager.instance.load(request.getConfigurationId());
                        if (requestConfiguration.getInheritDistance(reloaded) == -1) continue;
                        found = requestConfiguration;
                        break;
                    }
                    if (found != null) {
                        this.getSession().warn((Serializable)((Object)("There are waiting or processing build requests for configuration '" + found + "'. Please cancel them first.")));
                        break;
                    }
                    ConfigurationManager.instance.delete(reloaded);
                    AuditManager.instance.audit(reloaded, "Configuration was deleted.");
                }
                this.setResponsePage(ChildrenPage.class, ConfigurationPage.params4(ChildrenPage.this.getConfigurationId()));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.DELETE_CHILDREN.name()));
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("This will delete selected configurations and all their descendent configurations, including all build artifacts and reports under them. Do you really want to continue?")});
        this.add(new Component[]{new WebMarkupContainer("copyFrom"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.ADD_CHILDREN.name()));
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationChooser(componentId, Configuration.ROOT_ID, true, new TreeState(){

                    @Override
                    public boolean isExpanded(Serializable nodeKey) {
                        return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
                    }

                    @Override
                    public void setExpanded(Serializable nodeKey, boolean expanded) {
                        WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
                    }
                }){

                    @Override
                    protected WebMarkupContainer newSelectLink(String id, final Configuration selected) {
                        return new Link<Void>(id){

                            public void onClick() {
                                Configuration copy = ConfigurationManager.instance.copyAsNew(selected, false);
                                copy.setParent(ChildrenPage.this.getConfiguration());
                                this.setResponsePage((Page)new ConfigurationSettingPage(copy, selected.getId(), new PageBack(){

                                    @Override
                                    public void go() {
                                        this.setResponsePage(ChildrenPage.class, ChildrenPage.params4(ChildrenPage.this.getConfigurationId()));
                                    }
                                }));
                            }
                        };
                    }
                };
            }
        }})});
        this.add(new Component[]{new WebMarkupContainer("moveTo"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.DELETE_CHILDREN.name()) || SecurityHelper.hasPermission(ConfigurationPermission.MOVE_CHILDREN.name()));
            }
        }.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                return new ConfigurationChooser(componentId, Configuration.ROOT_ID, true, new TreeState(){

                    @Override
                    public boolean isExpanded(Serializable nodeKey) {
                        return WebSession.get().getConfigurationChooserState().isExpanded(nodeKey);
                    }

                    @Override
                    public void setExpanded(Serializable nodeKey, boolean expanded) {
                        WebSession.get().getConfigurationChooserState().setExpanded(nodeKey, expanded);
                    }
                }){

                    @Override
                    protected WebMarkupContainer newSelectLink(String id, Configuration selected) {
                        final Long selectedId = selected.getId();
                        return new Link<Void>(id){

                            public void onClick() {
                                Configuration destination = (Configuration)ConfigurationManager.instance.load(selectedId);
                                if (!SecurityHelper.hasPermission(destination, ConfigurationPermission.ADD_CHILDREN.name())) {
                                    this.getSession().info((Serializable)((Object)"Can not move since you do not have permission to add child configurations under the destination configuration."));
                                    return;
                                }
                                for (Configuration configuration : ChildrenPage.this.selectionColumn.getSelections()) {
                                    Configuration reloaded = (Configuration)ConfigurationManager.instance.load(configuration.getId());
                                    if (destination.getInheritDistance(reloaded) != -1) {
                                        this.getSession().info((Serializable)((Object)"Can not move since destination configuration is the same as or is a descendent of selected configuration."));
                                        break;
                                    }
                                    reloaded.setParent(destination);
                                    ConfigurationManager.instance.save(reloaded);
                                }
                                this.setResponsePage(ChildrenPage.class, ConfigurationPage.params4(ChildrenPage.this.getConfigurationId()));
                            }
                        };
                    }
                };
            }
        }})});
    }
}

