/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.MultilineText;
import com.pmease.quickbuild.web.page.configuration.StepWaitReasonsPanel;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class BuildRequestWaitingReasonPanel
extends Panel {
    public BuildRequestWaitingReasonPanel(String id, IModel<BuildRequest> buildRequestModel) {
        super(id, buildRequestModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer trigger = new WebMarkupContainer("waitReasonTrigger");
        this.add(new Component[]{trigger});
        trigger.setVisible(this.getBuildRequest().getWaitReason() != null || this.getBuildRequest().getStatus() == BuildRequest.Status.WAITING_NODE);
        trigger.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                String requestWaitReason = BuildRequestWaitingReasonPanel.this.getBuildRequest().getWaitReason();
                if (requestWaitReason != null) {
                    return new MultilineText(componentId, requestWaitReason);
                }
                Map<String, List<String>> stepWaitReasons = BuildEngine.instance.getWaitReasons(BuildRequestWaitingReasonPanel.this.getBuildRequest().getId(), "master");
                if (stepWaitReasons != null && !stepWaitReasons.isEmpty()) {
                    return new StepWaitReasonsPanel(componentId, stepWaitReasons);
                }
                return new Label(componentId, "Waiting for request processing cycle");
            }
        }});
    }

    private BuildRequest getBuildRequest() {
        return (BuildRequest)this.getDefaultModelObject();
    }
}

