/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.configuration;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildOptionManager;
import com.pmease.quickbuild.model.BuildOption;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildOptionEdit
extends ConfigurationPage {
    private static final Logger logger = LoggerFactory.getLogger(BuildOptionEdit.class);
    private PageBack pageback;

    public BuildOptionEdit(Long configurationId, PageBack pageback) {
        super(configurationId);
        this.pageback = pageback;
    }

    @Override
    protected void onInitialize() {
        BuildOption buildOption;
        super.onInitialize();
        Class<?> variablePromptBeanClass = Context.getConfiguration().getVariablePromptBeanClass();
        HashMap<String, String> variableValues = null;
        if (Context.getUser() != null && (buildOption = BuildOptionManager.instance.get(Context.getUser(), Context.getConfiguration())) != null) {
            variableValues = buildOption.getVariables();
            for (String key : variableValues.keySet()) {
                try {
                    Method getter = BeanUtils.getGetter(variablePromptBeanClass, key);
                    if (getter.getAnnotation(Password.class) == null) continue;
                    variableValues.put(key, StringUtils.decrypt((String)variableValues.get(key)));
                }
                catch (Exception e) {}
            }
        }
        if (variableValues == null) {
            variableValues = new HashMap<String, String>();
        }
        for (Field field : variablePromptBeanClass.getFields()) {
            if (!VariableBeanHelper.isPromptField(field)) continue;
            Variable var = Context.getConfiguration().findVar(field.getName());
            Validate.notNull((Object)var);
            if (variableValues.containsKey(field.getName()) && var.getPromptSetting().isRemember()) continue;
            String varValue = ScriptEngine.instance.interpolate(var.getValue(), Context.buildEvalContext(this.getConfiguration(), null));
            variableValues.put(field.getName(), varValue);
        }
        Object variableBean = ClassUtils.instantiateClass(variablePromptBeanClass, new Object[0]);
        for (Method getter : BeanUtils.getGetters(variablePromptBeanClass)) {
            if (getter.getAnnotation(Editable.class) == null) continue;
            Method setter = BeanUtils.getSetter(getter);
            TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
            String varName = this.getVarName(BeanUtils.getPropertyName(getter));
            String varValue = (String)variableValues.get(varName);
            if (typeConverter != null) {
                if (getter.getReturnType() == Date.class && varValue != null && ((varValue = varValue.trim()).contains(" +") || varValue.contains(" -"))) {
                    varValue = StringUtils.substringBeforeLast((String)varValue, (String)" ");
                }
                try {
                    setter.invoke(variableBean, typeConverter.toObject(getter.getReturnType(), varValue));
                }
                catch (Exception e) {
                    if (varValue == null) continue;
                    logger.error("Error setting default value for variable prompting.", (Throwable)e);
                }
                continue;
            }
            if (!StringUtils.isNotBlank((String)varValue)) continue;
            try {
                setter.invoke(variableBean, StringUtils.string2obj(varValue));
            }
            catch (Exception e) {
                if (varValue == null) continue;
                logger.error("Error setting default value for variable prompting.", (Throwable)e);
            }
        }
        final EditContext editContext = new EditContext(variableBean);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    HashMap<String, String> variableMap = new HashMap<String, String>();
                    SimpleDateFormat sdf = new SimpleDateFormat("Z");
                    sdf.setTimeZone(Context.getTimeZone());
                    String timeZone = sdf.format(new Date());
                    for (EditContext.EditableProperty property : editContext.getProperties()) {
                        String varName = BuildOptionEdit.this.getVarName(property.getName());
                        Method getter = BeanUtils.getGetter(editContext.getBeanClass(), property.getName());
                        TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
                        if (typeConverter != null) {
                            if (getter.getReturnType() == Date.class && property.getValue() != null) {
                                variableMap.put(varName, ((String)property.getValue()).trim() + " " + timeZone);
                                continue;
                            }
                            variableMap.put(varName, (String)property.getValue());
                            continue;
                        }
                        if (property.getValue() != null) {
                            EditContext propertyEditContext = (EditContext)property.getValue();
                            Object propertyBean = ClassUtils.instantiateClass(propertyEditContext.getBeanClass(), new Object[0]);
                            propertyEditContext.update(propertyBean);
                            variableMap.put(varName, StringUtils.obj2string((Serializable)propertyBean));
                            continue;
                        }
                        variableMap.put(varName, null);
                    }
                    if (Context.getUser() != null) {
                        BuildOption buildOption = BuildOptionManager.instance.get(Context.getUser(), Context.getConfiguration());
                        if (buildOption == null) {
                            buildOption = new BuildOption();
                            buildOption.setConfiguration(Context.getConfiguration());
                            buildOption.setUser(Context.getUser());
                        }
                        LinkedHashMap<String, String> variableMapToSave = new LinkedHashMap<String, String>();
                        for (Map.Entry entry : variableMap.entrySet()) {
                            Method getter = BeanUtils.getGetter(editContext.getBeanClass(), (String)entry.getKey());
                            if (getter.getAnnotation(Password.class) != null) {
                                variableMapToSave.put((String)entry.getKey(), StringUtils.encrypt((String)entry.getValue()));
                                continue;
                            }
                            variableMapToSave.put((String)entry.getKey(), (String)entry.getValue());
                        }
                        buildOption.setVariables(variableMapToSave);
                        BuildOptionManager.instance.save(buildOption);
                    }
                    BuildRequest request = new BuildRequest();
                    request.setConfigurationId(BuildOptionEdit.this.getConfiguration().getId());
                    request.setRespectBuildCondition(false);
                    request.getVariables().putAll(variableMap);
                    RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
                    if (result.getRequestId() != null) {
                        if (BuildOptionEdit.this.getConfiguration().findAuditBuildRequest().booleanValue()) {
                            AuditManager.instance.audit(BuildOptionEdit.this.getConfiguration(), "Build was requested.");
                        }
                        this.getSession().info((Serializable)((Object)"Build request has been queued."));
                    } else {
                        this.getSession().warn((Serializable)((Object)result.getRejectReason()));
                    }
                    this.setResponsePage(ConfigurationOverview.class, ConfigurationOverview.params4(BuildOptionEdit.this.getConfigurationId()));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                BuildOptionEdit.this.pageback.go();
            }
        }});
        this.add(new Component[]{form});
    }

    public void configurationChanged() {
        this.setResponsePage(ConfigurationOverview.class, ConfigurationOverview.params4(this.getConfigurationId()));
    }

    @Override
    protected PageParameters getPageParameters(Long configurationId) {
        return null;
    }

    private String getVarName(String propertyName) {
        if (Context.getConfiguration().findVar(propertyName) != null) {
            return propertyName;
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

