/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.SecretAwareString;
import com.pmease.quickbuild.web.component.MultilineText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class VariableValuesPanel
extends Panel {
    public VariableValuesPanel(String id) {
        super(id);
        this.add(new Component[]{new ListView<Property>("variables", (IModel)new LoadableDetachableModel<List<Property>>(){

            protected List<Property> load() {
                ArrayList<Property> variables = new ArrayList<Property>();
                for (Map.Entry<String, SecretAwareString> entry : Context.getBuild().getSecretAwareVariableValues().entrySet()) {
                    if (entry.getValue().getMasked() == null) {
                        variables.add(new Property(entry.getKey(), entry.getValue().getString()));
                        continue;
                    }
                    variables.add(new Property(entry.getKey(), entry.getValue().getMasked()));
                }
                Collections.sort(variables, new Comparator<Property>(){

                    @Override
                    public int compare(Property v1, Property v2) {
                        return v1.getName().compareTo(v2.getName());
                    }
                });
                return variables;
            }
        }){

            protected void populateItem(ListItem<Property> item) {
                Property var = (Property)item.getModelObject();
                item.add(new Component[]{new Label("name", var.getName())});
                item.add(new Component[]{new MultilineText("value", var.getValue())});
            }
        }});
    }
}

