/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.FailSafeStep;
import com.pmease.quickbuild.stepsupport.ParallelStep;
import com.pmease.quickbuild.stepsupport.SequentialStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.viewer.BeanViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import com.pmease.quickbuild.web.page.build.StepLogPage;
import com.pmease.quickbuild.web.page.configuration.StepWaitReasonsPanel;
import com.pmease.quickbuild.web.page.configuration.WorkspacePage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class StepStatusPanel
extends Panel {
    public StepStatusPanel(String id) {
        super(id);
        this.add(new Component[]{new StepView("masterStep", StepPath.fromString("master"))});
    }

    protected void onBeforeRender() {
        this.replace((Component)((Object)new StepView("masterStep", StepPath.fromString("master"))));
        super.onBeforeRender();
    }

    private class StepView
    extends Fragment {
        public StepView(String id, final StepPath path) {
            Object body;
            WebMarkupContainer nodeLink;
            super(id, "stepViewFrag", (MarkupContainer)StepStatusPanel.this, (IModel)new LoadableDetachableModel<Step>(){

                protected Step load() {
                    Step step = Context.getBuild().getStep(path);
                    if (step == null) {
                        step = new FailSafeStep();
                        step.setDescription("Step not defined");
                        step.setPath(path);
                        step.setName(path.getLastElement().getStepName());
                    }
                    return step;
                }
            });
            Build build = Context.getBuild();
            WebMarkupContainer head = new WebMarkupContainer("head");
            Configuration declarer = build.getConfiguration().findStepDeclarer(path.getLastElement().getStepName());
            if (declarer != null) {
                Configuration override = build.getConfiguration().getParent();
                if (override != null) {
                    override = override.findStepDeclarer(path.getLastElement().getStepName());
                }
                head.add(new Component[]{new InheritIndicator("inherit", declarer, override, "steps")});
            } else {
                head.add(new Component[]{new WebMarkupContainer("inherit")});
            }
            Label stepLabel = new Label("name", path.getLastElement().toString());
            boolean settingAccessible = SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_SETTINGS.name());
            if (settingAccessible && !(this.getStep() instanceof FailSafeStep)) {
                stepLabel.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"link"))});
                stepLabel.add(new Behavior[]{new PopupBehavior(){

                    @Override
                    protected Component getPopup(String componentId) {
                        Step stepDef = Context.getConfiguration().findStep(StepView.this.getStep().getName());
                        Validate.notNull((Object)stepDef);
                        if (stepDef.isMaster()) {
                            return new BeanViewer(componentId, new ViewContext(stepDef, Step.MASTER_EXCLUDED_PROPERTIES, true));
                        }
                        return new BeanViewer(componentId, new ViewContext(stepDef, new String[]{"name"}, true));
                    }
                }.hoverMode(true)});
            } else {
                head.add(new Component[]{new WebMarkupContainer("detail").setVisible(false)});
            }
            head.add(new Component[]{stepLabel});
            if (!this.getStep().isIdle()) {
                head.add(new Component[]{new Label("status", this.getStep().getStatus().name().toLowerCase())});
            } else {
                head.add(new Component[]{new Label("status", "skipped")});
            }
            WebMarkupContainer trigger = new WebMarkupContainer("waitReasonTrigger");
            trigger.setVisible(this.getStep().isWaiting());
            head.add(new Component[]{trigger});
            final String stepPath = this.getStep().getPath().toString();
            trigger.add(new Behavior[]{new PopupBehavior(){

                @Override
                protected Component getPopup(String componentId) {
                    Map<String, List<String>> stepWaitReasons = BuildEngine.instance.getWaitReasons(Context.getBuild().getId(), stepPath);
                    if (stepWaitReasons != null && !stepWaitReasons.isEmpty()) {
                        return new StepWaitReasonsPanel(componentId, stepWaitReasons);
                    }
                    return new Label(componentId, "Unknown reason");
                }
            }});
            head.add(new Component[]{new Label("duration", (IModel)new AbstractReadOnlyModel<String>(){

                public String getObject() {
                    return DateUtils.formatDuration(StepView.this.getStep().getDuration());
                }
            }){

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(StepView.this.getStep().getDuration() != null);
                }
            }});
            if (this.getStep().getNodeAddress() != null) {
                nodeLink = new BookmarkablePageLink("nodeLink", GridPage.class, GridPage.params4(this.getStep().getNodeAddress()));
                nodeLink.add(new Component[]{new Label("name", this.getStep().getNodeAddress())});
                head.add(new Component[]{nodeLink});
                PageParameters params = new PageParameters();
                params.set(0, (Object)Context.getConfiguration().getId());
                params.set(1, (Object)this.getStep().getNodeAddress());
                head.add(new Component[]{new BookmarkablePageLink("nodeWorkspaceLink", WorkspacePage.class, params)});
            } else {
                nodeLink = new WebMarkupContainer("nodeLink");
                nodeLink.add(new Component[]{new Label("name")});
                nodeLink.setVisible(false);
            }
            head.add(new Component[]{nodeLink});
            final boolean logAccessible = SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_BUILD_LOG.name());
            Link<Void> logLink = new Link<Void>("logLink"){

                public void onClick() {
                    this.setResponsePage((Page)new StepLogPage(Context.getBuild().getId(), path));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(logAccessible && !StepView.this.getStep().isIdle());
                }
            };
            logLink.setPopupSettings(new PopupSettings("popup", 12));
            head.add(new Component[]{logLink});
            this.add(new Component[]{head});
            if (this.getStep() instanceof FailSafeStep) {
                body = new Label("body", this.getStep().getDescription());
            } else if (this.getStep() instanceof SequentialStep) {
                body = new SerialChildrenLayout("body");
            } else if (this.getStep() instanceof ParallelStep) {
                body = new ParallelChildrenLayout("body");
            } else if (this.getStep().getRuntime().getCustomData() != null) {
                body = this.getStep().renderCustomRuntimeData("body", this.getStep().getRuntime().getCustomData());
                if (body == null) {
                    body = new WebMarkupContainer("body");
                }
            } else {
                body = new WebMarkupContainer("body");
            }
            this.add(new Component[]{body});
        }

        private Step getStep() {
            return (Step)this.getDefaultModelObject();
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            String cssClass = tag.getAttribute("class");
            cssClass = cssClass != null ? cssClass + " step" : " step";
            Configuration current = Context.getConfiguration();
            String stepName = this.getStep().getPath().getLastElement().getStepName();
            Configuration declarer = current.findStepDeclarer(stepName);
            if (declarer != null && !current.getId().equals(declarer.getId())) {
                cssClass = cssClass + " inherited";
            }
            cssClass = this.getStep() instanceof FailSafeStep ? cssClass + " error" : cssClass + " " + this.getStep().getStatus().name().toLowerCase();
            if (this.getStep() instanceof SequentialStep) {
                cssClass = cssClass + " sequential";
            } else if (this.getStep() instanceof ParallelStep) {
                cssClass = cssClass + " parallel";
            }
            if (this.getStep().isMaster()) {
                cssClass = cssClass + " master";
            }
            tag.put("class", (CharSequence)cssClass);
        }

        private List<StepPath> getChildren() {
            Build build = Context.getBuild();
            ArrayList<StepPath> paths = new ArrayList<StepPath>();
            for (Step each : build.getSteps()) {
                paths.add(each.getPath());
            }
            return this.getStep().getPath().findChildren(paths);
        }

        private class SerialChildrenLayout
        extends Fragment {
            public SerialChildrenLayout(String id) {
                super(id, "sequentialFrag", (MarkupContainer)StepStatusPanel.this);
                this.add(new Component[]{new ListView<StepPath>("children", StepView.this.getChildren()){

                    protected void populateItem(ListItem<StepPath> item) {
                        item.add(new Component[]{new StepView("step", (StepPath)item.getModelObject())});
                    }
                }});
            }
        }

        private class ParallelChildrenLayout
        extends Fragment {
            public ParallelChildrenLayout(String id) {
                super(id, "parallelFrag", (MarkupContainer)StepStatusPanel.this);
                RepeatingView childrenView = new RepeatingView("children");
                for (StepPath child : StepView.this.getChildren()) {
                    childrenView.add(new Component[]{new StepView(childrenView.newChildId(), child)});
                }
                this.add(new Component[]{childrenView});
            }
        }
    }
}

