/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.log.BuildLog;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.web.component.LogPanel;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.build.LiveLogPanel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StepLogPage
extends BasePage {
    private Long buildId;
    private StepPath stepPath;

    public StepLogPage(Long buildId, StepPath stepPath) {
        this.buildId = buildId;
        this.stepPath = stepPath;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        if (((Build)BuildManager.instance.load(this.buildId)).isFinished()) {
            this.add(new Component[]{new LogPanel("logPanel", (IModel<? extends Log>)new Model((Serializable)new BuildLog(this.buildId, this.stepPath)), false)});
        } else {
            this.add(new Component[]{new LiveLogPanel("logPanel", this.buildId, this.stepPath)});
        }
    }

    @Override
    protected boolean isAuthorized() {
        return SecurityHelper.hasPermission(((Build)BuildManager.instance.load(this.buildId)).getConfiguration(), ConfigurationPermission.ACCESS_BUILD_LOG.name());
    }
}

