/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.PromoteOptionManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.PromoteOption;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.ContextAware;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.dashboard.GadgetPanel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromoteOptionEdit
extends Panel
implements ContextAware {
    private static final Logger logger = LoggerFactory.getLogger(PromoteOptionEdit.class);
    private Build build;
    private Promotion promotion;
    private Component previous;

    public PromoteOptionEdit(String panelId, Promotion promotion, Component previous) {
        super(panelId);
        this.promotion = promotion;
        this.previous = previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInitialize() {
        PromoteOption promoteOption;
        super.onInitialize();
        Class<?> variablePromptBeanClass = this.promotion.getVariablePromptBeanClass(Context.getBuild());
        HashMap<String, String> variableValues = null;
        if (Context.getUser() != null && (promoteOption = PromoteOptionManager.instance.get(Context.getUser(), Context.getConfiguration(), this.promotion.getName())) != null) {
            variableValues = promoteOption.getVariables();
            for (String key : variableValues.keySet()) {
                try {
                    Method getter = BeanUtils.getGetter(variablePromptBeanClass, key);
                    if (getter.getAnnotation(Password.class) == null) continue;
                    variableValues.put(key, StringUtils.decrypt((String)variableValues.get(key)));
                }
                catch (Exception e) {}
            }
        }
        if (variableValues == null) {
            variableValues = new HashMap<String, String>();
        }
        for (Field field : variablePromptBeanClass.getFields()) {
            if (!VariableBeanHelper.isPromptField(field)) continue;
            Variable var = this.promotion.getVar(field.getName());
            Validate.notNull((Object)var);
            Configuration configuration = null;
            if (var.getConfigurationId() != null) {
                configuration = (Configuration)ConfigurationManager.instance.load(var.getConfigurationId());
            }
            if (configuration != null) {
                Context.push(configuration);
            }
            try {
                if (variableValues.containsKey(field.getName()) && var.getPromptSetting().isRemember()) continue;
                variableValues.put(field.getName(), var.getValue());
            }
            finally {
                if (configuration != null) {
                    Context.pop();
                }
            }
        }
        Object variableBean = ClassUtils.instantiateClass(variablePromptBeanClass, new Object[0]);
        for (Method getter : BeanUtils.getGetters(variablePromptBeanClass)) {
            if (getter.getAnnotation(Editable.class) == null) continue;
            Method setter = BeanUtils.getSetter(getter);
            TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
            String varName = this.getVarName(this.promotion, BeanUtils.getPropertyName(getter));
            String varValue = (String)variableValues.get(varName);
            if (typeConverter != null) {
                if (getter.getReturnType() == Date.class && varValue != null && ((varValue = varValue.trim()).contains(" +") || varValue.contains(" -"))) {
                    varValue = StringUtils.substringBeforeLast((String)varValue, (String)" ");
                }
                try {
                    setter.invoke(variableBean, typeConverter.toObject(getter.getReturnType(), varValue));
                }
                catch (Exception e) {
                    if (varValue == null) continue;
                    logger.error("Error setting default value for variable prompting.", (Throwable)e);
                }
                continue;
            }
            if (!StringUtils.isNotBlank((String)varValue)) continue;
            try {
                setter.invoke(variableBean, StringUtils.string2obj(varValue));
            }
            catch (Exception e) {
                if (varValue == null) continue;
                logger.error("Error setting default value for variable prompting.", (Throwable)e);
            }
        }
        final EditContext editContext = new EditContext(variableBean);
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    HashMap<String, String> variableMap = new HashMap<String, String>();
                    SimpleDateFormat sdf = new SimpleDateFormat("Z");
                    sdf.setTimeZone(Context.getTimeZone());
                    String timeZone = sdf.format(new Date());
                    for (EditContext.EditableProperty property : editContext.getProperties()) {
                        String varName = PromoteOptionEdit.this.getVarName(PromoteOptionEdit.this.promotion, property.getName());
                        Method getter = BeanUtils.getGetter(editContext.getBeanClass(), property.getName());
                        TypeConverter typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter);
                        if (typeConverter != null) {
                            if (getter.getReturnType() == Date.class && property.getValue() != null) {
                                variableMap.put(varName, ((String)property.getValue()).trim() + " " + timeZone);
                                continue;
                            }
                            variableMap.put(varName, (String)property.getValue());
                            continue;
                        }
                        if (property.getValue() != null) {
                            EditContext propertyEditContext = (EditContext)property.getValue();
                            Object propertyBean = ClassUtils.instantiateClass(propertyEditContext.getBeanClass(), new Object[0]);
                            propertyEditContext.update(propertyBean);
                            variableMap.put(varName, StringUtils.obj2string((Serializable)propertyBean));
                            continue;
                        }
                        variableMap.put(varName, null);
                    }
                    if (Context.getUser() != null) {
                        PromoteOption promoteOption = PromoteOptionManager.instance.get(Context.getUser(), Context.getConfiguration(), PromoteOptionEdit.this.promotion.getName());
                        if (promoteOption == null) {
                            promoteOption = new PromoteOption();
                            promoteOption.setName(PromoteOptionEdit.this.promotion.getName());
                            promoteOption.setConfiguration(Context.getConfiguration());
                            promoteOption.setUser(Context.getUser());
                        }
                        LinkedHashMap<String, String> variableMapToSave = new LinkedHashMap<String, String>();
                        for (Map.Entry entry : variableMap.entrySet()) {
                            Method getter = BeanUtils.getGetter(editContext.getBeanClass(), (String)entry.getKey());
                            if (getter.getAnnotation(Password.class) != null) {
                                variableMapToSave.put((String)entry.getKey(), StringUtils.encrypt((String)entry.getValue()));
                                continue;
                            }
                            variableMapToSave.put((String)entry.getKey(), (String)entry.getValue());
                        }
                        promoteOption.setVariables(variableMapToSave);
                        PromoteOptionManager.instance.save(promoteOption);
                    }
                    try {
                        Configuration configuration = PromoteOptionEdit.this.promotion.promote(Context.getBuild(), variableMap);
                        if (configuration != null) {
                            if (PromoteOptionEdit.this.previous == null) {
                                this.setResponsePage(ConfigurationOverview.class, ConfigurationPage.params4(configuration.getId()));
                            } else {
                                PromoteOptionEdit.this.replaceWith(PromoteOptionEdit.this.previous);
                                if (AjaxRequestTarget.get() != null) {
                                    AjaxRequestTarget.get().add(PromoteOptionEdit.this.previous);
                                }
                            }
                        } else if (PromoteOptionEdit.this.previous == null) {
                            this.setResponsePage(BuildPage.class, BuildPage.params4(Context.getBuild().getId()));
                        } else {
                            PromoteOptionEdit.this.replaceWith(PromoteOptionEdit.this.previous);
                            if (AjaxRequestTarget.get() != null) {
                                AjaxRequestTarget.get().add(PromoteOptionEdit.this.previous);
                            }
                        }
                        this.getSession().info((Serializable)((Object)"Promotion request has been queued."));
                    }
                    catch (QuickbuildException e) {
                        this.getSession().error((Serializable)((Object)e.getMessage()));
                        if (PromoteOptionEdit.this.previous == null) {
                            this.setResponsePage(BuildPage.class, BuildPage.params4(Context.getBuild().getId()));
                        } else {
                            PromoteOptionEdit.this.replaceWith(PromoteOptionEdit.this.previous);
                            if (AjaxRequestTarget.get() != null) {
                                AjaxRequestTarget.get().add(PromoteOptionEdit.this.previous);
                            }
                        }
                    }
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                    if (AjaxRequestTarget.get() != null) {
                        AjaxRequestTarget.get().add(new Component[]{PromoteOptionEdit.this});
                    }
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        if (this.findParent(GadgetPanel.class) == null) {
            form.add(new Component[]{new SubmitLink("submit")});
            form.add(new Component[]{new Link("cancel"){

                public void onClick() {
                    if (PromoteOptionEdit.this.previous == null) {
                        this.setResponsePage(BuildPage.class, BuildPage.params4(Context.getBuild().getId()));
                    } else {
                        PromoteOptionEdit.this.replaceWith(PromoteOptionEdit.this.previous);
                    }
                }
            }});
        } else {
            form.add(new Component[]{new AjaxSubmitLink("submit"){

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                }
            }});
            form.add(new Component[]{new AjaxLink("cancel"){

                public void onClick(AjaxRequestTarget target) {
                    if (PromoteOptionEdit.this.previous == null) {
                        this.setResponsePage(BuildPage.class, BuildPage.params4(Context.getBuild().getId()));
                    } else {
                        PromoteOptionEdit.this.replaceWith(PromoteOptionEdit.this.previous);
                        target.add(PromoteOptionEdit.this.previous);
                    }
                }
            }});
        }
        this.add(new Component[]{form});
    }

    private String getVarName(Promotion promotion, String propertyName) {
        if (promotion.getVar(propertyName) != null) {
            return propertyName;
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    @Override
    public Build getContext() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }
}

