/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.log.BuildLog;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.web.component.JavascriptText;
import com.pmease.quickbuild.web.component.LogPanel;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class LiveLogPanel
extends Panel {
    private Long buildId;
    private StepPath stepPath;
    private boolean showStep;

    public LiveLogPanel(String panelId, final Long buildId, final StepPath stepPath) {
        super(panelId);
        this.buildId = buildId;
        this.stepPath = stepPath;
        String title = stepPath != null ? "Live step log of " + stepPath : "Live build log";
        this.add(new Component[]{new Label("title", title)});
        this.add(new Component[]{new CheckBox("showStep", (IModel)new IModel<Boolean>(){

            public void detach() {
            }

            public Boolean getObject() {
                return LiveLogPanel.this.showStep;
            }

            public void setObject(Boolean object) {
                LiveLogPanel.this.showStep = object;
            }
        }){

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }
        }});
        this.add(new Component[]{new JavascriptText("script", (IModel<String>)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return String.format("$(document).ready(function() {  updateLog(%d, %s, {}, %b);});", buildId, stepPath != null ? "'" + StringEscapeUtils.escapeJavaScript((String)stepPath.toString()) + "'" : null, LiveLogPanel.this.showStep);
            }
        })});
    }

    private Build getBuild() {
        return (Build)BuildManager.instance.load(this.buildId);
    }

    protected void onBeforeRender() {
        if (this.getBuild().isFinished()) {
            this.replaceWith((Component)((Object)new LogPanel(this.getId(), (IModel<? extends Log>)new LoadableDetachableModel<Log>(){

                protected Log load() {
                    return new BuildLog(LiveLogPanel.this.buildId, LiveLogPanel.this.stepPath);
                }
            }, this.showStep)));
        }
        super.onBeforeRender();
    }
}

