/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.customcolumn.CustomColumnConfig;
import com.pmease.quickbuild.setting.configuration.customcolumn.build.BuildCustomColumn;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.build.BuildDurationPanel;
import com.pmease.quickbuild.web.component.build.BuildInfoPanel;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.BuildsTabState;
import com.pmease.quickbuild.web.page.build.FilterOption;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class HistoryBuildsPage
extends ConfigurationPage {
    private FilterOption filterOption;
    private Build.Status status;
    private SelectionColumn<Long> selectionColumn;
    private PageParameters params;

    public static PageParameters params4(Long configurationId, Build.Status status) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)configurationId);
        if (status != null) {
            params.set(1, (Object)status.name().toLowerCase());
        }
        return params;
    }

    public HistoryBuildsPage(PageParameters params) {
        super(params.get(0).toLong());
        this.params = params;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        if (this.params.get(1).toString() != null) {
            this.status = Build.Status.valueOf(this.params.get(1).toString().toUpperCase());
            this.setBuildsTabState(new BuildsTabState(this.getConfigurationId(), "all_" + this.params.get(1)));
        } else {
            this.status = null;
            this.setBuildsTabState(new BuildsTabState(this.getConfigurationId(), "all"));
        }
        final EditContext editContext = new EditContext(new FilterOption());
        Form<Void> form = new Form<Void>("optionForm"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    HistoryBuildsPage.this.filterOption = new FilterOption();
                    editContext.update(HistoryBuildsPage.this.filterOption);
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        this.add(new Component[]{form});
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        WebMarkupContainer operations = new WebMarkupContainer("operations"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.STOP_BUILD.name()) || SecurityHelper.hasPermission(ConfigurationPermission.DELETE_BUILD.name()));
            }
        };
        this.add(new Component[]{operations});
        operations.add(new Component[]{new Link<Void>("stopSelected"){

            public void onClick() {
                if (!HistoryBuildsPage.this.selectionColumn.getSelections().isEmpty()) {
                    boolean finishedFound = false;
                    boolean runningsFound = false;
                    for (Long buildId : HistoryBuildsPage.this.selectionColumn.getSelections()) {
                        Build build = (Build)BuildManager.instance.load(buildId);
                        if (build.isRunning()) {
                            runningsFound = true;
                            BuildEngine.instance.stopBuild(build.getId());
                            AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was stopped.");
                            continue;
                        }
                        finishedFound = true;
                    }
                    if (runningsFound) {
                        this.getSession().warn((Serializable)((Object)"Stop command issued. The build may take a while to be stopped."));
                    }
                    if (finishedFound) {
                        this.getSession().warn((Serializable)((Object)"Stop command ignored for finished builds."));
                    }
                    HistoryBuildsPage.this.selectionColumn.getSelections().clear();
                } else {
                    this.getSession().warn((Serializable)((Object)"Please select running builds to stop."));
                }
            }
        }.add(new Behavior[]{new ConfirmBehavior("Do you really want to stop selected builds?")})});
        Component[] componentArray = new Component[1];
        Link link = new Link<Void>("deleteSelected"){

            public void onClick() {
                if (!HistoryBuildsPage.this.selectionColumn.getSelections().isEmpty()) {
                    boolean runningsFound = false;
                    for (Long buildId : HistoryBuildsPage.this.selectionColumn.getSelections()) {
                        Build build = (Build)BuildManager.instance.load(buildId);
                        if (build.isRunning()) {
                            runningsFound = true;
                            continue;
                        }
                        BuildManager.instance.delete(build);
                        AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was deleted.");
                    }
                    if (runningsFound) {
                        this.getSession().warn((Serializable)((Object)"Builds can only be deleted after they are stopped."));
                    }
                    HistoryBuildsPage.this.selectionColumn.getSelections().clear();
                } else {
                    this.getSession().warn((Serializable)((Object)"Please select finished builds to delete."));
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.DELETE_BUILD.name()));
            }
        };
        componentArray[0] = link;
        operations.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected builds?")});
        Component[] componentArray2 = new Component[1];
        link = new Link<Void>("deleteAll"){

            public void onClick() {
                boolean runningsFound = false;
                SearchCriteria criteria = new SearchCriteria(HistoryBuildsPage.this.getCriterions());
                for (Build build : BuildManager.instance.search(criteria, 0, 0)) {
                    if (build.isRunning()) {
                        runningsFound = true;
                        continue;
                    }
                    BuildManager.instance.delete(build);
                }
                AuditManager.instance.audit(HistoryBuildsPage.this.getConfiguration(), "All finished builds were deleted.");
                if (runningsFound) {
                    this.getSession().warn((Serializable)((Object)"Running builds can only be deleted after they are stopped."));
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.DELETE_BUILD.name()));
            }
        };
        componentArray2[0] = link;
        operations.add(componentArray2);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all finished builds?")});
        this.add(new Component[]{new WebMarkupContainer("rss"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (HistoryBuildsPage.this.status != null) {
                    tag.put("href", (CharSequence)(Quickbuild.getInstance().getUrl() + "/rss_feed" + "/" + HistoryBuildsPage.this.getConfigurationId() + "/" + HistoryBuildsPage.this.status.name().toLowerCase()));
                    tag.put("title", (CharSequence)("RSS feed for " + HistoryBuildsPage.this.status.name().toLowerCase() + " builds"));
                } else {
                    tag.put("href", (CharSequence)(Quickbuild.getInstance().getUrl() + "/rss_feed" + "/" + HistoryBuildsPage.this.getConfigurationId()));
                    tag.put("title", (CharSequence)"RSS feed for all builds");
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(HistoryBuildsPage.this.filterOption == null || HistoryBuildsPage.this.filterOption.getVersion() == null && HistoryBuildsPage.this.filterOption.getUser() == null && HistoryBuildsPage.this.filterOption.getFromDate() == null && HistoryBuildsPage.this.filterOption.getToDate() == null);
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        if (SecurityHelper.hasPermission(ConfigurationPermission.DELETE_BUILD.name()) || SecurityHelper.hasPermission(ConfigurationPermission.STOP_BUILD.name())) {
            this.selectionColumn = new SelectionColumn();
            columns.add(this.selectionColumn);
        }
        columns.add(new EntityColumn(Build.class, "id", true));
        columns.add(new EntityColumn(Build.class, "version", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                final Long buildId = (Long)rowModel.getObject();
                cellItem.add(new Component[]{new BuildInfoPanel(componentId, (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                    public Build getObject() {
                        return (Build)BuildManager.instance.load(buildId);
                    }
                }).showAge(false).showDuration(false)});
            }
        });
        Build latestBuild = CacheManager.instance.getLatestBuild(this.getConfigurationId());
        if (latestBuild != null && latestBuild.getShortBranch() != null) {
            columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Branch"))){

                public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                    Build build = (Build)BuildManager.instance.load((Long)rowModel.getObject());
                    cellItem.add(new Component[]{new Label(componentId, build.getShortBranch())});
                }
            });
        }
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Master Node"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                Build build = (Build)BuildManager.instance.load((Long)rowModel.getObject());
                String masterNode = build.getMasterStep().getNodeAddress();
                cellItem.add(new Component[]{new BookmarkableTextLink(componentId, masterNode, GridPage.class, GridPage.params4(masterNode)).add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"link"))})});
            }
        });
        columns.add(new EntityColumn(Build.class, "beginDate", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                final Long buildId = (Long)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        return DateUtils.formatDateTime(((Build)BuildManager.instance.load(buildId)).getBeginDate());
                    }
                })});
            }
        });
        columns.add(new EntityColumn(Build.class, "duration", true){

            @Override
            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                final Long buildId = (Long)rowModel.getObject();
                cellItem.add(new Component[]{new BuildDurationPanel(componentId, (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                    public Build getObject() {
                        return (Build)BuildManager.instance.load(buildId);
                    }
                })});
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Triggered By"))){

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                Build build = (Build)BuildManager.instance.load((Long)rowModel.getObject());
                cellItem.add(new Component[]{new Label(componentId, build.getRequesterName())});
            }
        });
        CustomColumnConfig customColumnConfig = Context.getConfiguration().findCustomColumnConfig();
        if (customColumnConfig != null && customColumnConfig.getBuildCustomColumns() != null) {
            for (final BuildCustomColumn customField : customColumnConfig.getBuildCustomColumns()) {
                columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)customField.getName()))){

                    public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                        Build build = (Build)BuildManager.instance.load((Long)rowModel.getObject());
                        cellItem.add(new Component[]{new Label(componentId, customField.getValueProvider().getValue(build)).setEscapeModelStrings(false)});
                    }
                });
            }
        }
        DefaultDataTable dataTable = new DefaultDataTable("builds", columns, (ISortableDataProvider)new EntityProvider(Build.class, new SortParam("id", false)){

            @Override
            protected Criterion[] getCriterions() {
                return HistoryBuildsPage.this.getCriterions();
            }
        }, 25);
        dataTable.add(new Behavior[]{new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Build latestBuild = CacheManager.instance.getLatestBuild(HistoryBuildsPage.this.getConfigurationId());
                return latestBuild != null && latestBuild.getBeginDate().after(lastRefreshDate);
            }
        }});
        this.add(new Component[]{dataTable});
    }

    @Override
    protected PageParameters getPageParameters(Long configurationId) {
        String allWhich = this.getBuildsTabState().getAllWhich();
        if (allWhich == null) {
            allWhich = "";
        }
        if (allWhich.length() == 0) {
            return HistoryBuildsPage.params4(configurationId);
        }
        return HistoryBuildsPage.params4(configurationId, Build.Status.valueOf(allWhich.toUpperCase()));
    }

    private Criterion[] getCriterions() {
        ArrayList<Object> criterions = new ArrayList<Object>();
        criterions.add(Restrictions.eq((String)"configuration", (Object)this.getConfiguration()));
        if (this.status != null) {
            if (this.status != Build.Status.SUCCESSFUL) {
                criterions.add(Restrictions.eq((String)"status", (Object)((Object)this.status)));
            } else {
                criterions.add(Restrictions.or((Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.SUCCESSFUL)), (Criterion)Restrictions.eq((String)"status", (Object)((Object)Build.Status.RECOMMENDED))));
            }
        }
        if (this.filterOption != null) {
            if (this.filterOption.getVersion() != null) {
                if (this.filterOption.getVersion().indexOf(42) != -1) {
                    criterions.add(Restrictions.like((String)"version", (Object)this.filterOption.getVersion().replace('*', '%')));
                } else {
                    criterions.add(Restrictions.eq((String)"version", (Object)this.filterOption.getVersion()));
                }
            }
            if (this.filterOption.getUser() != null) {
                criterions.add(Restrictions.eq((String)"requester", (Object)this.filterOption.getUser()));
            }
            if (this.filterOption.getFromDate() != null) {
                criterions.add(Restrictions.ge((String)"beginDate", (Object)this.filterOption.getFromDate()));
            }
            if (this.filterOption.getToDate() != null) {
                criterions.add(Restrictions.le((String)"beginDate", (Object)this.filterOption.getToDate()));
            }
        }
        return criterions.toArray(new Criterion[criterions.size()]);
    }
}

