/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.PromoteOptionManager;
import com.pmease.quickbuild.extensionpoint.BuildListener;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.log.BuildLog;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.PromoteOption;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.variable.VariableBeanHelper;
import com.pmease.quickbuild.web.ContextAware;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.LogPanel;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.build.BuildLink;
import com.pmease.quickbuild.web.component.build.BuildProgressBar;
import com.pmease.quickbuild.web.component.build.BuildStatusPanel;
import com.pmease.quickbuild.web.component.build.BuildTextPanel;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import com.pmease.quickbuild.web.component.tabbedpanel.TabbedPanel;
import com.pmease.quickbuild.web.page.BuildsTabState;
import com.pmease.quickbuild.web.page.build.BuildOverview;
import com.pmease.quickbuild.web.page.build.LiveLogPanel;
import com.pmease.quickbuild.web.page.build.PromoteOptionEdit;
import com.pmease.quickbuild.web.page.build.StepStatusPanel;
import com.pmease.quickbuild.web.page.build.VariableValuesPanel;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.ConfigurationPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.visit.IVisit;

public class BuildPage
extends ConfigurationPage
implements ContextAware {
    private Long buildId;
    private String buildIdOrName;
    private String[] tabIds;
    private Map<String, String> panelParams;
    private IModel<Build> buildModel;

    private static String[] getTabIds(PageParameters params) {
        ArrayList<String> tabIds = new ArrayList<String>();
        for (int i = 1; i < 9; ++i) {
            String value = params.get(i).toString();
            if (value == null) continue;
            tabIds.add(value);
        }
        if (!tabIds.isEmpty()) {
            return tabIds.toArray(new String[tabIds.size()]);
        }
        return null;
    }

    private static Map<String, String> getPanelParams(PageParameters params) {
        HashMap<String, String> panelParams = new HashMap<String, String>();
        for (PageParameters.NamedPair pair : params.getAllNamed()) {
            if (NumberUtils.isNumber((String)pair.getKey())) continue;
            panelParams.put(pair.getKey(), pair.getValue());
        }
        if (!panelParams.isEmpty()) {
            return panelParams;
        }
        return null;
    }

    private static Long getConfigurationId(String buildId) {
        if (StringUtils.isBlank((String)buildId)) {
            throw new QuickbuildException("Url to access build is incorrect: build id is missing.");
        }
        int pos = buildId.indexOf(46);
        if (pos != -1) {
            return Long.valueOf(buildId.substring(0, pos));
        }
        BuildManager buildManager = Quickbuild.getInstance(BuildManager.class);
        return ((Build)buildManager.load(Long.valueOf(buildId))).getConfiguration().getId();
    }

    private static PageParameters params4(PageParameters params, String[] tabIds, Map<String, String> panelParams) {
        if (tabIds != null && tabIds.length >= 1) {
            params.set(1, (Object)tabIds[0]);
            if (tabIds.length >= 2) {
                params.set(2, (Object)tabIds[1]);
            }
        }
        if (panelParams != null) {
            for (Map.Entry<String, String> entry : panelParams.entrySet()) {
                params.add(entry.getKey(), (Object)entry.getValue());
            }
        }
        return params;
    }

    public static PageParameters params4(Long configurationId, String buildVersion) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)(configurationId + "." + buildVersion));
        return params;
    }

    public static PageParameters params4(Long configurationId, String buildVersion, String[] tabIds, Map<String, String> panelParams) {
        return BuildPage.params4(BuildPage.params4(configurationId, buildVersion), tabIds, panelParams);
    }

    public static PageParameters params4(Long configurationId, String buildVersion, String[] tabIds) {
        return BuildPage.params4(configurationId, buildVersion, tabIds, null);
    }

    public static PageParameters params4(Long buildId) {
        PageParameters params = new PageParameters();
        params.set(0, (Object)buildId);
        return params;
    }

    public static PageParameters params4(Long buildId, String[] tabIds, Map<String, String> panelParams) {
        return BuildPage.params4(BuildPage.params4(buildId), tabIds, panelParams);
    }

    public static PageParameters params4(Long buildId, String[] tabIds) {
        return BuildPage.params4(buildId, tabIds, null);
    }

    public BuildPage(PageParameters params) {
        super(BuildPage.getConfigurationId(params.get(0).toString()));
        Configuration configuration;
        Build build;
        this.buildIdOrName = params.get(0).toString();
        this.tabIds = BuildPage.getTabIds(params);
        this.panelParams = BuildPage.getPanelParams(params);
        int pos = this.buildIdOrName.indexOf(46);
        if (pos != -1) {
            this.setBuildsTabState(new BuildsTabState(this.getConfigurationId(), this.buildIdOrName.substring(pos + 1)));
        } else {
            this.buildId = Long.valueOf(this.buildIdOrName);
            this.setBuildsTabState(new BuildsTabState(this.getConfigurationId(), this.buildIdOrName));
        }
        if (this.buildId == null && (build = BuildManager.instance.get(configuration = (Configuration)ConfigurationManager.instance.load(this.getConfigurationId()), this.getBuildsTabState().getBuildIdOrVersion())) != null) {
            this.buildId = build.getId();
        }
        this.buildModel = new LoadableDetachableModel<Build>(){

            protected Build load() {
                if (BuildPage.this.buildId != null) {
                    Build build = BuildEngine.instance.getBuild(BuildPage.this.buildId);
                    if (build == null) {
                        build = (Build)BuildManager.instance.load(BuildPage.this.buildId);
                    }
                    build.setLatestAwareId(BuildPage.this.buildIdOrName);
                    return build;
                }
                return null;
            }
        };
    }

    private RefreshBehavior newRefreshBehavior() {
        return new RefreshBehavior(){

            @Override
            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                Pair<Build, Date> pair = CacheManager.instance.getActiveBuild(BuildPage.this.buildId);
                if (pair == null) {
                    return false;
                }
                if (pair.getSecond().after(lastRefreshDate)) {
                    if (pair.getFirst().isFinished()) {
                        BuildPage.this.setResponsePage(BuildPage.class, BuildPage.this.getPageParameters());
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected void onInitialize() {
        Fragment content;
        super.onInitialize();
        if (this.getBuild() != null) {
            content = new Fragment("content", "notNullFrag", (MarkupContainer)this);
            Build fromBuild = this.getBuild().getPromotedFrom();
            final Long fromBuildId = fromBuild == null ? null : fromBuild.getId();
            WebMarkupContainer buildHead = new WebMarkupContainer("buildHead");
            buildHead.add(new Behavior[]{this.newRefreshBehavior()});
            content.add(new Component[]{buildHead});
            WebMarkupContainer container = new WebMarkupContainer("fromBuild");
            container.add(new Behavior[]{new RefreshBehavior(){

                @Override
                public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                    if (fromBuildId == null) {
                        visit.dontGoDeeper();
                    }
                    return false;
                }
            }});
            container.setVisible(fromBuild != null);
            buildHead.add(new Component[]{container});
            container.add(new Component[]{new BuildStatusPanel("status", (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                public Build getObject() {
                    return (Build)BuildManager.instance.load(fromBuildId);
                }
            })});
            container.add(new Component[]{new BuildLink("link", (IModel)new AbstractReadOnlyModel<Build>(){

                public Build getObject() {
                    return (Build)BuildManager.instance.load(fromBuildId);
                }
            }, true, true){

                @Override
                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("title", (CharSequence)("Promoted from build " + this.getBuild().getVersion() + " of configuration " + this.getBuild().getConfiguration() + " by " + this.getBuild().getRequesterName()));
                }
            }});
            List toBuilds = (List)this.getBuild().getPromotedTo();
            Collections.sort(toBuilds, new Comparator<Build>(){

                @Override
                public int compare(Build build1, Build build2) {
                    return build2.getId().compareTo(build1.getId());
                }
            });
            Build toBuild = !toBuilds.isEmpty() ? (Build)toBuilds.get(0) : null;
            final Long toBuildId = toBuild != null ? toBuild.getId() : null;
            container = new WebMarkupContainer("toBuild");
            container.add(new Behavior[]{new RefreshBehavior(){

                @Override
                public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                    if (toBuildId == null) {
                        visit.dontGoDeeper();
                    }
                    return false;
                }
            }});
            container.setVisible(toBuild != null);
            buildHead.add(new Component[]{container});
            container.add(new Component[]{new BuildStatusPanel("status", (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                public Build getObject() {
                    return (Build)BuildManager.instance.load(toBuildId);
                }
            })});
            container.add(new Component[]{new BuildLink("link", (IModel)new AbstractReadOnlyModel<Build>(){

                public Build getObject() {
                    return (Build)BuildManager.instance.load(toBuildId);
                }
            }, true, true){

                @Override
                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("title", (CharSequence)("Promoted to build " + this.getBuild().getVersion() + " of configuration " + this.getBuild().getConfiguration() + " by " + this.getBuild().getRequesterName()));
                }
            }});
            WebMarkupContainer statusIcon = new WebMarkupContainer("status"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    Build.Status status = BuildPage.this.getBuild().getStatus();
                    if (status == Build.Status.RUNNING) {
                        tag.put("src", (CharSequence)"/images/spin-ball-big.gif");
                        tag.put("title", (CharSequence)"Build is running");
                    } else if (status == Build.Status.SUCCESSFUL) {
                        tag.put("src", (CharSequence)"/images/green-ball-big.gif");
                        tag.put("title", (CharSequence)"Build is successful");
                    } else if (status == Build.Status.CANCELLED) {
                        tag.put("src", (CharSequence)"/images/cancelled-big.gif");
                        tag.put("title", (CharSequence)"Build is cancelled");
                    } else if (status == Build.Status.TIMEOUT) {
                        tag.put("src", (CharSequence)"/images/timeout-big.gif");
                        tag.put("title", (CharSequence)"Build is timed out");
                    } else if (status == Build.Status.RECOMMENDED) {
                        tag.put("src", (CharSequence)"/images/star-big.gif");
                        tag.put("title", (CharSequence)"Build is recommended");
                    } else {
                        tag.put("src", (CharSequence)"/images/red-ball-big.gif");
                        tag.put("title", (CharSequence)"Build is failed");
                    }
                }
            };
            buildHead.add(new Component[]{statusIcon});
            buildHead.add(new Component[]{new BuildTextPanel("version", (IModel)new AbstractReadOnlyModel<Build>(){

                public Build getObject() {
                    return BuildPage.this.getBuild();
                }
            }){

                @Override
                protected String getText(Build build) {
                    return build.getVersion();
                }
            }});
            buildHead.add(new Component[]{new BuildProgressBar("progress", (IModel<Build>)new AbstractReadOnlyModel<Build>(){

                public Build getObject() {
                    return BuildPage.this.getBuild();
                }
            })});
            buildHead.add(new Component[]{new AjaxLink<Void>("stop"){

                public void onClick(AjaxRequestTarget target) {
                    BuildEngine.instance.stopBuild(BuildPage.this.getBuild().getId());
                    AuditManager.instance.audit(BuildPage.this.getBuild().getConfiguration(), "Build " + BuildPage.this.getBuild().getVersion() + "(#" + BuildPage.this.getBuild().getId() + ") was stopped.", null, null);
                    this.getSession().warn((Serializable)((Object)"Stop command issued. The build may take a while to be stopped."));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(BuildPage.this.getBuild().isRunning() && (SecurityHelper.hasPermission(ConfigurationPermission.STOP_BUILD.name()) || SecurityHelper.hasPermission(ConfigurationPermission.DELETE_BUILD.name())));
                }
            }.add(new Behavior[]{new ConfirmBehavior("Do you really want to stop this build?")})});
            buildHead.add(new Component[]{new Link<Void>("delete"){

                public void onClick() {
                    BuildManager.instance.delete(BuildPage.this.getBuild());
                    AuditManager.instance.audit(BuildPage.this.getBuild().getConfiguration(), "Build " + BuildPage.this.getBuild().getVersion() + " (#" + BuildPage.this.getBuild().getId() + ") was deleted.", null, null);
                    this.getSession().info((Serializable)((Object)"Build deleted. Displaying latest."));
                    this.setResponsePage(BuildPage.class, BuildPage.params4(BuildPage.this.getConfigurationId(), "latest"));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.DELETE_BUILD.name()) && !BuildPage.this.getBuild().isRunning());
                }
            }.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete this build?")})});
            this.addPromotionButtons((WebMarkupContainer)content, buildHead);
            buildHead.add(new Component[]{new Link<Void>("recommend"){

                public void onClick() {
                    Build build = BuildPage.this.getBuild();
                    build.setStatus(Build.Status.RECOMMENDED);
                    build.setStatusDate(new Date());
                    BuildManager.instance.save(build);
                    AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was recommended.");
                    for (BuildListener listener : PluginManager.instance.getExtensions(BuildListener.class)) {
                        listener.buildRecommended();
                    }
                    this.setResponsePage(BuildPage.class, BuildPage.this.getPageParameters());
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(BuildPage.this.getBuild().isSuccessful() && SecurityHelper.hasPermission(ConfigurationPermission.RECOMMEND_BUILD.name()));
                }
            }});
            buildHead.add(new Component[]{new Link<Void>("unrecommend"){

                public void onClick() {
                    Build build = BuildPage.this.getBuild();
                    build.setStatus(Build.Status.SUCCESSFUL);
                    build.setStatusDate(new Date());
                    BuildManager.instance.save(build);
                    AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was unrecommended.");
                    for (BuildListener listener : PluginManager.instance.getExtensions(BuildListener.class)) {
                        listener.buildUnRecommended();
                    }
                    this.setResponsePage(BuildPage.class, BuildPage.this.getPageParameters());
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(BuildPage.this.getBuild().isRecommended() && SecurityHelper.hasPermission(ConfigurationPermission.RECOMMEND_BUILD.name()));
                }
            }});
            buildHead.add(new Component[]{new IndicatingAjaxLink<Void>("describe"){

                public String getAjaxIndicatorMarkupId() {
                    return null;
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.MODIFY_BUILD.name()));
                }

                public void onClick(AjaxRequestTarget target) {
                    new Dialog("Edit Build Description"){

                        @Override
                        protected Component render(String id) {
                            Fragment fragment = new Fragment(id, "descriptionEditor", (MarkupContainer)BuildPage.this);
                            Form<Void> form = new Form<Void>("form"){

                                protected void onSubmit() {
                                    super.onSubmit();
                                    if (!SecurityHelper.hasPermission(ConfigurationPermission.MODIFY_BUILD.name())) {
                                        throw new AccessDeniedException();
                                    }
                                    if (BuildPage.this.getBuild().isFinished()) {
                                        BuildManager.instance.save(BuildPage.this.getBuild());
                                    } else {
                                        BuildEngine.instance.updateBuildDescription(BuildPage.this.getBuild().getId(), BuildPage.this.getBuild().getDescription());
                                    }
                                    AuditManager.instance.audit(BuildPage.this.getBuild().getConfiguration(), "Build " + BuildPage.this.getBuild().getVersion() + " (#" + BuildPage.this.getBuild().getId() + ") description was modified.");
                                    this.setResponsePage(BuildPage.class, BuildPage.params4(BuildPage.this.getPageParameters(), new String[]{"overview"}, (Map<String, String>)null));
                                }
                            };
                            form.add(new Component[]{new TextArea("description", (IModel)new IModel<String>(){

                                public String getObject() {
                                    return BuildPage.this.getBuild().getDescription();
                                }

                                public void setObject(String object) {
                                    BuildPage.this.getBuild().setDescription(object);
                                }

                                public void detach() {
                                }
                            })});
                            form.add(new Component[]{new AjaxLink<Void>("close"){

                                public void onClick(AjaxRequestTarget target) {
                                    this.close(target);
                                }
                            }});
                            fragment.add(new Component[]{form});
                            return fragment;
                        }
                    }.dialogClass("popup-editor").width(600).open(target);
                }
            }});
            buildHead.add(new Component[]{new Link<Void>("first"){

                public void onClick() {
                    Build firstBuild = CacheManager.instance.getFirstBuild(BuildPage.this.getConfigurationId());
                    Validate.notNull((Object)firstBuild);
                    this.setResponsePage(BuildPage.class, BuildPage.params4(firstBuild.getId()));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    Build firstBuild = CacheManager.instance.getFirstBuild(BuildPage.this.getConfigurationId());
                    Validate.notNull((Object)firstBuild);
                    this.setEnabled(!firstBuild.getId().equals(BuildPage.this.getBuild().getId()));
                }
            }});
            buildHead.add(new Component[]{new Link<Void>("prev"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (this.isEnabled()) {
                        String cssClasses = tag.getAttribute("class");
                        tag.put("class", (CharSequence)(cssClasses + " maskable"));
                    }
                }

                public void onClick() {
                    Build build = BuildPage.this.getBuild();
                    Build previousBuild = BuildManager.instance.getPrevious(build);
                    Validate.notNull((Object)previousBuild);
                    this.setResponsePage(BuildPage.class, BuildPage.params4(previousBuild.getId()));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    Build firstBuild = CacheManager.instance.getFirstBuild(BuildPage.this.getConfigurationId());
                    Validate.notNull((Object)firstBuild);
                    this.setEnabled(!firstBuild.getId().equals(BuildPage.this.getBuild().getId()));
                }
            }});
            buildHead.add(new Component[]{new Link<Void>("next"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (this.isEnabled()) {
                        String cssClasses = tag.getAttribute("class");
                        tag.put("class", (CharSequence)(cssClasses + " maskable"));
                    }
                }

                public void onClick() {
                    Build build = BuildPage.this.getBuild();
                    Build nextBuild = BuildManager.instance.getNext(build);
                    Validate.notNull((Object)nextBuild);
                    this.setResponsePage(BuildPage.class, BuildPage.params4(nextBuild.getId()));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    Build latestBuild = CacheManager.instance.getLatestBuild(BuildPage.this.getConfigurationId());
                    Validate.notNull((Object)latestBuild);
                    this.setEnabled(!latestBuild.getId().equals(BuildPage.this.getBuild().getId()));
                }
            }});
            buildHead.add(new Component[]{new Link<Void>("last"){

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    if (this.isEnabled()) {
                        String cssClasses = tag.getAttribute("class");
                        tag.put("class", (CharSequence)(cssClasses + " maskable"));
                    }
                }

                public void onClick() {
                    Build latestBuild = CacheManager.instance.getLatestBuild(BuildPage.this.getConfigurationId());
                    Validate.notNull((Object)latestBuild);
                    this.setResponsePage(BuildPage.class, BuildPage.params4(latestBuild.getId()));
                }

                protected void onConfigure() {
                    super.onConfigure();
                    Build latestBuild = CacheManager.instance.getLatestBuild(BuildPage.this.getConfigurationId());
                    Validate.notNull((Object)latestBuild);
                    this.setEnabled(!latestBuild.getId().equals(BuildPage.this.getBuild().getId()));
                }
            }});
            ArrayList<Tab> tabs = new ArrayList<Tab>();
            tabs.add(new Tab("Overview"){

                @Override
                public Panel getPanel(String panelId, Map<String, String> panelParams) {
                    return (Panel)new BuildOverview(panelId).add(new Behavior[]{BuildPage.this.newRefreshBehavior()});
                }
            });
            if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_BUILD_LOG.name())) {
                tabs.add(new Tab("Log"){

                    @Override
                    public Panel getPanel(String panelId, Map<String, String> panelParams) {
                        if (BuildPage.this.getBuild().isFinished()) {
                            return new LogPanel(panelId, (IModel<? extends Log>)new LoadableDetachableModel<BuildLog>(){

                                protected BuildLog load() {
                                    return new BuildLog(BuildPage.this.getBuild().getId());
                                }
                            }, false);
                        }
                        return new LiveLogPanel(panelId, BuildPage.this.getBuild().getId(), null);
                    }
                });
            }
            if (this.getBuild().isFinished()) {
                if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_BUILD_STEPS.name())) {
                    tabs.add(new Tab("Step Status"){

                        @Override
                        public Panel getPanel(String panelId, Map<String, String> panelParams) {
                            return new StepStatusPanel(panelId);
                        }
                    });
                }
                if (SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_BUILD_VARIABLES.name()) && !this.getBuild().getSecretAwareVariableValues().isEmpty()) {
                    tabs.add(new Tab("Variables"){

                        @Override
                        public Panel getPanel(String id, Map<String, String> params) {
                            return new VariableValuesPanel(id);
                        }
                    });
                }
            }
            ArrayList<BuildTabContribution> contributions = new ArrayList<BuildTabContribution>();
            for (BuildTabContribution extension : PluginManager.instance.getExtensions(BuildTabContribution.class)) {
                contributions.add(extension);
            }
            Collections.sort(contributions, new Comparator<BuildTabContribution>(){

                @Override
                public int compare(BuildTabContribution contrib1, BuildTabContribution contrib2) {
                    return contrib1.getOrder() - contrib2.getOrder();
                }
            });
            for (BuildTabContribution contrib : contributions) {
                List<Tab> contribTabs = contrib.getTabs();
                if (contribTabs == null) continue;
                tabs.addAll(contribTabs);
            }
            content.add(new Component[]{new TabbedPanel("buildTab", tabs, this.tabIds, this.panelParams){

                @Override
                protected WebMarkupContainer newTabLink(String linkId, String[] tabIds) {
                    PageParameters params = new PageParameters();
                    BuildsTabState state = BuildPage.this.getBuildsTabState();
                    Long buildId = state.getBuildId();
                    if (buildId != null) {
                        params.set(0, (Object)buildId);
                    } else {
                        String allWhich = state.getAllWhich();
                        if (allWhich != null) {
                            params.set(0, (Object)(BuildPage.this.getConfigurationId() + "." + "latest"));
                        } else {
                            params.set(0, (Object)(BuildPage.this.getConfigurationId() + "." + state.getBuildIdOrVersion()));
                        }
                    }
                    params.set(1, (Object)tabIds[0]);
                    if (tabIds.length > 1) {
                        params.set(2, (Object)tabIds[1]);
                    }
                    return new BookmarkablePageLink(linkId, BuildPage.class, params);
                }
            }.setOutputMarkupId(true)});
        } else {
            content = new Fragment("content", "nullFrag", (MarkupContainer)this);
        }
        this.add(new Component[]{content});
    }

    public Build getBuild() {
        return (Build)this.buildModel.getObject();
    }

    @Override
    public Configuration getConfiguration() {
        Build build = this.getBuild();
        if (build != null) {
            return build.getConfiguration();
        }
        return super.getConfiguration();
    }

    @Override
    public Build getContext() {
        Build build = this.getBuild();
        if (build == null) {
            build = new Build();
            build.setConfiguration(this.getConfiguration());
        }
        return build;
    }

    @Override
    protected void onDetach() {
        if (this.buildModel != null) {
            this.buildModel.detach();
        }
        super.onDetach();
    }

    private void addPromotionButtons(final WebMarkupContainer tabContainer, WebMarkupContainer buildHead) {
        final boolean promoteAuthorized = SecurityHelper.hasPermission(ConfigurationPermission.PROMOTE_BUILD.name());
        if (promoteAuthorized) {
            final ArrayList<Promotion> applicablePromotions = new ArrayList<Promotion>();
            final ArrayList<String> applicablePromotionNames = new ArrayList<String>();
            for (Promotion each : this.getConfiguration().findPromotions()) {
                if (!each.getCondition().satisfied(each)) continue;
                applicablePromotions.add(each);
                applicablePromotionNames.add(each.getName());
            }
            WebMarkupContainer promoteMenuTrigger = new WebMarkupContainer("promoteMenuTrigger");
            buildHead.add(new Component[]{promoteMenuTrigger});
            promoteMenuTrigger.add(new Behavior[]{new MenuBehavior(){

                @Override
                protected List<MenuItem> getMenuItems() {
                    ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
                    for (final String each : applicablePromotionNames) {
                        menuItems.add(new MenuItem(){

                            @Override
                            public Component render(String componentId) {
                                return new TextLink<Void>(componentId, each){

                                    public void onClick() {
                                        if (!promoteAuthorized) {
                                            throw new AccessDeniedException();
                                        }
                                        BuildPage.this.promote(tabContainer, applicablePromotions, each);
                                    }
                                };
                            }
                        });
                    }
                    return menuItems;
                }
            }});
            promoteMenuTrigger.setVisible(applicablePromotions.size() > 1);
            PromoteOption activeOption = null;
            if (Context.getUser() != null) {
                activeOption = PromoteOptionManager.instance.getActive(Context.getUser(), Context.getConfiguration());
            }
            final String[] activePromotionName = new String[]{activeOption != null ? activeOption.getName() : ""};
            if (!applicablePromotionNames.isEmpty() && !applicablePromotionNames.contains(activePromotionName[0])) {
                activePromotionName[0] = (String)applicablePromotionNames.get(0);
            }
            Link<Void> promoteLink = new Link<Void>("promote"){

                public void onClick() {
                    if (!promoteAuthorized) {
                        throw new AccessDeniedException();
                    }
                    BuildPage.this.promote(tabContainer, applicablePromotions, activePromotionName[0]);
                }
            };
            if (applicablePromotions.size() > 1) {
                promoteLink.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"promote left-round button"))});
            }
            buildHead.add(new Component[]{promoteLink});
            promoteLink.setVisible(!applicablePromotions.isEmpty());
            promoteLink.add(new Component[]{new Label("label", activePromotionName[0])});
        } else {
            buildHead.add(new Component[]{new WebMarkupContainer("promote")});
            buildHead.get("promote").setVisible(false);
            buildHead.add(new Component[]{new WebMarkupContainer("promoteMenuTrigger")});
            buildHead.get("promoteMenuTrigger").setVisible(false);
        }
    }

    private void promote(WebMarkupContainer container, List<Promotion> applicablePromotions, String promotionName) {
        Promotion promotion = null;
        for (Promotion each : applicablePromotions) {
            if (!each.getName().equals(promotionName)) continue;
            promotion = each;
            break;
        }
        if (promotion == null) {
            throw new QuickbuildException("No applicable promotion '" + promotionName + "' found.");
        }
        if (Context.getUser() != null) {
            PromoteOptionManager.instance.setActive(Context.getUser(), Context.getConfiguration(), promotionName);
        }
        if (VariableBeanHelper.hasPromptFields((promotion = (Promotion)ScriptEngine.instance.installInterpolator(promotion)).getVariablePromptBeanClass(this.getBuild()))) {
            PromoteOptionEdit editor = new PromoteOptionEdit("buildTab", promotion, null);
            editor.setBuild(this.getBuild());
            container.replace((Component)((Object)editor));
        } else {
            try {
                Configuration configuration = promotion.promote(Context.getBuild(), new HashMap<String, String>());
                if (configuration != null) {
                    this.setResponsePage(ConfigurationOverview.class, ConfigurationPage.params4(configuration.getId()));
                } else {
                    this.setResponsePage(BuildPage.class, BuildPage.params4(this.getBuild().getId()));
                }
                this.getSession().info((Serializable)((Object)"Promotion request has been queued."));
            }
            catch (QuickbuildException e) {
                this.setResponsePage(BuildPage.class, BuildPage.params4(this.getBuild().getId()));
                this.getSession().error((Serializable)((Object)e.getMessage()));
            }
        }
    }

    @Override
    protected PageParameters getPageParameters(Long configurationId) {
        BuildsTabState state = this.getBuildsTabState();
        Long buildId = state.getBuildId();
        if (buildId != null) {
            if (!configurationId.equals(state.getConfigurationId())) {
                return BuildPage.params4(configurationId, "latest");
            }
            return BuildPage.params4(buildId);
        }
        String reservedVersion = state.getReservedVersion();
        if (reservedVersion != null) {
            PageParameters params = new PageParameters();
            params.set(0, (Object)(configurationId + "." + reservedVersion));
            return params;
        }
        if (!configurationId.equals(state.getConfigurationId())) {
            return BuildPage.params4(configurationId, "latest");
        }
        return BuildPage.params4(configurationId, state.getBuildIdOrVersion());
    }

    @Override
    public String getPageTitle() {
        String pathName = this.getConfiguration().getPathName();
        if (this.getBuild() != null) {
            return "QuickBuild - " + pathName + " - " + this.getBuild().getVersion();
        }
        return "QuickBuild - " + pathName;
    }
}

