/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.build;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.support.PanelCreator;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.BuildDependence;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.customcolumn.CustomColumnConfig;
import com.pmease.quickbuild.setting.configuration.customcolumn.build.BuildCustomColumn;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.component.build.BuildDurationPanel;
import com.pmease.quickbuild.web.component.build.BuildErrorMessage;
import com.pmease.quickbuild.web.component.build.BuildListPanel;
import com.pmease.quickbuild.web.page.build.StepLogPage;
import com.pmease.quickbuild.web.page.build.StepStatusPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class BuildOverview
extends Panel {
    public BuildOverview(String panelId) {
        super(panelId);
        Label label = new Label("description", Context.getBuild().getDescription());
        label.setEscapeModelStrings(false);
        label.setVisible(Context.getBuild().getDescription() != null);
        this.add(new Component[]{label});
        WebMarkupContainer summary = new WebMarkupContainer("summary"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClasses = tag.getAttribute("class") + " ";
                Build.Status status = Context.getBuild().getStatus();
                cssClasses = status == Build.Status.SUCCESSFUL || status == Build.Status.RECOMMENDED ? cssClasses + "green" : (status == Build.Status.FAILED ? cssClasses + "red" : (status == Build.Status.CANCELLED || status == Build.Status.TIMEOUT ? cssClasses + "cyan" : (status == Build.Status.RUNNING ? cssClasses + "yellow" : cssClasses + "gray")));
                tag.put("class", (CharSequence)cssClasses);
            }
        };
        this.add(new Component[]{summary});
        WebMarkupContainer cancelTitle = new WebMarkupContainer("cancelTitle");
        cancelTitle.setVisible(Context.getBuild().isCancelled());
        summary.add(new Component[]{cancelTitle});
        WebMarkupContainer branchTitle = new WebMarkupContainer("branchTitle");
        branchTitle.setVisible(Context.getBuild().getShortBranch() != null);
        summary.add(new Component[]{branchTitle});
        summary.add(new Component[]{new Label("id", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild().getId();
            }
        })});
        summary.add(new Component[]{new Label("status", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return WordUtils.capitalize((String)Context.getBuild().getStatus().name().toLowerCase());
            }
        })});
        summary.add(new Component[]{new Label("branch", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild().getShortBranch();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getBuild().getShortBranch() != null);
            }
        }});
        summary.add(new Component[]{new Label("beginDate", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return DateUtils.formatDateTime(Context.getBuild().getBeginDate());
            }
        })});
        summary.add(new Component[]{new BuildDurationPanel("duration", (IModel<Build>)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild();
            }
        })});
        summary.add(new Component[]{new Label("requester", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild().getRequesterName();
            }
        })});
        summary.add(new Component[]{new Label("canceller", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild().getCancellerName();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getBuild().isCancelled());
            }
        }});
        WebMarkupContainer dependentLink = new WebMarkupContainer("dependentLink");
        dependentLink.add(new Component[]{new Label("dependentCount", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild().getDependents().size();
            }
        })});
        dependentLink.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Build build = Context.getBuild();
                if (build.getDependents().isEmpty()) {
                    return new Label(componentId, "No other build is using this build as dependency.");
                }
                return new BuildListPanel(componentId, (IModel<List<Build>>)new LoadableDetachableModel(){

                    protected Object load() {
                        ArrayList<Build> builds = new ArrayList<Build>();
                        for (BuildDependence dependency : Context.getBuild().getDependents()) {
                            builds.add(dependency.getDependent());
                        }
                        return builds;
                    }
                });
            }
        }.hoverMode(true)});
        summary.add(new Component[]{dependentLink});
        WebMarkupContainer dependencyLink = new WebMarkupContainer("dependencyLink");
        dependencyLink.add(new Component[]{new Label("dependencyCount", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return Context.getBuild().getDependencies().size();
            }
        })});
        dependencyLink.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                Build build = Context.getBuild();
                if (build.getDependencies().isEmpty()) {
                    return new Label(componentId, "This build does not use any dependencies from other builds.");
                }
                return new BuildListPanel(componentId, (IModel<List<Build>>)new LoadableDetachableModel(){

                    protected Object load() {
                        ArrayList<Build> builds = new ArrayList<Build>();
                        for (BuildDependence dependency : Context.getBuild().getDependencies()) {
                            builds.add(dependency.getDependency());
                        }
                        return builds;
                    }
                });
            }
        }.hoverMode(true)});
        summary.add(new Component[]{dependencyLink});
        CustomColumnConfig customColumnConfig = Context.getConfiguration().findCustomColumnConfig();
        List<Object> customColumns = customColumnConfig != null && customColumnConfig.getBuildCustomColumns() != null ? customColumnConfig.getBuildCustomColumns() : new ArrayList();
        summary.add(new Component[]{new ListView<BuildCustomColumn>("customColumnNames", customColumns){

            protected void populateItem(ListItem<BuildCustomColumn> item) {
                item.add(new Component[]{new Label("customColumnName", ((BuildCustomColumn)item.getModelObject()).getName())});
            }
        }});
        summary.add(new Component[]{new ListView<BuildCustomColumn>("customColumnValues", customColumns){

            protected void populateItem(ListItem<BuildCustomColumn> item) {
                item.add(new Component[]{new Label("customColumnValue", ((BuildCustomColumn)item.getModelObject()).getValueProvider().getValue(Context.getBuild())).setEscapeModelStrings(false)});
            }
        }});
        WebMarkupContainer errorContainer = new WebMarkupContainer("errorContainer"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getBuild().hasErrors() && Context.getBuild().isFinished());
            }
        };
        this.add(new Component[]{errorContainer});
        label = new BuildErrorMessage("error", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return Context.getBuild().getErrorMessage();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getBuild().getErrorMessage() != null);
            }
        };
        errorContainer.add(new Component[]{label});
        errorContainer.add(new Component[]{new ListView<StepErrorInfo>("steps", (IModel)new LoadableDetachableModel<List<StepErrorInfo>>(){

            protected List<StepErrorInfo> load() {
                ArrayList<StepErrorInfo> stepErrors = new ArrayList<StepErrorInfo>();
                for (Map.Entry<String, StepRuntime> entry : Context.getBuild().getStepRuntimes().entrySet()) {
                    if (entry.getValue().getErrorMessage() == null) continue;
                    StepErrorInfo info = new StepErrorInfo();
                    info.stepPath = StepPath.fromString(entry.getKey());
                    info.errorMessage = entry.getValue().getErrorMessage();
                    info.nodeAddress = entry.getValue().getNodeAddress();
                    stepErrors.add(info);
                }
                return stepErrors;
            }
        }){

            protected void populateItem(ListItem item) {
                final StepErrorInfo stepError = (StepErrorInfo)item.getModelObject();
                if (stepError.nodeAddress != null) {
                    item.add(new Component[]{new Label("name", stepError.stepPath.toString() + "@" + stepError.nodeAddress)});
                } else {
                    item.add(new Component[]{new Label("name", stepError.stepPath.toString())});
                }
                Link link = new Link("logLink"){

                    public void onClick() {
                        this.setResponsePage((Page)new StepLogPage(Context.getBuild().getId(), stepError.stepPath));
                    }

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_BUILD_LOG.name()));
                    }
                };
                link.setPopupSettings(new PopupSettings("popup", 12));
                item.add(new Component[]{link});
                BuildErrorMessage label = new BuildErrorMessage("error", (IModel<String>)new Model((Serializable)((Object)stepError.errorMessage)));
                item.add(new Component[]{label});
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!((List)this.getDefaultModelObject()).isEmpty());
            }
        }});
        if (Context.getBuild().isRunning() && SecurityHelper.hasPermission(ConfigurationPermission.ACCESS_BUILD_STEPS.name())) {
            this.add(new Component[]{new StepStatusPanel("stepStatus")});
        } else {
            WebMarkupContainer stepStatusContainer = new WebMarkupContainer("stepStatus");
            stepStatusContainer.setVisible(false);
            this.add(new Component[]{stepStatusContainer});
        }
        this.add(new Component[]{new ListView("contributions", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                List<BuildOverviewContribution> contributions = PluginManager.instance.getExtensions(BuildOverviewContribution.class);
                Collections.sort(contributions, new Comparator<BuildOverviewContribution>(){

                    @Override
                    public int compare(BuildOverviewContribution contrib1, BuildOverviewContribution contrib2) {
                        return contrib1.getOrder() - contrib2.getOrder();
                    }
                });
                ArrayList<PanelCreator> creators = new ArrayList<PanelCreator>();
                for (BuildOverviewContribution contrib : contributions) {
                    List<PanelCreator> contribCreators = contrib.getPanelCreators();
                    if (contribCreators == null) continue;
                    creators.addAll(contribCreators);
                }
                return creators;
            }
        }){

            protected void populateItem(ListItem item) {
                PanelCreator provider = (PanelCreator)item.getModelObject();
                item.add(new Component[]{provider.newPanel("panel").setRenderBodyOnly(true)});
            }
        }});
    }

    private static class StepErrorInfo
    implements Serializable {
        StepPath stepPath;
        String errorMessage;
        String nodeAddress;

        private StepErrorInfo() {
        }
    }
}

