/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.user;

import com.google.common.base.Objects;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.Constants;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.AjaxTextLink;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.MatchType;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.group.GroupEdit;
import com.pmease.quickbuild.web.page.administration.user.UserEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class UserManagement
extends AdministrationPage {
    private static final long serialVersionUID = 1L;
    private String shortcut = null;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Link<Void>("addNew"){
            private static final long serialVersionUID = 1L;

            public void onClick() {
                this.setResponsePage((Page)new UserEdit(new User()));
            }
        }});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new EntityColumn(User.class, "name", true).setCssClass("nowrap-text"));
        columns.add(new EntityColumn(User.class, "fullName", true).setCssClass("text"));
        columns.add(new EntityColumn(User.class, "email", true).setCssClass("nowrap-text"));
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Groups"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, final IModel<Long> rowModel) {
                Fragment fragment = new Fragment(componentId, "groupsFrag", (MarkupContainer)UserManagement.this);
                fragment.add(new Component[]{new ListView<Group>("groups", (IModel)new LoadableDetachableModel<List<Group>>(){
                    private static final long serialVersionUID = 1L;

                    protected List<Group> load() {
                        User user = (User)UserManager.instance.load((Long)rowModel.getObject());
                        ArrayList<Group> groups = new ArrayList<Group>();
                        for (Membership membership : user.getMemberships()) {
                            groups.add(membership.getGroup());
                        }
                        return groups;
                    }
                }){
                    private static final long serialVersionUID = 1L;

                    protected void populateItem(final ListItem<Group> item) {
                        final Group group = (Group)item.getModelObject();
                        item.add(new Component[]{new TextLink<Void>("link", group.getName()){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                this.setResponsePage((Page)new GroupEdit(group, new PageBack(){
                                    private static final long serialVersionUID = 1L;

                                    @Override
                                    public void go() {
                                        this.setResponsePage(UserManagement.class);
                                    }
                                }));
                            }
                        }});
                        item.add(new Component[]{new WebMarkupContainer("comma"){
                            private static final long serialVersionUID = 1L;

                            protected void onConfigure() {
                                super.onConfigure();
                                this.setVisible(item.getIndex() > 0);
                            }
                        }});
                    }
                }});
                cellItem.add(new Component[]{fragment});
            }

            public String getCssClass() {
                return "text";
            }
        });
        columns.add(new EntityColumn(User.class, "authenticator", true).setCssClass("nowrap-text"));
        columns.add(new AbstractColumn<Long>((IModel)new Model((Serializable)((Object)"Agent"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                GridNode userAgent = AgentManager.instance.getUserAgent((User)UserManager.instance.load((Long)rowModel.getObject()));
                cellItem.add(new Component[]{new Label(componentId, userAgent == null ? "" : userAgent.getAddress())});
            }
        });
        columns.add(new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Operations"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                cellItem.add(new Component[]{new OperationFragment(componentId, rowModel)});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        final WebMarkupContainer shortcutContainer = new WebMarkupContainer("shortcutContainer");
        shortcutContainer.setOutputMarkupId(true);
        this.add(new Component[]{shortcutContainer});
        final FilterableEntityProvider provider = new FilterableEntityProvider(User.class, new SortParam("name", true), new String[]{"name", "fullName", "email"});
        EntityDataTable dataTable = new EntityDataTable("users", columns, provider, 20){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getNoRecordMessage() {
                return "No User Found";
            }

            @Override
            public void onEvent(IEvent<?> sink) {
                if (sink.getPayload() instanceof SearchPatternChanged) {
                    super.onEvent(sink);
                    SearchPatternChanged e = (SearchPatternChanged)sink.getPayload();
                    UserManagement.this.shortcut = null;
                    e.getTarget().add(new Component[]{shortcutContainer});
                }
            }
        };
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)provider));
        dataTable.addTopToolbar(new SearchNavToolbar(dataTable));
        dataTable.addBottomToolbar(new SearchNavToolbar(dataTable));
        this.add(new Component[]{dataTable});
        shortcutContainer.add(new Component[]{new ListView<String>("shortcuts", Constants.CHAR_SHORTCUTS){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                final String c = (String)item.getModelObject();
                item.add(new Component[]{new AjaxTextLink<Void>("link", c){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        if (Objects.equal((Object)"#", (Object)c)) {
                            this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, null));
                            UserManagement.this.shortcut = null;
                        } else {
                            this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, c, MatchType.STARTWITH));
                            UserManagement.this.shortcut = c;
                        }
                        target.add(new Component[]{shortcutContainer});
                    }
                }});
                if (item.getIndex() == 0) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
                }
                if (item.getIndex() + 1 == this.getList().size()) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
                }
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)new AbstractReadOnlyModel<String>(){
                    private static final long serialVersionUID = 1L;

                    public String getObject() {
                        return Objects.equal((Object)UserManagement.this.shortcut, (Object)c) ? "current" : "";
                    }
                }, " ")});
            }
        }});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteFounded"){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick() {
                int size = provider.size();
                if (size == 0) {
                    this.getSession().warn((Serializable)((Object)"No user found!"));
                    return;
                }
                Session session = SessionManager.openSession();
                try {
                    Transaction tx = session.beginTransaction();
                    try {
                        Iterator<Long> it = provider.iterator(0, size);
                        while (it.hasNext()) {
                            Long id = it.next();
                            User u = (User)UserManager.instance.load(id);
                            if (u.isRoot()) {
                                this.getSession().warn((Serializable)((Object)"Can not delete the administrator account"));
                                continue;
                            }
                            UserManager.instance.delete(u);
                            AuditManager.instance.audit("Administration::User", "User '" + u.getName() + "' was deleted.", null, null);
                        }
                        SessionManager.getSession().flush();
                        tx.commit();
                    }
                    catch (Throwable t) {
                        tx.rollback();
                    }
                }
                finally {
                    SessionManager.closeSession();
                }
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all found users?")});
    }

    class OperationFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public OperationFragment(String id, IModel<Long> model) {
            super(id, "operationsFrag", (MarkupContainer)UserManagement.this);
            final User user = (User)UserManager.instance.load((Long)model.getObject());
            this.add(new Component[]{new Link<Void>("edit"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    this.setResponsePage((Page)new UserEdit(user));
                }
            }});
            this.add(new Component[]{new Link<Void>("copy"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    User newUser = UserManager.instance.copyAsNew((User)UserManager.instance.load(user.getId()));
                    this.setResponsePage((Page)new UserEdit(newUser));
                }
            }});
            AjaxLink<Void> deleteLink = new AjaxLink<Void>("delete"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    UserManager.instance.delete(UserManager.instance.load(user.getId()));
                    AuditManager.instance.audit("Administration::User", "User '" + user.getName() + "' was deleted.", null, null);
                    target.add(UserManagement.this.get("users"));
                }

                public void onConfigure() {
                    super.onConfigure();
                    this.setVisibilityAllowed(!user.isRoot());
                }
            };
            this.add(new Component[]{new Link<Void>("runAs"){
                private static final long serialVersionUID = 1L;

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisible(SecurityHelper.isAdmin());
                }

                public void onClick() {
                    WebSession.get().setUserId(user.getId());
                    this.getSession().info((Serializable)((Object)("Now run as user: " + user.getDisplayName())));
                }
            }});
            deleteLink.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to remove user: <b>" + user.getName() + "</b>?")});
            this.add(new Component[]{deleteLink});
        }
    }
}

