/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.user;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.user.MembershipEditBean;
import com.pmease.quickbuild.web.page.administration.user.UserManagement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class UserEdit
extends AdministrationPage {
    public UserEdit(final User user) {
        this.setDefaultModel((IModel)new LoadableDetachableModel<User>(){

            protected User load() {
                if (user.getId() != null) {
                    return (User)UserManager.instance.load(user.getId());
                }
                return user;
            }
        });
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        final EditContext editContext = new EditContext(this.getUser(), new String[]{"subscriptions"}, true);
        final ArrayList<Pair<String, EditContext>> pluginSettingEditContexts = new ArrayList<Pair<String, EditContext>>();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            if (!plugin.isEnabled() || plugin.getUserSettingClass() == null) continue;
            Object pluginSetting = plugin.getUserSetting(this.getUser(), false);
            if (pluginSetting == null) {
                try {
                    pluginSetting = plugin.getUserSettingClass().newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }
            pluginSettingEditContexts.add(new Pair<String, EditContext>(plugin.getId(), new EditContext(pluginSetting)));
        }
        final MembershipEditBean membershipBean = new MembershipEditBean();
        for (Membership membership : this.getUser().getMemberships()) {
            membershipBean.getGroups().add(membership.getGroup());
        }
        Collections.sort(membershipBean.getGroups(), new Comparator<Group>(){

            @Override
            public int compare(Group group1, Group group2) {
                return group1.getName().compareTo(group2.getName());
            }
        });
        final EditContext membershipEditContext = new EditContext(membershipBean);
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                boolean hasError = false;
                if (editContext.hasError()) {
                    hasError = true;
                }
                for (Pair pair : pluginSettingEditContexts) {
                    ((EditContext)pair.getSecond()).validate(false);
                    if (!((EditContext)pair.getSecond()).hasError()) continue;
                    hasError = true;
                }
                membershipEditContext.validate(false);
                if (membershipEditContext.hasError()) {
                    hasError = true;
                }
                if (!hasError) {
                    String previousAuditContent = !UserEdit.this.getUser().isNew() ? VersionedDocument.fromBean(UserEdit.this.getUser()).toXML() : null;
                    editContext.update(UserEdit.this.getUser());
                    User userWithSameName = UserManager.instance.get(UserEdit.this.getUser().getName());
                    if (userWithSameName != null && (UserEdit.this.getUser().isNew() || !userWithSameName.getId().equals(UserEdit.this.getUser().getId()))) {
                        editContext.getProperty("name").setError("This name is already used by another user.");
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    for (Pair pair : pluginSettingEditContexts) {
                        Object pluginSetting;
                        Plugin plugin = PluginManager.instance.getPlugin((String)pair.getFirst());
                        Validate.notNull((Object)plugin);
                        Validate.notNull(plugin.getUserSettingClass());
                        try {
                            pluginSetting = plugin.getUserSettingClass().newInstance();
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.wrapAsUnchecked(e);
                        }
                        ((EditContext)pair.getSecond()).update(pluginSetting);
                        UserEdit.this.getUser().getPluginSettingDOMs().put(plugin.getId(), VersionedDocument.fromBean(pluginSetting));
                    }
                    membershipEditContext.update(membershipBean);
                    UserManager.instance.save(UserEdit.this.getUser());
                    MembershipManager.instance.assign(UserEdit.this.getUser(), membershipBean.getGroups(), true);
                    if (previousAuditContent != null) {
                        AuditManager.instance.audit("Administration::User", "User '" + UserEdit.this.getUser().getName() + "' was modified.", VersionedDocument.fromBean(UserEdit.this.getUser()).toXML(), previousAuditContent);
                    } else {
                        AuditManager.instance.audit("Administration::User", "User '" + UserEdit.this.getUser().getName() + "' was added.");
                    }
                    this.setResponsePage(UserManagement.class);
                    this.getSession().info((Serializable)((Object)"Settings have been saved."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("userEditor", editContext)});
        RepeatingView pluginSettingEditorsView = new RepeatingView("pluginSettingEditors");
        for (Pair pair : pluginSettingEditContexts) {
            BeanEditor editor = new BeanEditor(pluginSettingEditorsView.newChildId(), (EditContext)pair.getSecond());
            pluginSettingEditorsView.add(new Component[]{editor});
        }
        form.add(new Component[]{pluginSettingEditorsView});
        form.add(new Component[]{new BeanEditor("membershipEditor", membershipEditContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                this.setResponsePage(UserManagement.class);
            }
        }});
        this.add(new Component[]{form});
    }

    private User getUser() {
        return (User)this.getDefaultModelObject();
    }
}

