/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.security;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.security.FailSafeAuthenticator;
import com.pmease.quickbuild.setting.system.SecuritySetting;
import com.pmease.quickbuild.setting.system.TrustUserNameInHttpHeader;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.security.AuthenticatorEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SecuritySettingPage
extends AdministrationPage {
    private SelectionColumn<Authenticator> selectionColumn = new SelectionColumn();

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                this.setResponsePage((Page)new AuthenticatorEdit(null, null));
            }
        }});
        Component[] componentArray = new Component[1];
        Link link = new Link<Void>("deleteSelected"){

            public void onClick() {
                SecuritySetting securitySetting = SettingManager.instance.getSecuritySettingDef();
                for (Authenticator authenticator : SecuritySettingPage.this.selectionColumn.getSelections()) {
                    Iterator<VersionedDocument> it = securitySetting.getAuthenticatorDOMs().iterator();
                    while (it.hasNext()) {
                        VersionedDocument dom = it.next();
                        if (!dom.getValue("name").equals(authenticator.getName())) continue;
                        it.remove();
                    }
                }
                SettingManager.instance.saveSecuritySetting(securitySetting);
                SecuritySettingPage.this.selectionColumn.getSelections().clear();
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete selected authenticators?")});
        Component[] componentArray2 = new Component[1];
        link = new Link<Void>("deleteAll"){

            public void onClick() {
                SecuritySetting securitySetting = SettingManager.instance.getSecuritySettingDef();
                securitySetting.getAuthenticatorDOMs().clear();
                SettingManager.instance.saveSecuritySetting(securitySetting);
                SecuritySettingPage.this.selectionColumn.getSelections().clear();
            }
        };
        componentArray2[0] = link;
        this.add(componentArray2);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all authenticators?")});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(this.selectionColumn);
        columns.add(new AbstractColumn<Authenticator>((IModel)new Model((Serializable)((Object)"Name"))){

            public void populateItem(Item<ICellPopulator<Authenticator>> cellItem, String componentId, IModel<Authenticator> rowModel) {
                final Authenticator authenticator = (Authenticator)rowModel.getObject();
                Fragment fragment = new Fragment(componentId, "authenticatorFrag", (MarkupContainer)SecuritySettingPage.this);
                fragment.add(new Component[]{new TextLink<Void>("link", authenticator.getName()){

                    public void onClick() {
                        this.setResponsePage((Page)new AuthenticatorEdit(authenticator.getName(), authenticator));
                    }
                }});
                fragment.add(new Component[]{new Link<Void>("copy"){

                    public void onClick() {
                        Authenticator newAuthenticator = (Authenticator)BeanUtils.clone(authenticator);
                        this.setResponsePage((Page)new AuthenticatorEdit(null, newAuthenticator));
                    }
                }});
                cellItem.add(new Component[]{fragment});
            }
        });
        columns.add(new AbstractColumn<Authenticator>((IModel)new Model((Serializable)((Object)"Type"))){

            public void populateItem(Item<ICellPopulator<Authenticator>> cellItem, String componentId, IModel<Authenticator> rowModel) {
                Authenticator authenticator = (Authenticator)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, EditorHelper.getName(authenticator.getClass()))});
                if (authenticator instanceof FailSafeAuthenticator) {
                    cellItem.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"red"))});
                }
                cellItem.add(new Behavior[]{new AttributeModifier("nowrap", (Serializable)((Object)"true"))});
            }
        });
        columns.add(new AbstractColumn<Authenticator>((IModel)new Model((Serializable)((Object)"Description"))){

            public void populateItem(Item<ICellPopulator<Authenticator>> cellItem, String componentId, IModel<Authenticator> rowModel) {
                Authenticator authenticator = (Authenticator)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, authenticator.getDescription())});
            }
        });
        columns.add(new AbstractColumn<Authenticator>((IModel)new Model((Serializable)((Object)"Disabled"))){

            public void populateItem(Item<ICellPopulator<Authenticator>> cellItem, String componentId, IModel<Authenticator> rowModel) {
                Authenticator authenticator = (Authenticator)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, authenticator.isDisabled() ? "yes" : "no")});
            }
        });
        this.add(new Component[]{new DefaultDataTable("authenticators", columns, (ISortableDataProvider)new DataProvider<Authenticator>(){

            public Iterator<? extends Authenticator> iterator(int first, int count) {
                return SettingManager.instance.getSecuritySettingDef().getAuthenticators(false).iterator();
            }

            public int size() {
                return SettingManager.instance.getSecuritySettingDef().getAuthenticatorDOMs().size();
            }
        }, Integer.MAX_VALUE)});
        final SecuritySetting securitySetting = SettingManager.instance.getSecuritySettingDef();
        final EditContext headerTrustContext = new EditContext(securitySetting.getTrustUserNameInHttpHeader());
        Form<Void> form = new Form<Void>("ssoForm"){

            protected void onSubmit() {
                super.onSubmit();
                headerTrustContext.validate(false);
                if (!headerTrustContext.hasError()) {
                    String previousAuditContent = VersionedDocument.fromBean(securitySetting).toXML();
                    TrustUserNameInHttpHeader headerTrustSetting = new TrustUserNameInHttpHeader();
                    headerTrustContext.update(headerTrustSetting);
                    securitySetting.setTrustUserNameInHttpHeader(headerTrustSetting);
                    SettingManager.instance.saveSecuritySetting(securitySetting);
                    AuditManager.instance.audit("Administration::System Setting", "Security setting was modified.", VersionedDocument.fromBean(securitySetting).toXML(), previousAuditContent);
                    this.getSession().info((Serializable)((Object)"Http header trust setting has been updated."));
                    this.setResponsePage(SecuritySettingPage.class);
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", headerTrustContext)});
        this.add(new Component[]{form});
    }
}

