/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.security;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.setting.system.SecuritySetting;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.security.AuthenticatorEditBean;
import com.pmease.quickbuild.web.page.administration.security.SecuritySettingPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;

public class AuthenticatorEdit
extends AdministrationPage {
    private String authenticatorName;
    private Authenticator authenticator;

    public AuthenticatorEdit(String authenticatorName, Authenticator authenticator) {
        this.authenticatorName = authenticatorName;
        this.authenticator = authenticator;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("authenticatorTitle", this.authenticatorName != null ? "Editing Authenticator" : "Defining New Authenticator")});
        final AuthenticatorEditBean bean = new AuthenticatorEditBean();
        bean.setAuthenticator(this.authenticator);
        final EditContext editContext = new EditContext(bean);
        Form<Void> form = new Form<Void>("form"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    editContext.update(bean);
                    Authenticator authenticator = bean.getAuthenticator();
                    VersionedDocument newDom = VersionedDocument.fromBean(authenticator);
                    EditContext authenticatorEditContext = (EditContext)editContext.getProperty("authenticator").getValue();
                    if (AuthenticatorEdit.this.authenticatorName == null) {
                        if (AuthenticatorEdit.this.getDom(authenticator.getName()) != null) {
                            authenticatorEditContext.getProperty("name").setError("This name is already used by another authenticator.");
                            this.getSession().error((Serializable)((Object)"Fix errors below"));
                            return;
                        } else {
                            AuthenticatorEdit.this.getSecuritySetting().getAuthenticatorDOMs().add(newDom);
                            SettingManager.instance.saveSecuritySetting(AuthenticatorEdit.this.getSecuritySetting());
                            this.getSession().info((Serializable)((Object)"Settings have been saved."));
                            this.setResponsePage(SecuritySettingPage.class);
                        }
                        return;
                    } else {
                        VersionedDocument dom = AuthenticatorEdit.this.getDom(AuthenticatorEdit.this.authenticatorName);
                        if (dom == null) throw new QuickbuildException("Authenticator '" + AuthenticatorEdit.this.authenticatorName + "' not found.");
                        if (!authenticator.getName().equals(AuthenticatorEdit.this.authenticatorName) && AuthenticatorEdit.this.getDom(authenticator.getName()) != null) {
                            authenticatorEditContext.getProperty("name").setError("This name is already used by another authenticator.");
                            this.getSession().error((Serializable)((Object)"Fix errors below"));
                            return;
                        } else {
                            dom.setWrapped(newDom.getWrapped());
                            SettingManager.instance.saveSecuritySetting(AuthenticatorEdit.this.getSecuritySetting());
                            this.getSession().info((Serializable)((Object)"Settings have been saved."));
                            this.setResponsePage(SecuritySettingPage.class);
                        }
                    }
                    return;
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below"));
                }
            }
        };
        PropertyEditor editor = new PropertyEditor("editor", AuthenticatorEditBean.class, editContext.getProperty("authenticator"));
        form.add(new Component[]{editor});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                this.setResponsePage(SecuritySettingPage.class);
            }
        }});
        this.add(new Component[]{form});
    }

    private VersionedDocument getDom(String authenticatorName) {
        for (VersionedDocument dom : this.getSecuritySetting().getAuthenticatorDOMs()) {
            if (!dom.getValue("name").equals(authenticatorName)) continue;
            return dom;
        }
        return null;
    }

    private SecuritySetting getSecuritySetting() {
        return SettingManager.instance.getSecuritySettingDef();
    }
}

