/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.plugin;

import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class PluginManagement
extends AdministrationPage {
    private WebMarkupContainer container;
    private static final ResourceReference LIVEFILTER_JS = new JavaScriptResourceReference(PluginManagement.class, "jquery.livefilter.js");

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.setDefaultModel((IModel)new LoadableDetachableModel(){

            protected Object load() {
                return PluginManager.instance.getPlugins();
            }
        });
        this.container = new WebMarkupContainer("pluginsContainer");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        ListView categories = new ListView("categories", Arrays.asList(PluginCategory.values())){

            protected void populateItem(ListItem item) {
                PluginCategory category = (PluginCategory)((Object)item.getModelObject());
                List plugins = PluginManagement.this.getPluginsOfCategory(category);
                if (plugins.isEmpty()) {
                    item.setVisible(false);
                } else {
                    item.add(new Component[]{new Label("categoryName", category.displayName())});
                    item.add(new Component[]{PluginManagement.this.createPluginList(plugins)});
                }
            }
        };
        this.container.add(new Component[]{categories});
    }

    private Component createPluginList(List<Plugin> plugins) {
        return new ListView("plugins", plugins){

            protected void populateItem(final ListItem item) {
                item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)(item.getIndex() % 2 == 0 ? "even" : "odd")))});
                Plugin plugin = (Plugin)item.getModelObject();
                Label nameLabel = new Label("name", plugin.getName());
                nameLabel.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)PluginManagement.this.getPluginStatus(plugin))), " ")});
                item.add(new Component[]{nameLabel});
                item.add(new Component[]{new Label("version", plugin.getVersion())});
                item.add(new Component[]{new Label("vendor", plugin.getVendor())});
                AjaxLink enableLink = new AjaxLink("enable"){

                    public void onClick(AjaxRequestTarget target) {
                        Plugin plugin = (Plugin)item.getModelObject();
                        if (plugin.getSettingClass() != null && plugin.getSetting(false) == null) {
                            this.getSession().warn((Serializable)((Object)"This plugin can not be enabled unless it is configured."));
                        } else {
                            plugin.setEnabled(true);
                            target.add(new Component[]{PluginManagement.this.container});
                        }
                    }
                };
                item.add(new Component[]{enableLink});
                enableLink.setVisible(!plugin.isEnabled());
                AjaxLink disableLink = new AjaxLink("disable"){

                    public void onClick(AjaxRequestTarget target) {
                        Plugin plugin = (Plugin)item.getModelObject();
                        plugin.setEnabled(false);
                        target.add(new Component[]{PluginManagement.this.container});
                    }
                };
                item.add(new Component[]{disableLink});
                disableLink.setVisible(plugin.isEnabled() && plugin.getCategory() != PluginCategory.SYSTEM);
                Link configureLink = new Link("configure"){

                    public void onClick() {
                        Plugin plugin = (Plugin)item.getModelObject();
                        this.setResponsePage((Page)plugin.getSettingEditPage());
                    }
                };
                configureLink.setVisible(plugin.getSettingClass() != null);
                item.add(new Component[]{configureLink});
            }
        };
    }

    private List<Plugin> getAllPlugins() {
        return (List)this.getDefaultModelObject();
    }

    private List<Plugin> getPluginsOfCategory(PluginCategory category) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (Plugin each : this.getAllPlugins()) {
            if (each.getCategory() != category) continue;
            plugins.add(each);
        }
        Collections.sort(plugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin p1, Plugin p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return plugins;
    }

    private String getPluginStatus(Plugin plugin) {
        if (plugin.getSettingClass() != null && plugin.getSetting(false) == null) {
            return "need-configure";
        }
        if (plugin.isEnabled()) {
            return "status-enabled";
        }
        return "status-disabled";
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavaScriptReference(LIVEFILTER_JS);
        response.renderOnDomReadyJavaScript("$('.records.plugins').liveFilter('#plugin-filter-field', 'tr')");
    }
}

