/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.plugin;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.administration.plugin.AbstractPluginSettingEditPage;
import com.pmease.quickbuild.web.page.administration.plugin.PluginManagement;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;

public class DefaultPluginSettingEditPage
extends AbstractPluginSettingEditPage {
    private Plugin plugin;

    public DefaultPluginSettingEditPage(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        final EditContext editContext = new EditContext(this.getPluginSetting());
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    Object pluginSetting = DefaultPluginSettingEditPage.this.getPluginSetting();
                    String previousAuditContent = VersionedDocument.fromBean(pluginSetting).toXML();
                    editContext.update(pluginSetting);
                    DefaultPluginSettingEditPage.this.plugin.saveSetting(pluginSetting);
                    AuditManager.instance.audit("Administration::Plugin", "Plugin '" + DefaultPluginSettingEditPage.this.plugin.getName() + "' setting was modified.", VersionedDocument.fromBean(pluginSetting).toXML(), previousAuditContent);
                    this.setResponsePage(PluginManagement.class);
                    this.getSession().info((Serializable)((Object)"Settings have been saved."));
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below"));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("objectEditor", editContext)});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                this.setResponsePage(PluginManagement.class);
            }
        }});
        this.add(new Component[]{form});
    }

    private Object getPluginSetting() {
        Object pluginSetting = this.plugin.getSetting(false);
        if (pluginSetting != null) {
            return pluginSetting;
        }
        try {
            return this.plugin.getSettingClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

