/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.permissionset;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.PermissionSetManager;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.permissionset.PermissionSetEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PermissionSetManagement
extends AdministrationPage {
    private static final long serialVersionUID = 1L;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                this.setResponsePage((Page)new PermissionSetEdit(new PermissionSet(), new PageBack(){

                    @Override
                    public void go() {
                        this.setResponsePage(PermissionSetManagement.class);
                    }
                }));
            }
        }});
        ArrayList columns = Lists.newArrayList();
        columns.add(new EntityColumn(PermissionSet.class, "name", true).setCssClass("text"));
        columns.add(new EntityColumn(PermissionSet.class, "permissions", false){

            @Override
            protected Component createItemComponent(String componentId, IModel<Long> rowModel) {
                PermissionSet permissionSet = (PermissionSet)PermissionSetManager.instance.load((Long)rowModel.getObject());
                return new Label(componentId, StringUtils.join(permissionSet.getPermissions(), (String)", "));
            }
        }.setCssClass("text"));
        columns.add(new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Operations"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                cellItem.add(new Component[]{new OperationFragment(componentId, rowModel)});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        final FilterableEntityProvider provider = new FilterableEntityProvider(PermissionSet.class, new SortParam("name", true), new String[]{"name"});
        EntityDataTable dataTable = new EntityDataTable("permissionSets", columns, provider, 20){

            @Override
            protected String getNoRecordMessage() {
                return "No Permission Sets Found";
            }
        };
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)provider));
        this.add(new Component[]{dataTable});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteFounded"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick() {
                int size = provider.size();
                if (size == 0) {
                    this.getSession().warn((Serializable)((Object)"No permission sets found!"));
                    return;
                }
                Session session = SessionManager.openSession();
                try {
                    Transaction tx = session.beginTransaction();
                    try {
                        Iterator<Long> it = provider.iterator(0, size);
                        while (it.hasNext()) {
                            Long id = it.next();
                            PermissionSet permissionSet = (PermissionSet)PermissionSetManager.instance.load(id);
                            PermissionSetManager.instance.delete(permissionSet);
                            AuditManager.instance.audit("Administration::Permission Set", "Permission set '" + permissionSet.getName() + "' was deleted.");
                        }
                        SessionManager.getSession().flush();
                        tx.commit();
                    }
                    catch (Throwable t) {
                        tx.rollback();
                    }
                }
                finally {
                    SessionManager.closeSession();
                }
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all found permission sets?")});
    }

    class OperationFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public OperationFragment(String id, IModel<Long> model) {
            super(id, "operationsFrag", (MarkupContainer)PermissionSetManagement.this);
            final PermissionSet permissionSet = (PermissionSet)PermissionSetManager.instance.load((Long)model.getObject());
            this.add(new Component[]{new Link<Void>("edit"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    this.setResponsePage((Page)new PermissionSetEdit(permissionSet, new PageBack(){

                        @Override
                        public void go() {
                            this.setResponsePage(PermissionSetManagement.class);
                        }
                    }));
                }
            }});
            this.add(new Component[]{new Link<Void>("copy"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    PermissionSet newPermissionSet = PermissionSetManager.instance.copyAsNew((PermissionSet)PermissionSetManager.instance.load(permissionSet.getId()));
                    this.setResponsePage((Page)new PermissionSetEdit(newPermissionSet, new PageBack(){

                        @Override
                        public void go() {
                            this.setResponsePage(PermissionSetManagement.class);
                        }
                    }));
                }
            }});
            AjaxLink<Void> link = new AjaxLink<Void>("delete"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    PermissionSetManager.instance.delete(PermissionSetManager.instance.load(permissionSet.getId()));
                    AuditManager.instance.audit("Administration::Permission Set", "Permission set '" + permissionSet.getName() + "' was deleted.");
                    target.add(PermissionSetManagement.this.get("permissionSets"));
                }
            };
            link.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to delete permission set: " + permissionSet.getName() + "?")});
            this.add(new Component[]{link});
        }
    }
}

