/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.permissionset;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.PermissionSetManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class PermissionSetEdit
extends AdministrationPage {
    private PermissionSet permissionSet;
    private PageBack pageback;

    public PermissionSetEdit(PermissionSet permissionSet, PageBack pageback) {
        this.permissionSet = permissionSet;
        this.pageback = pageback;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.setDefaultModel((IModel)new LoadableDetachableModel<PermissionSet>(){

            protected PermissionSet load() {
                if (!PermissionSetEdit.this.permissionSet.isNew()) {
                    return (PermissionSet)PermissionSetManager.instance.load(PermissionSetEdit.this.permissionSet.getId());
                }
                return PermissionSetEdit.this.permissionSet;
            }
        });
        final EditContext editContext = new EditContext(this.getPermissionSet());
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    String previousAuditContent = !PermissionSetEdit.this.getPermissionSet().isNew() ? VersionedDocument.fromBean(PermissionSetEdit.this.getPermissionSet()).toXML() : null;
                    editContext.update(PermissionSetEdit.this.getPermissionSet());
                    PermissionSet permissionSetWithSameName = PermissionSetManager.instance.get(PermissionSetEdit.this.getPermissionSet().getName());
                    if (permissionSetWithSameName != null && (PermissionSetEdit.this.getPermissionSet().isNew() || !permissionSetWithSameName.getId().equals(PermissionSetEdit.this.getPermissionSet().getId()))) {
                        editContext.getProperty("name").setError("This name is already used by another permission set.");
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    PermissionSetManager.instance.save(PermissionSetEdit.this.getPermissionSet());
                    if (previousAuditContent != null) {
                        AuditManager.instance.audit("Administration::Permission Set", "Permission set '" + PermissionSetEdit.this.getPermissionSet().getName() + "' was modified.", VersionedDocument.fromBean(PermissionSetEdit.this.getPermissionSet()).toXML(), previousAuditContent);
                    } else {
                        AuditManager.instance.audit("Administration::Permission Set", "Permission set '" + PermissionSetEdit.this.getPermissionSet().getName() + "' was added.");
                    }
                    this.getSession().info((Serializable)((Object)"Settings have been saved."));
                    PermissionSetEdit.this.pageback.go();
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                PermissionSetEdit.this.pageback.go();
            }
        }});
        this.add(new Component[]{form});
    }

    public PermissionSet getPermissionSet() {
        return (PermissionSet)this.getDefaultModelObject();
    }
}

