/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.group;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.util.Constants;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.AjaxTextLink;
import com.pmease.quickbuild.web.component.datatablesupport.BooleanColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityColumn;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.MatchType;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.group.GroupEdit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class GroupManagement
extends AdministrationPage {
    private static final long serialVersionUID = 1L;
    private String shortcut = null;

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Link<Void>("addNew"){

            public void onClick() {
                this.setResponsePage((Page)new GroupEdit(new Group(), new PageBack(){

                    @Override
                    public void go() {
                        this.setResponsePage(GroupManagement.class);
                    }
                }));
            }
        }});
        ArrayList columns = Lists.newArrayList();
        columns.add(new EntityColumn(Group.class, "name", true).setCssClass("text"));
        columns.add(new BooleanColumn(Group.class, "admin", true, "Admin Group").setCssClass("text"));
        columns.add(new BooleanColumn(Group.class, "forceHttps", true, "Force Https").setCssClass("text"));
        columns.add(new BooleanColumn(Group.class, "agentAllowed", true, "Allow User Agent").setCssClass("text"));
        columns.add(new BooleanColumn(Group.class, "systemLogAllowed", true, "Allow System Log").setCssClass("text"));
        columns.add(new BooleanColumn(Group.class, "nodeAttributesAllowed", true, "Allow Node Attributes").setCssClass("text"));
        columns.add(new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Operations"))){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Long>> cellItem, String componentId, IModel<Long> rowModel) {
                cellItem.add(new Component[]{new OperationFragment(componentId, rowModel)});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        final FilterableEntityProvider provider = new FilterableEntityProvider(Group.class, new SortParam("name", true), new String[]{"name"});
        final WebMarkupContainer shortcutContainer = new WebMarkupContainer("shortcutContainer");
        shortcutContainer.setOutputMarkupId(true);
        this.add(new Component[]{shortcutContainer});
        EntityDataTable dataTable = new EntityDataTable("groups", columns, provider, 20){

            @Override
            protected String getNoRecordMessage() {
                return "No Group Found";
            }

            @Override
            public void onEvent(IEvent<?> sink) {
                if (sink.getPayload() instanceof SearchPatternChanged) {
                    super.onEvent(sink);
                    SearchPatternChanged e = (SearchPatternChanged)sink.getPayload();
                    GroupManagement.this.shortcut = null;
                    e.getTarget().add(new Component[]{shortcutContainer});
                }
            }
        };
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)provider));
        dataTable.addTopToolbar(new SearchNavToolbar(dataTable));
        dataTable.addBottomToolbar(new SearchNavToolbar(dataTable));
        this.add(new Component[]{dataTable});
        shortcutContainer.add(new Component[]{new ListView<String>("shortcuts", Constants.CHAR_SHORTCUTS){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                final String c = (String)item.getModelObject();
                item.add(new Component[]{new AjaxTextLink<Void>("link", c){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        if (Objects.equal((Object)"#", (Object)c)) {
                            this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, null));
                            GroupManagement.this.shortcut = null;
                        } else {
                            this.send((IEventSink)this.getPage(), Broadcast.DEPTH, SearchPatternChanged.of(target, c, MatchType.STARTWITH));
                            GroupManagement.this.shortcut = c;
                        }
                        target.add(new Component[]{shortcutContainer});
                    }
                }});
                if (item.getIndex() == 0) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
                }
                if (item.getIndex() + 1 == this.getList().size()) {
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
                }
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)new AbstractReadOnlyModel<String>(){
                    private static final long serialVersionUID = 1L;

                    public String getObject() {
                        return Objects.equal((Object)GroupManagement.this.shortcut, (Object)c) ? "current" : "";
                    }
                }, " ")});
            }
        }});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("deleteFounded"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick() {
                int size = provider.size();
                if (size == 0) {
                    this.getSession().warn((Serializable)((Object)"No groups found!"));
                    return;
                }
                Session session = SessionManager.openSession();
                try {
                    Transaction tx = session.beginTransaction();
                    try {
                        Iterator<Long> it = provider.iterator(0, size);
                        while (it.hasNext()) {
                            Long id = it.next();
                            Group group = (Group)GroupManager.instance.load(id);
                            GroupManager.instance.delete(group);
                            AuditManager.instance.audit("Administration::Group", "Group '" + group.getName() + "' was deleted.");
                        }
                        SessionManager.getSession().flush();
                        tx.commit();
                    }
                    catch (Throwable t) {
                        tx.rollback();
                    }
                }
                finally {
                    SessionManager.closeSession();
                }
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to delete all found groups?")});
    }

    class OperationFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public OperationFragment(String id, IModel<Long> model) {
            super(id, "operationsFrag", (MarkupContainer)GroupManagement.this);
            final Group group = (Group)GroupManager.instance.load((Long)model.getObject());
            this.add(new Component[]{new Link<Void>("edit"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    this.setResponsePage((Page)new GroupEdit(group, new PageBack(){

                        @Override
                        public void go() {
                            this.setResponsePage(GroupManagement.class);
                        }
                    }));
                }
            }});
            this.add(new Component[]{new Link<Void>("copy"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    Group newGroup = GroupManager.instance.copyAsNew((Group)GroupManager.instance.load(group.getId()));
                    this.setResponsePage((Page)new GroupEdit(newGroup, new PageBack(){

                        @Override
                        public void go() {
                            this.setResponsePage(GroupManagement.class);
                        }
                    }));
                }
            }});
            AjaxLink<Void> link = new AjaxLink<Void>("delete"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    GroupManager.instance.delete(GroupManager.instance.load(group.getId()));
                    AuditManager.instance.audit("Administration::Group", "Group '" + group.getName() + "' was deleted.");
                    target.add(GroupManagement.this.get("groups"));
                }
            };
            link.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to delete group: " + group.getName() + "?")});
            this.add(new Component[]{link});
        }
    }
}

