/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.group;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.AuthorizationManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.PageBack;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.group.AuthorizationEditBean;
import com.pmease.quickbuild.web.page.administration.group.AuthorizationListEditBean;
import com.pmease.quickbuild.web.page.administration.group.MembershipEditBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class GroupEdit
extends AdministrationPage {
    private Group group;
    private PageBack pageback;

    public GroupEdit(Group group, PageBack pageback) {
        this.group = group;
        this.pageback = pageback;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.setDefaultModel((IModel)new LoadableDetachableModel<Group>(){

            protected Group load() {
                if (!GroupEdit.this.group.isNew()) {
                    return (Group)GroupManager.instance.load(GroupEdit.this.group.getId());
                }
                return GroupEdit.this.group;
            }
        });
        final String groupName = this.getGroup().isNew() ? null : this.getGroup().getName();
        final EditContext editContext = new EditContext(this.getGroup());
        final ArrayList<Pair<String, EditContext>> pluginSettingEditContexts = new ArrayList<Pair<String, EditContext>>();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            if (!plugin.isEnabled() || plugin.getGroupSettingClass() == null) continue;
            Object pluginSetting = plugin.getGroupSetting(this.getGroup(), false);
            if (pluginSetting == null) {
                try {
                    pluginSetting = plugin.getUserSettingClass().newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            pluginSettingEditContexts.add(new Pair<String, EditContext>(plugin.getId(), new EditContext(pluginSetting)));
        }
        final AuthorizationListEditBean authorizationListBean = new AuthorizationListEditBean();
        for (Authorization authorization : this.getGroup().getAuthorizations()) {
            AuthorizationEditBean bean = new AuthorizationEditBean();
            bean.setConfigurationPath(authorization.getConfiguration().getPathName());
            bean.setPermissions(new HashSet<String>());
            for (String permission : authorization.getPermissions()) {
                if (NumberUtils.isDigits((String)permission)) {
                    PermissionSet permissionSet = CacheManager.instance.getPermissionSet(Long.valueOf(permission));
                    if (permissionSet == null) continue;
                    bean.getPermissions().add("[" + permissionSet.getName() + "]");
                    continue;
                }
                bean.getPermissions().add(permission);
            }
            authorizationListBean.getAuthorizations().add(bean);
        }
        final EditContext authorizationListEditContext = new EditContext(authorizationListBean);
        final MembershipEditBean membershipBean = new MembershipEditBean();
        for (Membership membership : this.getGroup().getMemberships()) {
            membershipBean.getUsers().add(membership.getUser());
        }
        Collections.sort(membershipBean.getUsers(), new Comparator<User>(){

            @Override
            public int compare(User user1, User user2) {
                return user1.getName().compareTo(user2.getName());
            }
        });
        final EditContext membershipEditContext = new EditContext(membershipBean);
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                boolean hasError = false;
                if (editContext.hasError()) {
                    hasError = true;
                }
                for (Pair pair : pluginSettingEditContexts) {
                    ((EditContext)pair.getSecond()).validate(false);
                    if (!((EditContext)pair.getSecond()).hasError()) continue;
                    hasError = true;
                }
                authorizationListEditContext.validate(false);
                if (authorizationListEditContext.hasError()) {
                    hasError = true;
                }
                membershipEditContext.validate(false);
                if (membershipEditContext.hasError()) {
                    hasError = true;
                }
                if (!hasError) {
                    String previousAuditContent = !GroupEdit.this.getGroup().isNew() ? VersionedDocument.fromBean(GroupEdit.this.getGroup()).toXML() : null;
                    editContext.update(GroupEdit.this.getGroup());
                    Group groupWithSameName = GroupManager.instance.get(GroupEdit.this.getGroup().getName());
                    if (groupWithSameName != null && (GroupEdit.this.getGroup().isNew() || !groupWithSameName.getId().equals(GroupEdit.this.getGroup().getId()))) {
                        editContext.getProperty("name").setError("This name is already used by another group.");
                        this.getSession().error((Serializable)((Object)"Fix errors below."));
                        return;
                    }
                    for (Pair pair : pluginSettingEditContexts) {
                        Object pluginSetting;
                        Plugin plugin = PluginManager.instance.getPlugin((String)pair.getFirst());
                        Validate.notNull((Object)plugin);
                        Validate.notNull(plugin.getUserSettingClass());
                        try {
                            pluginSetting = plugin.getUserSettingClass().newInstance();
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.wrapAsUnchecked(e);
                        }
                        ((EditContext)pair.getSecond()).update(pluginSetting);
                        GroupEdit.this.getGroup().getPluginSettingDOMs().put(plugin.getId(), VersionedDocument.fromBean(pluginSetting));
                    }
                    GroupManager.instance.save(GroupEdit.this.getGroup(), groupName);
                    if (previousAuditContent != null) {
                        AuditManager.instance.audit("Administration::Group", "Group '" + GroupEdit.this.getGroup().getName() + "' was modified.", VersionedDocument.fromBean(GroupEdit.this.getGroup()).toXML(), previousAuditContent);
                    } else {
                        AuditManager.instance.audit("Administration::Group", "Group '" + GroupEdit.this.getGroup().getName() + "' was added.");
                    }
                    authorizationListEditContext.update(authorizationListBean);
                    ArrayList<Authorization> authorizations = new ArrayList<Authorization>();
                    for (AuthorizationEditBean bean : authorizationListBean.getAuthorizations()) {
                        Authorization authorization = new Authorization();
                        authorization.setConfiguration(bean.getConfiguration());
                        authorization.setPermissions(new ArrayList<String>());
                        for (String permission : bean.getPermissions()) {
                            if (permission.startsWith("[") && permission.endsWith("]")) {
                                permission = StringUtils.stripStart((String)permission, (String)"[");
                                PermissionSet permissionSet = CacheManager.instance.getPermissionSet(permission = StringUtils.stripEnd((String)permission, (String)"]"));
                                if (permissionSet == null) continue;
                                authorization.getPermissions().add(permissionSet.getId().toString());
                                continue;
                            }
                            authorization.getPermissions().add(permission);
                        }
                        authorizations.add(authorization);
                    }
                    AuthorizationManager.instance.authorize(GroupEdit.this.getGroup(), authorizations);
                    membershipEditContext.update(membershipBean);
                    MembershipManager.instance.assign(GroupEdit.this.getGroup(), membershipBean.getUsers(), true);
                    this.getSession().info((Serializable)((Object)"Settings have been saved."));
                    GroupEdit.this.pageback.go();
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("groupEditor", editContext)});
        RepeatingView pluginSettingEditorsView = new RepeatingView("pluginSettingEditors");
        for (Pair pair : pluginSettingEditContexts) {
            pluginSettingEditorsView.add(new Component[]{new BeanEditor(pluginSettingEditorsView.newChildId(), (EditContext)pair.getSecond())});
        }
        form.add(new Component[]{pluginSettingEditorsView});
        form.add(new Component[]{new BeanEditor("authorizationListEditor", authorizationListEditContext)});
        form.add(new Component[]{new BeanEditor("membershipEditor", membershipEditContext)});
        form.add(new Component[]{new Link("cancel"){

            public void onClick() {
                GroupEdit.this.pageback.go();
            }
        }});
        this.add(new Component[]{form});
    }

    public Group getGroup() {
        return (Group)this.getDefaultModelObject();
    }
}

