/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.group;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.pmease.quickbuild.web.page.administration.group.AuthorizationEditBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class AuthorizationListEditBean
implements Validatable,
Serializable {
    private List<AuthorizationEditBean> authorizations = new ArrayList<AuthorizationEditBean>();

    @Editable(description="<span class='bold red'>WARNING:</span> We do not suggest to assign the EDIT_SETTINGS permission to a group as this permission allows users to set up the build to execute malicious scripts to access/change every aspect of the system, or simply change their accounts as admin account.")
    public List<AuthorizationEditBean> getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(List<AuthorizationEditBean> authorizations) {
        this.authorizations = authorizations;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        List<ErrorContext> authorizationErrorContexts = errorContext.getErrorContexts("authorizations");
        Validate.notNull(authorizationErrorContexts);
        HashSet<Long> configurationIds = new HashSet<Long>();
        for (int i = 0; i < this.authorizations.size(); ++i) {
            if (authorizationErrorContexts.get(i).hasError()) continue;
            AuthorizationEditBean bean = this.authorizations.get(i);
            if (configurationIds.contains(bean.getConfiguration().getId())) {
                errorContext.setError("authorizations", "Duplicate entry found for configuration '" + bean.getConfiguration().getPathName() + "'");
                continue;
            }
            configurationIds.add(bean.getConfiguration().getId());
        }
    }
}

