/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.group;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.PermissionSetManager;
import com.pmease.quickbuild.extensionpoint.PermissionContribution;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class AuthorizationEditBean
implements Serializable,
Validatable {
    private static final long serialVersionUID = 1L;
    private String configurationPath;
    private Set<String> permissions;

    @Editable(order=100, description="Select the configuration to set permissions on. The whole configuration subtree will have the same permissions specified here unless it is overriden by a descendent configuration.<br><b>NOTE:</b> Once a configuration is specified, the whole subtree will be visible and their builds will be accessible even if no additional permissions are specified.")
    @ConfigurationPath
    @NotNull
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(order=200, description="Specify extra permissions here besides accessing builds in this configuration. Permissions inside bracket represents permission sets grouping a set of permissions.Some commonly used permissions are explained as below:<ul><li>BATCH_DOWNLOAD_ARTIFACTS: allows to download all artifacts inside a folder or by a pattern<li>ACCESS_ARTIFACTS: allows to access/download artifacts<li>ACCESS_RECOMMENDED_ARTIFACTS: allows to access/download artifacts of recommended builds<li>ACCESS_SETTINGS: allows to view configuration settings<li>ACCESS_BUILD_LOG: allows to view/download build log<li>ACCESS_BUILD_CHANGES: allows to view SCM changes of builds<li>ACCESS_BUILD_VARIABLES: allows to view build variables<li>ACCESS_BUILD_STEPS: allows to view step definitions<li>VIEW_SOURCE: allows to view SCM sources associated with build changes<li>VIEW_AUDIT_LOG: allows to view audit log<li>ACCESS_STATISTICS: allows to view statistics of various metrics<li>ACCESS_WORKSPACE: allows to view/download files in configuration workspaces<li>ACCESS_STORAGE: allows to view/download files in configuration storage directory<li>RUN_BUILD: allows to request builds<li>STOP_BUILD: allows to cancel builds<li>RECOMMEND_BUILD: allows to recommend builds<li>MODIFY_BUILD: allows to modify properties of existing builds, such as description, etc.<li>CLEAN_WORKSPACE: allows to clean configuration workspaces<li>PROMOTE_BUILD: allows to promote builds<li>DELETE_BUILD: allows to delete builds<li>DELETE_REPORT: allows to delete various reports<li>EDIT_SETTINGS: allows to edit settings of the configuration<li>ADD_CHILDREN: allows to add new child configurations<li>DELETE_CHILDREN: allows to delete child configurations<li>MOVE_CHILDREN: allows to move child configurations out of this configuration<li>CREATE_SCRIPT: obsolete, leave here only for backward compatibility reasons</ul")
    @ChoiceProvider(value="getPermissionChoices")
    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public Configuration getConfiguration() {
        return ConfigurationManager.instance.get(this.getConfigurationPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPermissionChoices() {
        ArrayList<String> allPermissions = new ArrayList<String>();
        for (PermissionSet permissionSet : PermissionSetManager.instance.getAll()) {
            allPermissions.add("[" + permissionSet.getName() + "]");
        }
        Collections.sort(allPermissions);
        ArrayList<String> individualPermissions = new ArrayList<String>();
        for (ConfigurationPermission permission : EnumSet.allOf(ConfigurationPermission.class)) {
            individualPermissions.add(permission.name());
        }
        String configurationPath = EditContext.EditableProperty.getValueAsString("configurationPath");
        Configuration configuration = configurationPath != null ? ConfigurationManager.instance.get(configurationPath) : null;
        if (configuration != null) {
            Context.push(configuration);
        }
        try {
            for (PermissionContribution contribution : PluginManager.instance.getExtensions(PermissionContribution.class)) {
                String[] permissions = contribution.getPermissions();
                if (permissions == null || permissions.length == 0) continue;
                individualPermissions.addAll(Arrays.asList(permissions));
            }
        }
        finally {
            if (configuration != null) {
                Context.pop();
            }
        }
        Collections.sort(individualPermissions);
        allPermissions.addAll(individualPermissions);
        return allPermissions;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("configurationPath") && ConfigurationManager.instance.get(this.getConfigurationPath()) == null) {
            errorContext.setError("configurationPath", "Configuration does not exist.");
        }
    }
}

