/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.dashboard;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.entitymanager.DashboardManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.datatablesupport.EntityDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.FilterableEntityProvider;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionChanged;
import com.pmease.quickbuild.web.component.datatablesupport.SelectionColumn;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.dashboard.DashboardEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DashboardAdminPage
extends AdministrationPage {
    private static final long serialVersionUID = 1L;
    private SelectionColumn<Long> selectionColumn = new SelectionColumn();

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new AjaxLink<Void>("deleteSelected"){

            public void onClick(AjaxRequestTarget target) {
                Set set = DashboardAdminPage.this.selectionColumn.getSelections();
                if (set.isEmpty()) {
                    return;
                }
                DashboardManager dm = DashboardManager.instance;
                for (Long each : set) {
                    dm.delete(dm.get(each));
                }
                target.add(DashboardAdminPage.this.get("dashboards"));
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(!DashboardAdminPage.this.selectionColumn.getSelections().isEmpty());
            }
        }.setOutputMarkupId(true).add(new ConfirmBehavior("Are you sure you want to delete those selected dashboards?"))});
        this.add(new Component[]{new AjaxLink<Void>("deleteAll"){

            public void onClick(AjaxRequestTarget target) {
                DashboardManager dm = DashboardManager.instance;
                for (Dashboard each : dm.getAll()) {
                    dm.delete(each);
                }
                target.add(DashboardAdminPage.this.get("dashboards"));
            }
        }.add(new Behavior[]{new ConfirmBehavior("Are you sure you want to delete all dashboards?")})});
        ArrayList<Object> columns = new ArrayList<Object>();
        this.selectionColumn = new SelectionColumn();
        columns.add(this.selectionColumn);
        AbstractColumn column = new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Name")), "name"){

            public void populateItem(Item<ICellPopulator<Long>> item, String id, final IModel<Long> rowModel) {
                Fragment frag = new Fragment(id, "namefrag", (MarkupContainer)DashboardAdminPage.this);
                AjaxLink<Void> link = new AjaxLink<Void>("editlink"){

                    public void onClick(AjaxRequestTarget target) {
                        new Dialog("Edit Dashboard"){

                            @Override
                            protected Component render(String componentId) {
                                Long rowId = (Long)rowModel.getObject();
                                Dashboard dashboard = (Dashboard)DashboardManager.instance.get(rowId);
                                return new DashboardEditor(componentId, dashboard){

                                    @Override
                                    protected void onAfterSave(AjaxRequestTarget target) {
                                        this.setResponsePage(DashboardAdminPage.class);
                                    }
                                };
                            }
                        }.width(600).open(target);
                    }
                };
                frag.add(new Component[]{link});
                Long rowId = (Long)rowModel.getObject();
                Dashboard dashboard = (Dashboard)DashboardManager.instance.get(rowId);
                link.add(new Component[]{new Label("name", dashboard.getName())});
                frag.add(new Component[]{DashboardAdminPage.this.createUserLabel("owner", (IModel<Long>)((IModel)Model.of((Serializable)dashboard.getUser().getId())))});
                item.add(new Component[]{frag});
            }

            public String getCssClass() {
                return "text";
            }
        };
        columns.add(column);
        column = new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Users shared"))){

            public void populateItem(Item<ICellPopulator<Long>> item, String componentId, IModel<Long> rowModel) {
                Long rowId = (Long)rowModel.getObject();
                Dashboard dashboard = (Dashboard)DashboardManager.instance.get(rowId);
                Collection<UserShare> userShares = dashboard.getUserShares();
                ArrayList list = Lists.newArrayList();
                for (UserShare each : userShares) {
                    list.add(each.getUser().getName());
                }
                item.add(new Component[]{new Label(componentId, Joiner.on((String)", ").skipNulls().join((Iterable)list))});
            }

            public String getCssClass() {
                return "text";
            }
        };
        columns.add(column);
        column = new AbstractColumn<Long>((IModel)Model.of((Serializable)((Object)"Groups shared"))){

            public void populateItem(Item<ICellPopulator<Long>> item, String componentId, IModel<Long> rowModel) {
                Long rowId = (Long)rowModel.getObject();
                Dashboard dashboard = (Dashboard)DashboardManager.instance.get(rowId);
                Collection<GroupShare> groupShares = dashboard.getGroupShares();
                ArrayList list = Lists.newArrayList();
                for (GroupShare each : groupShares) {
                    if (each.getGroup() == null) {
                        list.add("[Everyone]");
                        continue;
                    }
                    list.add(each.getGroup().getName());
                }
                item.add(new Component[]{new Label(componentId, Joiner.on((String)", ").skipNulls().join((Iterable)list))});
            }

            public String getCssClass() {
                return "text";
            }
        };
        columns.add(column);
        FilterableEntityProvider provider = new FilterableEntityProvider(Dashboard.class, null, new String[]{"name"});
        EntityDataTable dataTable = new EntityDataTable("dashboards", columns, provider, 20){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getNoRecordMessage() {
                return "No Dashboard Found";
            }
        };
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, (ISortStateLocator)provider));
        dataTable.addBottomToolbar(new SearchNavToolbar(dataTable));
        this.add(new Component[]{dataTable});
    }

    private Component createUserLabel(String id, final IModel<Long> userModel) {
        return new Label(id, (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                Long userId = (Long)userModel.getObject();
                User user = (User)UserManager.instance.get(userId);
                return user.getName();
            }
        }).add(new Behavior[]{AttributeModifier.replace((String)"title", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                Long userId = (Long)userModel.getObject();
                User user = (User)UserManager.instance.get(userId);
                StringBuffer sb = new StringBuffer();
                if (!Strings.isNullOrEmpty((String)user.getFullName())) {
                    sb.append(user.getFullName()).append(", ");
                }
                if (!Strings.isNullOrEmpty((String)user.getEmail())) {
                    sb.append(user.getEmail());
                }
                return sb.toString();
            }
        })});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SelectionChanged) {
            SelectionChanged payload = (SelectionChanged)event.getPayload();
            payload.getTarget().add(this.get("deleteSelected"));
        }
    }
}

