/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration.audit;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Audit;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.component.TextLink;
import com.pmease.quickbuild.web.component.datatablesupport.hibernate.HibernateDataProvider;
import com.pmease.quickbuild.web.component.datatablesupport.hibernate.HibernateDataTable;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.MatchType;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.web.component.datatablesupport.toolbar.SearchPatternChanged;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.Response;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class AuditLogPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private String user;
    private DateRange dateRange = new DateRange();

    public AuditLogPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new FilterForm("filterForm")});
        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
        columns.add(new AbstractColumn<Audit>((IModel)Model.of((Serializable)((Object)"Time")), "timestamp"){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Audit>> cellItem, String componentId, IModel<Audit> rowModel) {
                Audit audit = (Audit)rowModel.getObject();
                cellItem.add(new Component[]{new Label(componentId, DateUtils.formatDate(audit.getTimestamp(), "MMM dd, HH:mm:ss, EEEEE"))});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        columns.add(new AbstractColumn<Audit>((IModel)Model.of((Serializable)((Object)"User")), "user"){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Audit>> cellItem, String componentId, IModel<Audit> rowModel) {
                User u = Context.getUser();
                Audit audit = (Audit)rowModel.getObject();
                String label = Objects.equal((Object)u.getDisplayName(), (Object)audit.getUser()) ? "<i>me</i>" : StringEscapeUtils.escapeHtml((String)audit.getUser());
                cellItem.add(new Component[]{new Label(componentId, label).setEscapeModelStrings(false)});
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        columns.add(new AbstractColumn<Audit>((IModel)Model.of((Serializable)((Object)"Event Source")), "source"){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Audit>> cellItem, String componentId, IModel<Audit> rowModel) {
                Audit audit = (Audit)rowModel.getObject();
                Configuration c = Context.getConfiguration();
                if (c != null) {
                    String label = StringUtils.stripEnd((String)audit.getSource(), (String)"/");
                    if (Objects.equal((Object)c.getPathName(), (Object)label)) {
                        label = "<i>This configuration</i>";
                    }
                    cellItem.add(new Component[]{new Label(componentId, label).setEscapeModelStrings(false)});
                } else {
                    String str = audit.getSource();
                    if (str.endsWith("/")) {
                        final String path = StringUtils.stripEnd((String)audit.getSource(), (String)"/");
                        cellItem.add(new Component[]{new TextLink<Void>(componentId, path){
                            private static final long serialVersionUID = 1L;

                            public void onClick() {
                                Configuration c = ConfigurationManager.instance.get(path);
                                if (c != null) {
                                    this.setResponsePage((Page)new ConfigurationOverview(c.getId()));
                                }
                            }
                        }.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"link")), " ")})});
                    } else {
                        cellItem.add(new Component[]{new Label(componentId, audit.getSource())});
                    }
                }
            }

            public String getCssClass() {
                return "nowrap-text";
            }
        });
        columns.add(new AbstractColumn<Audit>((IModel)Model.of((Serializable)((Object)"Activity")), "action"){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<ICellPopulator<Audit>> item, String componentId, IModel<Audit> rowModel) {
                item.add(new Component[]{new ActivityFragment(componentId, rowModel)});
            }

            public String getCssClass() {
                return "text";
            }
        });
        HibernateDataProvider<Audit> dataProvider = new HibernateDataProvider<Audit>(Audit.class, new SortParam("timestamp", false));
        dataProvider.setCriterions(this.getCriterions());
        HibernateDataTable<Audit> dataTable = new HibernateDataTable<Audit>("audits", columns, dataProvider, 20){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<Criterion> getCriterions() {
                List crits = AuditLogPanel.this.getCriterions();
                crits.addAll(super.getCriterions());
                return crits;
            }

            public void onEvent(IEvent<?> sink) {
                if (sink.getPayload() instanceof SearchPatternChanged) {
                    SearchPatternChanged e = (SearchPatternChanged)sink.getPayload();
                    this.onSearchPattern(e.getTarget(), e.getPattern(), MatchType.CONTAINING);
                }
            }
        };
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"action", "user"});
        if (Context.getConfiguration() == null) {
            properties.add("source");
        }
        dataTable.setFilterProperties(properties);
        dataTable.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataTable, dataProvider));
        dataTable.addBottomToolbar(new SearchNavToolbar(dataTable));
        this.add(new Component[]{dataTable});
    }

    private List<Criterion> getCriterions() {
        ArrayList crits = Lists.newArrayList();
        if (Context.getConfiguration() != null) {
            crits.add(Restrictions.ilike((String)"source", (String)(Context.getConfiguration().getPathName() + "/"), (MatchMode)MatchMode.START));
        }
        if (!Strings.isNullOrEmpty((String)this.getUser())) {
            crits.add(Restrictions.ilike((String)"user", (String)this.getUser(), (MatchMode)MatchMode.EXACT));
        }
        crits.add(Restrictions.between((String)"timestamp", (Object)DateUtils.truncate((Date)this.dateRange.getBeginDate(), (int)5), (Object)DateUtils.addDays((Date)DateUtils.truncate((Date)this.dateRange.getEndDate(), (int)5), (int)1)));
        return crits;
    }

    static String[] toLines(String content) {
        if (Strings.isNullOrEmpty((String)content)) {
            return new String[0];
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((String)"\n").split((CharSequence)content), String.class);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    class FilterForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public FilterForm(String id) {
            super(id);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new AutoCompleteTextField<String>("user", (IModel)new PropertyModel((Object)AuditLogPanel.this, "user"), (IAutoCompleteRenderer)new IAutoCompleteRenderer<String>(){
                private static final long serialVersionUID = 1L;

                public void render(String object, Response response, String criteria) {
                    response.write((CharSequence)("<li textvalue=\"" + object + "\""));
                    response.write((CharSequence)">");
                    response.write((CharSequence)object);
                    response.write((CharSequence)"</li>");
                }

                public void renderHeader(Response response) {
                    response.write((CharSequence)"<ul>");
                }

                public void renderFooter(Response response, int count) {
                    response.write((CharSequence)"</ul>");
                }
            }){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Iterator<String> getChoices(String input) {
                    Session session = SessionManager.openSession();
                    try {
                        Query query = session.createQuery("SELECT DISTINCT user from Audit where upper(user) like upper(:u)");
                        query.setParameter("u", (Object)("%" + input + "%"));
                        query.setMaxResults(10);
                        List result = query.list();
                        Iterator<String> iterator = result.iterator();
                        return iterator;
                    }
                    finally {
                        SessionManager.closeSession();
                    }
                }
            }});
            final EditContext editContext = new EditContext(AuditLogPanel.this.dateRange);
            this.add(new Component[]{new PropertyEditor("fromDate", editContext.getBeanClass(), editContext.getProperty("beginDate"))});
            this.add(new Component[]{new PropertyEditor("toDate", editContext.getBeanClass(), editContext.getProperty("endDate"))});
            FeedbackPanel feedback = new FeedbackPanel("feedback");
            this.add(new Component[]{feedback});
            this.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    editContext.validate(false);
                    if (editContext.hasError()) {
                        form.error((Serializable)((Object)editContext.getError()));
                        target.add(new Component[]{form});
                        return;
                    }
                    editContext.update(AuditLogPanel.this.dateRange);
                    HibernateDataTable dataTable = (HibernateDataTable)((Object)AuditLogPanel.this.get("audits"));
                    if (dataTable != null) {
                        dataTable.onFilterChanged(target);
                    }
                    target.add(new Component[]{form});
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            }});
        }
    }

    class ActivityFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ActivityFragment(String id, IModel<Audit> model) {
            super(id, "activityFrag", (MarkupContainer)AuditLogPanel.this, model);
        }

        Audit getAudit() {
            return (Audit)this.getDefaultModelObject();
        }

        protected void onInitialize() {
            super.onInitialize();
            final Audit audit = this.getAudit();
            this.add(new Component[]{new Label("action", audit.getAction()).setEscapeModelStrings(true)});
            WebMarkupContainer span = new WebMarkupContainer("span"){
                private static final long serialVersionUID = 1L;

                protected void onConfigure() {
                    super.onConfigure();
                    this.setVisibilityAllowed(!Strings.isNullOrEmpty((String)audit.getContent()) || !Strings.isNullOrEmpty((String)audit.getPreviousContent()));
                }
            };
            this.add(new Component[]{span});
            Link<Void> viewLink = new Link<Void>("viewLink"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    String content = audit.getContent();
                    String[] lines = AuditLogPanel.toLines(content);
                    SourceViewPage page = new SourceViewPage("Setting", "xml", lines);
                    this.setResponsePage((Page)page);
                }

                public void onConfigure() {
                    super.onConfigure();
                    this.setVisibilityAllowed(!Strings.isNullOrEmpty((String)audit.getContent()));
                }
            };
            viewLink.setPopupSettings(new PopupSettings("popup", 12));
            span.add(new Component[]{viewLink});
            Link<Void> diffLink = new Link<Void>("diffLink"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    SourceDiffPage diffPage = new SourceDiffPage("Diff with previous", "xml", AuditLogPanel.toLines(audit.getContent()), AuditLogPanel.toLines(audit.getPreviousContent()));
                    this.setResponsePage((Page)diffPage);
                }

                public void onConfigure() {
                    super.onConfigure();
                    this.setVisibilityAllowed(!Strings.isNullOrEmpty((String)audit.getContent()) && !Strings.isNullOrEmpty((String)audit.getPreviousContent()));
                }
            };
            diffLink.setPopupSettings(new PopupSettings("popup", 12));
            span.add(new Component[]{diffLink});
        }
    }
}

