/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.maintenance.SystemCareTask;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.setting.system.SystemSetting;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;

public class SystemSettingEdit
extends AdministrationPage {
    @Override
    protected void onInitialize() {
        super.onInitialize();
        final SystemSetting setting = SettingManager.instance.getSystemSettingDef();
        final EditContext editContext = new EditContext(setting);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    String previousAuditContent = VersionedDocument.fromBean(setting).toXML();
                    editContext.update(setting);
                    SettingManager.instance.saveSystemSetting(setting);
                    AuditManager.instance.audit("Administration::System Setting", "System setting was modified.", VersionedDocument.fromBean(setting).toXML(), previousAuditContent);
                    SystemCareTask.schedule();
                    this.getSession().info((Serializable)((Object)"System setting has been updated."));
                    this.setResponsePage(SystemSettingEdit.class);
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("objectEditor", editContext)});
        this.add(new Component[]{form});
    }
}

