/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SupportRequestPage
extends AdministrationPage {
    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new WebMarkupContainer("contactName"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                User user = Context.getUser();
                if (user != null) {
                    tag.put("value", (CharSequence)user.getDisplayName());
                }
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("contactEmail"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                User user = Context.getUser();
                if (user != null) {
                    tag.put("value", (CharSequence)user.getEmail());
                }
            }
        }});
        final ArrayList<Pair<String, String>> serverProps = new ArrayList<Pair<String, String>>();
        try {
            serverProps.add(new Pair<String, String>("Host Name", InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        serverProps.add(new Pair<String, String>("System Date and Time", DateUtils.formatDateTime(new Date())));
        serverProps.add(new Pair<String, String>("Operating System", System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.arch")));
        serverProps.add(new Pair<String, String>("OS User Name", System.getProperty("user.name")));
        serverProps.add(new Pair<String, String>("JVM", System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + ", " + System.getProperty("java.vm.vendor")));
        serverProps.add(new Pair<String, String>("QuickBuild Version", Bootstrap.buildVersion + " - " + Bootstrap.releaseDate));
        serverProps.add(new Pair<String, String>("Total Memory", FileUtils.byteCountToDisplaySize(Runtime.getRuntime().maxMemory())));
        serverProps.add(new Pair<String, String>("Used Memory", FileUtils.byteCountToDisplaySize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
        serverProps.add(new Pair<String, String>("Configurations", String.valueOf(Quickbuild.getInstance(ConfigurationManager.class).count())));
        this.add(new Component[]{new ListView<Pair<String, String>>("serverProps", (IModel)new Model(serverProps)){

            protected void populateItem(ListItem<Pair<String, String>> item) {
                Pair pair = (Pair)item.getModelObject();
                item.add(new Component[]{new Label("name", (String)pair.getFirst())});
                item.add(new Component[]{new Label("value", (String)pair.getSecond())});
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("serverInfoToSend"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String serverInfo = "";
                for (Pair pair : serverProps) {
                    serverInfo = serverInfo + (String)pair.getFirst() + ": " + (String)pair.getSecond() + "\n";
                }
                tag.put("value", (CharSequence)serverInfo);
            }
        }});
        final ArrayList<String> pluginInfo = new ArrayList<String>();
        for (Plugin plugin : Quickbuild.getInstance(PluginManager.class).getPlugins()) {
            pluginInfo.add(plugin.getId() + ";" + plugin.getVersion());
        }
        this.add(new Component[]{new Label("pluginInfo", StringUtils.join(pluginInfo.iterator(), (String)"<br>"))});
        this.get("pluginInfo").setEscapeModelStrings(false);
        this.add(new Component[]{new WebMarkupContainer("pluginInfoToSend"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("value", (CharSequence)StringUtils.join(pluginInfo.iterator(), (String)"\n"));
            }
        }});
        final ArrayList<Pair<String, String>> gridProps = new ArrayList<Pair<String, String>>();
        gridProps.add(new Pair<String, String>("Build Agents", String.valueOf(Quickbuild.getInstance(AgentManager.class).getBuildAgentCount())));
        gridProps.add(new Pair<String, String>("User Agents", String.valueOf(Quickbuild.getInstance(AgentManager.class).getUserAgentCount())));
        this.add(new Component[]{new ListView<Pair<String, String>>("gridProps", (IModel)new Model(gridProps)){

            protected void populateItem(ListItem<Pair<String, String>> item) {
                Pair pair = (Pair)item.getModelObject();
                item.add(new Component[]{new Label("name", (String)pair.getFirst())});
                item.add(new Component[]{new Label("value", (String)pair.getSecond())});
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("gridInfoToSend"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String gridInfo = "";
                for (Pair pair : gridProps) {
                    gridInfo = gridInfo + (String)pair.getFirst() + ": " + (String)pair.getSecond() + "\n";
                }
                tag.put("value", (CharSequence)gridInfo);
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("dashboardUrl"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("value", (CharSequence)Quickbuild.getInstance().getUrl());
            }
        }});
        final String licenseKey = SettingManager.instance.getLicenseKey();
        this.add(new Component[]{new Label("licenseKey", licenseKey)});
        this.add(new Component[]{new WebMarkupContainer("licenseKeyToSend"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("value", (CharSequence)licenseKey);
            }
        }});
    }
}

