/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.ProgressBar;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class ServerInformationPage
extends AdministrationPage {
    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("systemDateTime", DateUtils.formatDateTime(new Date()))});
        this.add(new Component[]{new Label("os", System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.arch"))});
        this.add(new Component[]{new Label("jvm", System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + ", " + System.getProperty("java.vm.vendor"))});
        this.add(new Component[]{new Label("versionInfo", Bootstrap.buildVersion + " - " + Bootstrap.releaseDate)});
        this.add(new Component[]{new Label("totalMemory", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return FileUtils.byteCountToDisplaySize(Runtime.getRuntime().maxMemory());
            }
        })});
        this.add(new Component[]{new Label("usedMemory", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return FileUtils.byteCountToDisplaySize(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            }
        })});
        this.add(new Component[]{new ProgressBar("memoryUsage", (IModel<Integer>)new LoadableDetachableModel<Integer>(){

            public Integer load() {
                return (int)((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) * 1.0 / (double)Runtime.getRuntime().maxMemory() * 100.0);
            }
        })});
        this.add(new Component[]{new Label("osUserName", System.getProperty("user.name"))});
        this.add(new Component[]{new Link<Void>("gc"){

            public void onClick() {
                System.gc();
            }
        }});
    }
}

