/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.license.CommercialLicense;
import com.pmease.quickbuild.license.CommercialLicense2;
import com.pmease.quickbuild.license.CommunityLicense;
import com.pmease.quickbuild.license.License;
import com.pmease.quickbuild.license.OpensourceLicense;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class LicenseManagement
extends AdministrationPage {
    private String newLicenseKey;

    public LicenseManagement() {
        this.add(new Component[]{new Label("licenseType", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommunityLicense) {
                    return "Community License";
                }
                if (license instanceof OpensourceLicense) {
                    return "Open Source License";
                }
                if (license instanceof CommercialLicense) {
                    CommercialLicense commercialLicense = (CommercialLicense)license;
                    if (commercialLicense.getExpirationDate() != null) {
                        return "Trial Commercial License (for 2.0.x)";
                    }
                    return "Commercial License (for 2.0.x)";
                }
                CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                if (commercialLicense.getExpirationDate() != null) {
                    return "Trial Commercial License";
                }
                return "Commercial License";
            }
        })});
        Component[] componentArray = new Component[1];
        Link<Void> link = new Link<Void>("restoreCommunityLicense"){

            public void onClick() {
                SettingManager.instance.saveLicenseKey("AAAAuqztAAVzcgAuY29tLnBtZWFzZS5xdWlja2J1aWxkLmxpY2Vuc2UuQ29tbXVuaXR5TGljZW5zZQAAAAAAAAABAgAAeHIAJWNvbS5wbWVhc2UucXVpY2tidWlsZC5saWNlbnNlLkxpY2Vuc2UAAAAAAAAAAQIAAUwABHV1aWR0ABJMamF2YS9sYW5nL1N0cmluZzt4cHQAJDNjOGZhYzhiLWEwNTAtNGY1ZC04NjY1LWNlYzU1MGQyYmU1ZAAAAC8wLQIUEMtKGTvjeLav0SRoLXIHCy2pHqECFQCSG6Q6P9AvQjmiuSbcnbrsHmzodg==");
                AuditManager.instance.audit("Administration::License", "The license was changed to community license");
                this.setResponsePage(LicenseManagement.class);
            }

            protected void onConfigure() {
                super.onConfigure();
                License license = CacheManager.instance.getLicense();
                this.setVisible(license instanceof CommercialLicense2 || license instanceof CommercialLicense || license instanceof OpensourceLicense);
            }
        };
        componentArray[0] = link;
        this.add(componentArray);
        link.add(new Behavior[]{new ConfirmBehavior("Do you really want to restore the community license?")});
        this.add(new Component[]{new Label("licensedSite", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    return ((CommercialLicense2)license).getLicensedSite();
                }
                return ((CommercialLicense)license).getLicensedSite();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                License license = CacheManager.instance.getLicense();
                this.setVisible(license instanceof CommercialLicense2 || license instanceof CommercialLicense);
            }
        }});
        this.add(new Component[]{new Label("licensedProject", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return ((OpensourceLicense)CacheManager.instance.getLicense()).getLicensedProject();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(CacheManager.instance.getLicense() instanceof OpensourceLicense);
            }
        }});
        this.add(new Component[]{new Label("serviceExpirationDate", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return DateUtils.formatDate(((CommercialLicense2)CacheManager.instance.getLicense()).getServiceExpirationDate());
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    this.setVisible(commercialLicense.getExpirationDate() == null);
                } else {
                    this.setVisible(false);
                }
            }
        }});
        this.add(new Component[]{new Label("expirationDate", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommunityLicense || license instanceof OpensourceLicense) {
                    return "never expires";
                }
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    Date expirationDate = commercialLicense.getExpirationDate();
                    if (expirationDate != null) {
                        return DateUtils.formatDate(expirationDate);
                    }
                    return "never expires for versions released before " + DateUtils.formatDate(commercialLicense.getServiceExpirationDate());
                }
                CommercialLicense commercialLicense = (CommercialLicense)license;
                Date expirationDate = commercialLicense.getExpirationDate();
                if (expirationDate != null) {
                    return DateUtils.formatDate(expirationDate);
                }
                return "never expires for 2.0.x";
            }
        })});
        this.add(new Component[]{new WebMarkupContainer("requestTrialExtension"){

            protected void onConfigure() {
                super.onConfigure();
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    this.setVisible(commercialLicense.getExpirationDate() != null);
                } else if (license instanceof CommercialLicense) {
                    CommercialLicense commercialLicense = (CommercialLicense)license;
                    this.setVisible(commercialLicense.getExpirationDate() != null);
                } else {
                    this.setVisible(false);
                }
            }
        }});
        this.add(new Component[]{new Label("licensedConfigurations", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2 || license instanceof CommercialLicense || license instanceof OpensourceLicense) {
                    return "unlimited";
                }
                return "16 (used: " + ConfigurationManager.instance.count() + ")";
            }
        })});
        this.add(new Component[]{new WebMarkupContainer("requestTrial"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(CacheManager.instance.getLicense() instanceof CommunityLicense);
            }
        }});
        Form form = new Form("form"){

            protected void onSubmit() {
                if (StringUtils.isNotBlank((String)LicenseManagement.this.newLicenseKey)) {
                    License newLicense = License.fromKey(LicenseManagement.this.newLicenseKey);
                    if (newLicense instanceof CommercialLicense2) {
                        CommercialLicense2 newSiteLicense = (CommercialLicense2)newLicense;
                        if (newSiteLicense.isExpired()) {
                            this.getSession().error((Serializable)((Object)"License is expired."));
                        } else if (newSiteLicense.getExpirationDate() == null && !newSiteLicense.isEligible(Bootstrap.releaseDate)) {
                            this.getSession().error((Serializable)((Object)"This license is not eligible for this version."));
                        } else {
                            SettingManager.instance.saveLicenseKey(LicenseManagement.this.newLicenseKey);
                            AuditManager.instance.audit("Administration::License", "A new license was installed successfully.");
                            this.getSession().info((Serializable)((Object)"New license installed successfully."));
                        }
                    } else if (newLicense instanceof OpensourceLicense) {
                        SettingManager.instance.saveLicenseKey(LicenseManagement.this.newLicenseKey);
                        AuditManager.instance.audit("Administration::License", "A new license was installed successfully.");
                        this.getSession().info((Serializable)((Object)"New license installed successfully."));
                    } else if (newLicense instanceof CommercialLicense) {
                        this.getSession().error((Serializable)((Object)"2.0.x license can not be used in this version."));
                    } else {
                        this.getSession().error((Serializable)((Object)"Invalid license key."));
                    }
                } else {
                    this.getSession().error((Serializable)((Object)"License key should not be empty."));
                }
                this.setResponsePage(LicenseManagement.class);
            }
        };
        this.add(new Component[]{form});
        form.add(new Component[]{new TextArea("newLicenseKey", (IModel)new IModel<String>(){

            public String getObject() {
                return LicenseManagement.this.newLicenseKey;
            }

            public void setObject(String object) {
                LicenseManagement.this.newLicenseKey = object;
            }

            public void detach() {
            }
        })});
    }
}

