/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;

public class EmailSettingEdit
extends AdministrationPage {
    @Override
    protected void onInitialize() {
        super.onInitialize();
        EmailSetting emailSetting = SettingManager.instance.getEmailSettingDef();
        if (emailSetting == null) {
            emailSetting = new EmailSetting();
        }
        final String previousAuditContent = VersionedDocument.fromBean(emailSetting).toXML();
        final EditContext editContext = new EditContext(emailSetting);
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                editContext.validate(false);
                if (!editContext.hasError()) {
                    EmailSetting emailSetting = new EmailSetting();
                    editContext.update(emailSetting);
                    SettingManager.instance.saveEmailSetting(emailSetting);
                    AuditManager.instance.audit("Administration::Email Setting", "System email setting was modified.", VersionedDocument.fromBean(emailSetting).toXML(), previousAuditContent);
                    this.getSession().info((Serializable)((Object)"Email setting has been updated."));
                    this.setResponsePage(EmailSettingEdit.class);
                } else {
                    this.getSession().error((Serializable)((Object)"Fix errors below."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("objectEditor", editContext)});
        this.add(new Component[]{form});
    }
}

