/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.AutoBackupSettingEditBean;
import com.pmease.quickbuild.web.page.administration.BackupNowOption;
import java.io.File;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBackupPage
extends AdministrationPage {
    private Logger logger = LoggerFactory.getLogger(DatabaseBackupPage.class);

    @Override
    protected void onInitialize() {
        super.onInitialize();
        final AutoBackupSettingEditBean helperBean = new AutoBackupSettingEditBean();
        helperBean.setBackupSetting(SettingManager.instance.getAutoBackupSettingDef());
        final EditContext autoBackupEditContext = new EditContext(helperBean);
        Form form = new Form<Void>("autoBackupForm"){

            protected void onSubmit() {
                autoBackupEditContext.validate(false);
                if (!autoBackupEditContext.hasError()) {
                    String previousAuditContent = VersionedDocument.fromBean(helperBean).toXML();
                    autoBackupEditContext.update(helperBean);
                    AuditManager.instance.audit("Administration::Database Backup", "Database auto-backup setting was modified.", VersionedDocument.fromBean(helperBean).toXML(), previousAuditContent);
                    SettingManager.instance.saveAutoBackupSetting(helperBean.getBackupSetting());
                    DataManager.instance.scheduleBackup();
                    this.getSession().info((Serializable)((Object)"Auto backup setting has been saved successfully."));
                }
            }
        };
        PropertyEditor editor = new PropertyEditor("editor", "Enable", AutoBackupSettingEditBean.class, autoBackupEditContext.getProperty("backupSetting"));
        form.add(new Component[]{editor});
        this.add(new Component[]{form});
        final EditContext backupNowEditContext = new EditContext(new BackupNowOption());
        form = new Form<Void>("backupNowForm"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit() {
                backupNowEditContext.validate(false);
                if (!backupNowEditContext.hasError()) {
                    BackupNowOption backupNowOption = new BackupNowOption();
                    backupNowEditContext.update(backupNowOption);
                    File backupFile = new File(backupNowOption.getBackupTo());
                    if (!backupFile.isAbsolute()) {
                        backupFile = new File(Bootstrap.installDir, backupNowOption.getBackupTo());
                    }
                    if (backupFile.isDirectory()) {
                        this.getSession().error((Serializable)((Object)"Please specify a file instead of a directory."));
                        return;
                    }
                    if (!backupFile.getParentFile().exists()) {
                        this.getSession().error((Serializable)((Object)("Unable to create backup file since parent directory does not exist: " + backupFile.getParent())));
                        return;
                    }
                    try {
                        FileUtils.touchFile(backupFile);
                    }
                    catch (Exception e) {
                        DatabaseBackupPage.this.logger.error("Error touching file: " + backupFile.getAbsolutePath(), (Throwable)e);
                        this.getSession().error((Serializable)((Object)"Can not write to backup file. Please make sure the user running QuickBuild process has write permission to the file. Refer to server log for detail information about this error."));
                        return;
                    }
                    File tempDir = FileUtils.createTempDir("backup");
                    try {
                        DataManager.instance.exportData(tempDir, backupNowOption.isExcludeBuilds(), backupNowOption.isExcludeMeasurements(), backupNowOption.isExcludeAudits(), backupNowOption.isClearPasswords());
                        FileUtils.zip(tempDir, backupFile);
                        AuditManager.instance.audit("Administration::Database Backup", "Database was backed up.");
                    }
                    finally {
                        FileUtils.deleteDir(tempDir);
                    }
                    this.getSession().info((Serializable)((Object)"Database has been backed up successfully."));
                }
            }
        };
        form.add(new Component[]{new BeanEditor("editor", backupNowEditContext)});
        this.add(new Component[]{form});
    }
}

