/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page.administration;

import com.pmease.quickbuild.annotation.Editable;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

public class BackupNowOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String backupTo;
    private boolean excludeBuilds;
    private boolean excludeMeasurements;
    private boolean excludeAudits;
    private boolean clearPasswords;

    @Editable(order=100, description="Specify a zip file to which the database will be backed up. A non-absolute path will be considered to be relative to installation directory of the QuickBuild server.")
    @NotEmpty
    public String getBackupTo() {
        return this.backupTo;
    }

    public void setBackupTo(String backupTo) {
        this.backupTo = backupTo;
    }

    @Editable(order=200, description="If checked, builds will be excluded from the backup. For a large deployment, excluding builds from backup can speed backup process dramatically.")
    public boolean isExcludeBuilds() {
        return this.excludeBuilds;
    }

    public void setExcludeBuilds(boolean excludeBuilds) {
        this.excludeBuilds = excludeBuilds;
    }

    @Editable(order=210, description="If checked, measurement data will be excluded from the backup. For a large deployment, excluding measurement data from backup can speed backup process dramatically.")
    public boolean isExcludeMeasurements() {
        return this.excludeMeasurements;
    }

    public void setExcludeMeasurements(boolean excludeMeasurements) {
        this.excludeMeasurements = excludeMeasurements;
    }

    @Editable(order=220, description="If checked, audit data will be excluded from the backup. For a large deployment, excluding audit data from backup can speed backup process dramatically.")
    public boolean isExcludeAudits() {
        return this.excludeAudits;
    }

    public void setExcludeAudits(boolean excludeAudits) {
        this.excludeAudits = excludeAudits;
    }

    @Editable(order=300, description="If checked, all passwords will be cleared in the backup file. This is useful if you want to send backup for diagnostics but do not want passwords being included.")
    public boolean isClearPasswords() {
        return this.clearPasswords;
    }

    public void setClearPasswords(boolean clearPasswords) {
        this.clearPasswords = clearPasswords;
    }
}

