/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.AuthenticationException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.RegisterPage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.StatelessLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignInPage
extends BasePage {
    private static final Logger logger = LoggerFactory.getLogger(SignInPage.class);
    private String userName;
    private String password;
    private boolean remember;

    public SignInPage() {
        if (Context.getUser() != null) {
            throw new RestartResponseException(DashboardPage.class);
        }
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new Label("releaseInfo", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                StringBuffer sb = new StringBuffer();
                sb.append("Version: ").append(Bootstrap.buildVersion).append(" (Release date: ").append(new SimpleDateFormat("MMMMM dd, yyyy").format(Bootstrap.releaseDate)).append(")");
                return sb.toString();
            }
        })});
        this.add(new Component[]{new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter((MarkupContainer)this))});
        StatelessForm<SignInPage> form = new StatelessForm<SignInPage>("form"){

            public void onSubmit() {
                if (SignInPage.this.userName == null || SignInPage.this.password == null) {
                    this.error((Serializable)((Object)"User name and password must be specified."));
                } else {
                    try {
                        WebSession.get().setUserId(SecurityHelper.authenticate(SignInPage.this.userName, SignInPage.this.password, null).getId());
                        if (SignInPage.this.isRemember()) {
                            SecurityHelper.createAuthenticationCookies((HttpServletResponse)this.getResponse().getContainerResponse(), SignInPage.this.userName, SignInPage.this.password);
                        }
                        if (!this.continueToOriginalDestination()) {
                            this.setResponsePage(this.getApplication().getHomePage());
                        }
                    }
                    catch (AuthenticationException e) {
                        logger.error("Error authenticating user.", (Throwable)e);
                        this.error((Serializable)((Object)"Incorrect user name or password."));
                    }
                }
            }
        };
        form.setModel((IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{form});
        form.add(new Component[]{new TextField("userName")});
        form.add(new Component[]{new PasswordTextField("password").setRequired(false)});
        form.add(new Component[]{new CheckBox("remember")});
        WebMarkupContainer signup = new WebMarkupContainer("signup"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isSelfRegisterEnabled());
            }
        };
        form.add(new Component[]{signup});
        signup.add(new Component[]{new StatelessLink<Void>("signupLink"){

            public void onClick() {
                this.setResponsePage(RegisterPage.class);
            }
        }});
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRemember() {
        return this.remember;
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    @Override
    protected boolean isAuthorized() {
        return true;
    }

    @Override
    protected String getBodyCssClass() {
        return "gray-body";
    }
}

