/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.log.NodeLog;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.component.LogPanel;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ServerLogPage
extends BasePage {
    private Date anchorDate;

    public ServerLogPage(Date anchorDate) {
        this.anchorDate = anchorDate;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new LogPanel("logPanel", (IModel<? extends Log>)new Model((Serializable)new NodeLog(Grid.instance.getLocalNode().getAddress(), this.anchorDate)), false)});
    }

    @Override
    protected boolean isAuthorized() {
        return SecurityHelper.isSystemLogAllowed();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.anchorDate != null) {
            response.renderOnLoadJavaScript("qb.anchorDate=" + this.anchorDate.getTime() + ";");
        }
    }
}

