/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.page.BasePage;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.RepeatingView;

public class RegisterPage
extends BasePage {
    @Override
    protected void onInitialize() {
        super.onInitialize();
        User user = new User();
        final EditContext editContext = new EditContext(user, new String[]{"subscriptions", "authenticator"}, true);
        final ArrayList<Pair<String, EditContext>> pluginSettingEditContexts = new ArrayList<Pair<String, EditContext>>();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            if (!plugin.isEnabled() || plugin.getUserSettingClass() == null) continue;
            try {
                pluginSettingEditContexts.add(new Pair<String, EditContext>(plugin.getId(), new EditContext(plugin.getUserSettingClass().newInstance())));
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        Component[] componentArray = new Component[1];
        Form form = new Form("form"){

            protected void onSubmit() {
                editContext.validate(false);
                boolean hasError = false;
                if (editContext.hasError()) {
                    hasError = true;
                }
                for (Pair pair : pluginSettingEditContexts) {
                    ((EditContext)pair.getSecond()).validate(false);
                    if (!((EditContext)pair.getSecond()).hasError()) continue;
                    hasError = true;
                }
                if (!hasError) {
                    User user = new User();
                    editContext.update(user);
                    User userWithSameName = UserManager.instance.get(user.getName());
                    if (userWithSameName != null) {
                        editContext.getProperty("name").setError("This name is already used by another user.");
                        return;
                    }
                    for (Pair pair : pluginSettingEditContexts) {
                        Object pluginSetting;
                        Plugin plugin = PluginManager.instance.getPlugin((String)pair.getFirst());
                        Validate.notNull((Object)plugin);
                        Validate.notNull(plugin.getUserSettingClass());
                        try {
                            pluginSetting = plugin.getUserSettingClass().newInstance();
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.wrapAsUnchecked(e);
                        }
                        ((EditContext)pair.getSecond()).update(pluginSetting);
                        user.getPluginSettingDOMs().put(plugin.getId(), VersionedDocument.fromBean(pluginSetting));
                    }
                    Membership membership = new Membership();
                    membership.setUser(user);
                    Group registerGroup = GroupManager.instance.get("register");
                    Validate.notNull((Object)registerGroup);
                    membership.setGroup(registerGroup);
                    user.getMemberships().add(membership);
                    UserManager.instance.save(user);
                    MembershipManager.instance.save(membership);
                    WebSession.get().setUserId(user.getId());
                    this.setResponsePage(this.getApplication().getHomePage());
                }
                super.onSubmit();
            }
        };
        componentArray[0] = form;
        this.add(componentArray);
        form.add(new Component[]{new BeanEditor("editor", editContext)});
        RepeatingView pluginSettingEditorsView = new RepeatingView("pluginSettingEditors");
        for (Pair pair : pluginSettingEditContexts) {
            pluginSettingEditorsView.add(new Component[]{new BeanEditor(pluginSettingEditorsView.newChildId(), (EditContext)pair.getSecond())});
        }
        form.add(new Component[]{pluginSettingEditorsView});
    }

    @Override
    protected boolean isAuthorized() {
        return SecurityHelper.isSelfRegisterEnabled();
    }

    @Override
    protected String getBodyCssClass() {
        return "gray-body";
    }
}

