/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.extensionpoint.MainTabContribution;
import com.pmease.quickbuild.license.CommercialLicense;
import com.pmease.quickbuild.license.CommercialLicense2;
import com.pmease.quickbuild.license.CommunityLicense;
import com.pmease.quickbuild.license.License;
import com.pmease.quickbuild.license.OpensourceLicense;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.system.SystemSetting;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.DbUtils;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.AjaxTextLink;
import com.pmease.quickbuild.web.component.tabbedpage.Tab;
import com.pmease.quickbuild.web.component.tabbedpage.TabbedPage;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.RegisterPage;
import com.pmease.quickbuild.web.page.SignInPage;
import com.pmease.quickbuild.web.page.SignOutPage;
import com.pmease.quickbuild.web.page.administration.AdministrationPage;
import com.pmease.quickbuild.web.page.administration.SystemSettingEdit;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import com.pmease.quickbuild.web.page.find.FoundConfigurationsPage;
import com.pmease.quickbuild.web.page.find.SearchBuildsOption;
import com.pmease.quickbuild.web.page.find.SearchBuildsPage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.grid.resource.ResourceEdit;
import com.pmease.quickbuild.web.page.my.MyPage;
import com.pmease.quickbuild.web.page.queue.QueuePage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public abstract class MainPage
extends BasePage {
    private String searchString;

    public MainPage() {
    }

    public MainPage(String searchString) {
        this.searchString = searchString;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        new RestartResponseAtInterceptPageException(SignInPage.class);
        String customHeader = CacheManager.instance.getSystemSetting().getCustomHeader();
        if (customHeader != null) {
            this.add(new Component[]{new Label("customHeader", customHeader).setEscapeModelStrings(false).setRenderBodyOnly(true)});
        } else {
            this.add(new Component[]{new Label("customHeader").setVisible(false)});
        }
        Label licenseNotice = new Label("licenseNotice", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    if (commercialLicense.isExpired()) {
                        return "Trial license expired. You may extend your trial period by sending email to <a href=\"mailto:sales@pmease.com\">sales@pmease.com</a> if you have not finished your trial yet, or you can <a href=\"http://www.pmease.com/purchase/buynow\">place order</a> for the commercial license if you decide to purchase.";
                    }
                    if (commercialLicense.getExpirationDate() == null && !commercialLicense.isEligible(Bootstrap.releaseDate)) {
                        return "Current license is only eligible for versions released before " + DateUtils.formatDate(commercialLicense.getServiceExpirationDate()) + ". " + "Please re-generate and install the license with your service account at <a href=\"http://www.pmease.com/account\">our web site</a> " + "if it is renewed recently; otherwise, you will need to <a href=\"http://www.pmease.com/purchase/buynow\">renew the service</a> to " + "use this version.";
                    }
                    if (commercialLicense.getExpirationDate() != null && commercialLicense.getExpirationDate().before(new Date(System.currentTimeMillis() + 604800000L))) {
                        return "Trial license will expire in " + (commercialLicense.getExpirationDate().getTime() - System.currentTimeMillis()) / 86400000L + " days. You may extend your trial period " + "by sending email to <a href=\"mailto:sales@pmease.com\">sales@pmease.com</a> if " + "you have not finished your trial yet, or you can <a href=\"http://www.pmease.com/purchase/buynow\">place order</a> for the commercial " + "license if you decide to purchase.";
                    }
                    return null;
                }
                if (license instanceof CommercialLicense) {
                    return "Current license is for 2.0.x. Please generate and install license for 2.1.x with your service account at <a href=\"http://www.pmease.com/account\"> our web site</a> if it is not expired; otherwise, you will need to <a href=\"http://www.pmease.com/purchase/buynow\">renew the service</a> to use this version.";
                }
                if (license instanceof CommunityLicense) {
                    int numOfConfigurations = CacheManager.instance.getConfigurationCount();
                    if (16 < numOfConfigurations) {
                        return "Number of existing configurations (" + numOfConfigurations + ") exceeds the " + "limit (" + 16 + ") set by current license. " + "You may <a href=\"mailto:sales@pmease.com\">request a trial commercial license</a> to remove this limit.";
                    }
                    return null;
                }
                return null;
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getDefaultModelObject() != null);
            }
        };
        licenseNotice.setEscapeModelStrings(false);
        this.add(new Component[]{licenseNotice});
        WebMarkupContainer pauseNotice = new WebMarkupContainer("systemPaused"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(CacheManager.instance.getSystemSetting().getPauseSystem() != null);
            }
        };
        this.add(new Component[]{pauseNotice});
        pauseNotice.add(new Component[]{new Label("reason", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return CacheManager.instance.getSystemSetting().getPauseSystem().getReason();
            }
        }){

            protected void onConfigure() {
                super.onInitialize();
                this.setVisible(this.getDefaultModelObject() != null);
            }
        }});
        pauseNotice.add(new Component[]{new Link<Void>("resume"){

            public void onClick() {
                SystemSetting systemSetting = SettingManager.instance.getSystemSettingDef();
                systemSetting.setPauseSystem(null);
                AuditManager.instance.audit("Administration::System Setting", "Resume system");
                SettingManager.instance.saveSystemSetting(systemSetting);
            }
        }.setVisible(SecurityHelper.isAdmin())});
        this.add(new Component[]{new Label("userName", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                User user = Context.getUser();
                return user != null ? user.getDisplayName() : "Guest";
            }
        })});
        this.add(new Component[]{new BookmarkablePageLink("signInLink", SignInPage.class){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getUser() == null);
            }
        }});
        this.add(new Component[]{new Link<Void>("signOutLink"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getUser() != null);
            }

            public void onClick() {
                this.setResponsePage(SignOutPage.class);
            }
        }});
        this.add(new Component[]{new Link("registerLink"){

            public void onClick() {
                this.setResponsePage(RegisterPage.class);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Context.getUser() == null && SecurityHelper.isSelfRegisterEnabled());
            }
        }});
        WebMarkupContainer systemLogLink = new WebMarkupContainer("serverLogLink"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(SecurityHelper.isSystemLogAllowed());
            }
        };
        this.add(new Component[]{systemLogLink});
        this.add(new Component[]{new WebMarkupContainer("docHome"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("href", (CharSequence)(Bootstrap.docroot + "/Documentation+Home"));
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("ads"){

            protected void onConfigure() {
                super.onConfigure();
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    this.setVisible(commercialLicense.getLicensedSite().toLowerCase().contains("pmease"));
                } else {
                    this.setVisible(false);
                }
            }
        }});
        Component[] componentArray = new Component[1];
        final Form form = new Form("quicksearch"){

            protected void onSubmit() {
                if (WebSession.get().getSearchFor() == User.SearchFor.BUILDS) {
                    SearchBuildsOption option = null;
                    if (MainPage.this.searchString != null) {
                        option = new SearchBuildsOption();
                        option.setVersion(MainPage.this.searchString);
                    }
                    this.setResponsePage((Page)new SearchBuildsPage(option));
                } else {
                    this.setResponsePage((Page)new FoundConfigurationsPage(MainPage.this.searchString));
                }
            }
        };
        componentArray[0] = form;
        this.add(componentArray);
        form.setOutputMarkupId(true);
        WebMarkupContainer searchFor = new WebMarkupContainer("searchFor");
        searchFor.add(new Behavior[]{new MenuBehavior(){

            @Override
            protected List<MenuItem> getMenuItems() {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>();
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new AjaxTextLink(componentId, (IModel)Model.of((Serializable)((Object)"Search Configurations"))){

                            public void onClick(AjaxRequestTarget target) {
                                WebSession.get().setSearchFor(User.SearchFor.CONFIGURATIONS);
                                MainPage.this.searchString = null;
                                target.add(new Component[]{form});
                            }
                        };
                    }
                });
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return new AjaxTextLink(componentId, (IModel)Model.of((Serializable)((Object)"Search Builds"))){

                            public void onClick(AjaxRequestTarget target) {
                                WebSession.get().setSearchFor(User.SearchFor.BUILDS);
                                MainPage.this.searchString = null;
                                target.add(new Component[]{form});
                            }
                        };
                    }
                });
                return items;
            }
        }});
        form.add(new Component[]{searchFor});
        TextField input = new TextField("input", new IModel(){

            public Object getObject() {
                return MainPage.this.searchString;
            }

            public void setObject(Object object) {
                MainPage.this.searchString = (String)object;
            }

            public void detach() {
            }
        }){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (WebSession.get().getSearchFor() == User.SearchFor.CONFIGURATIONS) {
                    tag.put("placeholder", (CharSequence)"search configurations");
                } else {
                    tag.put("placeholder", (CharSequence)"search builds");
                }
            }
        };
        form.add(new Component[]{input});
        input.add(new Behavior[]{new PopupBehavior(){

            @Override
            protected Component getPopup(String componentId) {
                if (WebSession.get().getSearchFor() == User.SearchFor.CONFIGURATIONS) {
                    return new Fragment(componentId, "searchConfigurationsHelpFrag", (MarkupContainer)MainPage.this);
                }
                return new Fragment(componentId, "searchBuildsHelpFrag", (MarkupContainer)MainPage.this);
            }
        }});
        WebMarkupContainer footer = new WebMarkupContainer("footer");
        this.add(new Component[]{footer});
        footer.add(new Component[]{new Label("versionInfo", Bootstrap.buildVersion)});
        footer.add(new Component[]{new Label("releaseDate", DateUtils.formatDate(Bootstrap.releaseDate))});
        footer.add(new Component[]{new Label("licenseInfo", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    if (commercialLicense.getExpirationDate() != null) {
                        return "Trial Commercial License";
                    }
                    return "Commercial License for Site '" + commercialLicense.getLicensedSite() + "'";
                }
                if (license instanceof CommercialLicense) {
                    CommercialLicense commercialLicense = (CommercialLicense)license;
                    if (commercialLicense.getExpirationDate() != null) {
                        return "Trial Commercial License (for 2.0.x)";
                    }
                    return "Commercial License (for 2.0.x)";
                }
                if (license instanceof OpensourceLicense) {
                    OpensourceLicense opensourceLicense = (OpensourceLicense)license;
                    return "Open Source License for '" + opensourceLicense.getLicensedProject() + "'";
                }
                return "Community License";
            }
        })});
        footer.add(new Component[]{new Label("serviceAccount", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    return ((CommercialLicense2)license).getServiceAccount();
                }
                return ((CommercialLicense)license).getServiceAccount();
            }
        }){

            protected void onConfigure() {
                super.onConfigure();
                if (!SecurityHelper.isAdmin()) {
                    this.setVisible(false);
                    return;
                }
                License license = CacheManager.instance.getLicense();
                if (license instanceof CommercialLicense2) {
                    CommercialLicense2 commercialLicense = (CommercialLicense2)license;
                    this.setVisible(commercialLicense.getExpirationDate() == null && commercialLicense.getServiceAccount() != null);
                } else if (license instanceof CommercialLicense) {
                    CommercialLicense commercialLicense = (CommercialLicense)license;
                    this.setVisible(commercialLicense.getExpirationDate() == null && commercialLicense.getServiceAccount() != null);
                } else {
                    this.setVisible(false);
                }
            }
        }});
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        tabs.add(new Tab("Dashboards", DashboardPage.class));
        tabs.add(new Tab("Grid", GridPage.class, ResourceEdit.class));
        tabs.add(new Tab("Queue", QueuePage.class));
        ArrayList<MainTabContribution> contributions = new ArrayList<MainTabContribution>();
        for (MainTabContribution contribution : PluginManager.instance.getExtensions(MainTabContribution.class)) {
            contributions.add(contribution);
        }
        Collections.sort(contributions, new Comparator<MainTabContribution>(){

            @Override
            public int compare(MainTabContribution contribution1, MainTabContribution contribution2) {
                return contribution1.getOrder() - contribution2.getOrder();
            }
        });
        for (MainTabContribution contribution : contributions) {
            tabs.addAll(contribution.getTabs());
        }
        if (SecurityHelper.isAdmin()) {
            tabs.add(new Tab("Administration", SystemSettingEdit.class, AdministrationPage.class));
        }
        if (Context.getUser() != null) {
            tabs.add(new Tab("My", MyPage.class));
        }
        this.add(new Component[]{new TabbedPage("mainTab", tabs)});
        WebMarkupContainer dbNotice = new WebMarkupContainer("dbNotice"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(DbUtils.isH2() && SecurityHelper.isAdmin());
            }
        };
        this.add(new Component[]{dbNotice});
        dbNotice.add(new Component[]{new WebMarkupContainer("dbDoc"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("href", (CharSequence)(Bootstrap.docroot + "/Data+Management"));
            }
        }});
    }

    protected String getSearchString() {
        return this.searchString;
    }
}

