/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.build.StepLogPage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.wicket.Page;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class LogPage
extends BasePage {
    public LogPage(PageParameters params) {
        String param = params.get(0).toString();
        if (NumberUtils.isDigits((String)param)) {
            Long buildId = Long.valueOf(param);
            String encodedStepPathName = params.get(1).toString();
            if (encodedStepPathName == null) {
                this.setResponsePage(BuildPage.class, BuildPage.params4(buildId, new String[]{"log"}));
            } else {
                try {
                    String stepPathName = new String(Hex.decodeHex((char[])encodedStepPathName.toCharArray()));
                    this.setResponsePage((Page)new StepLogPage(buildId, StepPath.fromString(stepPathName)));
                }
                catch (DecoderException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            String nodeAddress;
            if (param == null) {
                nodeAddress = Grid.instance.getServerNode().getAddress();
            } else {
                try {
                    nodeAddress = URLDecoder.decode(param, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            params = GridPage.params4(nodeAddress, "log");
            this.setResponsePage(GridPage.class, params);
        }
    }
}

