/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class BuildsTabState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long configurationId;
    private String buildIdOrVersion;

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public String getBuildIdOrVersion() {
        return this.buildIdOrVersion;
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }

    public void setBuildIdOrVersion(String buildIdOrVersion) {
        this.buildIdOrVersion = buildIdOrVersion;
    }

    public BuildsTabState(String string) {
        if (NumberUtils.isDigits((String)string)) {
            BuildManager buildManager = Quickbuild.getInstance(BuildManager.class);
            Build build = (Build)buildManager.load(Long.valueOf(string));
            this.configurationId = build.getConfiguration().getId();
            this.buildIdOrVersion = string;
        } else {
            this.configurationId = Long.valueOf(StringUtils.substringBefore((String)string, (String)":"));
            this.buildIdOrVersion = StringUtils.substringAfter((String)string, (String)":");
        }
    }

    public BuildsTabState(Long configurationId, String buildIdOrVersion) {
        this.configurationId = configurationId;
        this.buildIdOrVersion = buildIdOrVersion;
    }

    public String getReservedVersion() {
        if (NumberUtils.isDigits((String)this.buildIdOrVersion)) {
            return null;
        }
        if (Build.RESERVED_VERSIONS.contains(this.buildIdOrVersion.toLowerCase())) {
            return this.buildIdOrVersion.toLowerCase();
        }
        return null;
    }

    public Long getBuildId() {
        if (NumberUtils.isDigits((String)this.buildIdOrVersion)) {
            return Long.valueOf(this.buildIdOrVersion);
        }
        return null;
    }

    public String getAllWhich() {
        String reservedVersion = this.getReservedVersion();
        if (reservedVersion != null && reservedVersion.startsWith("all")) {
            return StringUtils.substringAfter((String)reservedVersion, (String)"_");
        }
        return null;
    }

    public String getLatestWhich() {
        String reservedVersion = this.getReservedVersion();
        if (reservedVersion != null && reservedVersion.startsWith("latest")) {
            return StringUtils.substringAfter((String)reservedVersion, (String)"_");
        }
        return null;
    }
}

