/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.page;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.WordUtils;
import com.pmease.quickbuild.web.AssetPack;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.behavior.DropBehavior;
import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.JavascriptText;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.page.ServerStartingPage;
import com.pmease.quickbuild.web.page.SignInPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePage
extends WebPage {
    private static final Logger logger = LoggerFactory.getLogger(BasePage.class);
    public static final String AUTO_REFRESH_LINK_ID = "ajaxRefreshLink";
    private WebMarkupContainer body;
    private IModel<Map<Long, Configuration>> configurationsModel = new LoadableDetachableModel<Map<Long, Configuration>>(){

        protected Map<Long, Configuration> load() {
            return CacheManager.instance.cloneConfigurations();
        }
    };
    private FeedbackPanel feedbackPanel;
    private RepeatingView popups;
    private RepeatingView dialogs;
    private boolean dirty;
    private List<Component> renderedComponents = new ArrayList<Component>();
    public static AssetPack[] ASSET_PACKS = new AssetPack[]{new AssetPack("/jquery/css/smoothness/package.css", new String[]{"/jquery/css/smoothness/jquery-ui-1.8.11.custom.css"}), new AssetPack("/jquery/colorpicker/css/package.css", new String[]{"/jquery/colorpicker/css/colorpicker.css"}), new AssetPack("/styles/package.css", new String[]{"/styles/global.css", "/styles/font-awesome.css", "/styles/report.css", "/styles/measurement.css", "/styles/page.css", "/styles/component.css", "/styles/jhighlight.css"}), new AssetPack("/package.js", new String[]{"/jquery/jquery-1.5.1.min.js", "/jquery/jquery-ui-1.8.11.custom.min.js", "/jquery/plugins/jquery.align.js", "/jquery/plugins/jquery.tooltip.js", "/jquery/plugins/jquery.popup.js", "/jquery/plugins/jquery.center.js", "/jquery/plugins/jquery.fancytip.js", "/jquery/plugins/jquery.ui.layout.js", "/jquery/colorpicker/js/colorpicker.js", "/scripts/autosize.js", "/scripts/main.js", "/scripts/detect-timezone.js", "/jquery/plugins/jquery.truncate.js"})};
    public static MetaDataKey<Component> TRIGGER = new MetaDataKey<Component>(){};

    public BasePage() {
        if (!this.isBootstrap() && !this.isSessionReady()) {
            throw new RestartResponseAtInterceptPageException(ServerStartingPage.class);
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        if (!this.isAuthorized()) {
            if (Context.getUser() == null) {
                throw new RestartResponseAtInterceptPageException(SignInPage.class);
            }
            throw new AccessDeniedException();
        }
        this.add(new Component[]{new Label("pageTitle", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return BasePage.this.getPageTitle();
            }
        })});
        this.add(new Component[]{new WebMarkupContainer("refresh"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("content", BasePage.this.getPageRefreshInterval());
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(BasePage.this.getPageRefreshInterval() != 0);
            }
        }});
        Component[] componentArray = new Component[1];
        this.body = new TransparentWebMarkupContainer("body");
        componentArray[0] = this.body;
        this.add(componentArray);
        String simpleName = ((Object)((Object)this)).getClass().getSimpleName();
        if (StringUtils.isNotBlank((String)simpleName)) {
            String uncamelled = WordUtils.uncamel(simpleName);
            this.body.setMarkupId(uncamelled.toLowerCase().replace(' ', '-'));
        }
        this.body.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)this.getBodyCssClass())), " ")});
        this.add(new Component[]{new WebMarkupContainer("asset"){

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                for (AssetPack pack : ASSET_PACKS) {
                    pack.renderHead(response);
                }
            }
        }});
        this.add(new Component[]{new JavascriptText("detectTimeZone", (IModel<String>)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                if (BasePage.this.isSessionReady() && CacheManager.instance.getSystemSetting().isDetectTimeZone() && Context.getUserTimeZone() == null) {
                    return "document.cookie = \"QuickBuildUserTimeZone=\" + calculate_time_zone(); location.reload(true);";
                }
                return "";
            }
        })});
        this.feedbackPanel = new FeedbackPanel("globalFeedback", new IFeedbackMessageFilter(){

            public boolean accept(FeedbackMessage message) {
                return message.getReporter() == null;
            }
        });
        this.add(new Component[]{this.feedbackPanel});
        this.feedbackPanel.setOutputMarkupId(true);
        if (this.getAjaxRefreshInterval() != 0) {
            this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){

                public boolean getStatelessHint(Component component) {
                    return true;
                }

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    response.renderJavaScript((CharSequence)("function ajaxRefresh() {\n\tif ($('.ui-dialog').is(':visible')) {\n\t\tsetTimeout(ajaxRefresh, " + BasePage.this.getAjaxRefreshInterval() + ");\n" + "\t} else {\n" + "\t\t" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&action=ajaxRefresh'") + "\n" + "\t}\n" + "}"), null);
                    response.renderOnLoadJavaScript("setTimeout(ajaxRefresh, " + BasePage.this.getAjaxRefreshInterval() + ");");
                }

                protected void respond(final AjaxRequestTarget target) {
                    try {
                        BasePage.this.dirty = false;
                        final Date lastRefreshDate = WebSession.get().getLastRefreshDates().get(BasePage.this.getPageId());
                        WebSession.get().getLastRefreshDates().put(BasePage.this.getPageId(), new Date(System.currentTimeMillis() - 1000L));
                        BasePage.this.visitChildren((IVisitor)new IVisitor<Component, Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void component(Component component, IVisit<Void> visit) {
                                Context.pushComponent(component);
                                try {
                                    for (RefreshBehavior behavior : component.getBehaviors(RefreshBehavior.class)) {
                                        RefreshBehavior refreshBehavior = behavior;
                                        if (!refreshBehavior.needRefresh(visit, lastRefreshDate)) continue;
                                        if (component.isVisibleInHierarchy()) {
                                            target.add(component);
                                        }
                                        visit.dontGoDeeper();
                                        return;
                                    }
                                }
                                finally {
                                    Context.popComponent();
                                }
                            }
                        });
                        target.appendJavaScript("setTimeout(ajaxRefresh, " + BasePage.this.getAjaxRefreshInterval() + ");");
                        target.focusComponent(null);
                        if (target.getComponents().size() != 0) {
                            BasePage.this.dirty = true;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error refreshing page via ajax.", (Throwable)e);
                    }
                }
            }});
        }
        this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){

            public boolean getStatelessHint(Component component) {
                return true;
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.renderJavaScript((CharSequence)("function onDrop(dragFrom, dropTo) {" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&action=dragDrop&dragFrom=' + encodeURIComponent(dragFrom) + '&dropTo=' + encodeURIComponent(dropTo)") + "}"), null);
                response.renderJavaScript((CharSequence)("function loadPopup(triggerPath) {" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&action=loadPopup&triggerPath=' + encodeURIComponent(triggerPath)") + "}"), null);
                response.renderJavaScript((CharSequence)("function unloadPopup(triggerPath) {" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&action=unloadPopup&triggerPath=' + encodeURIComponent(triggerPath)") + "}"), null);
                response.renderJavaScript((CharSequence)("function closeDialog(dialogPath) {" + this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&action=closeDialog&dialogPath=' + encodeURIComponent(dialogPath)") + "}"), null);
            }

            protected void respond(AjaxRequestTarget target) {
                IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
                String action = params.getParameterValue("action").toString();
                if (action.equals("dragDrop")) {
                    String dropTo = params.getParameterValue("dropTo").toString();
                    String dragFrom = params.getParameterValue("dragFrom").toString();
                    for (Behavior behavior : BasePage.this.getPage().get(dropTo).getBehaviors()) {
                        if (!(behavior instanceof DropBehavior)) continue;
                        ((DropBehavior)behavior).onDropped(target, dragFrom);
                    }
                } else if (action.equals("loadPopup")) {
                    String triggerPath = params.getParameterValue("triggerPath").toString();
                    Component trigger = BasePage.this.get(triggerPath);
                    if (trigger != null) {
                        PopupBehavior behavior = trigger.getBehaviors(PopupBehavior.class).get(0);
                        behavior.loadPopup(target);
                    }
                } else if (action.equals("unloadPopup")) {
                    String triggerPath = params.getParameterValue("triggerPath").toString();
                    Component trigger = BasePage.this.get(triggerPath);
                    if (trigger != null) {
                        PopupBehavior behavior = trigger.getBehaviors(PopupBehavior.class).get(0);
                        behavior.unloadPopup();
                    }
                } else if (action.equals("closeDialog")) {
                    String dialogPath = params.getParameterValue("dialogPath").toString();
                    Component dialogContent = BasePage.this.get(dialogPath);
                    if (dialogContent != null) {
                        Dialog.close(target, dialogContent);
                    }
                } else {
                    throw new IllegalStateException("Unrecognized action: " + action);
                }
            }
        }});
        Component[] componentArray2 = new Component[1];
        this.popups = new RepeatingView("popups");
        componentArray2[0] = this.popups;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.dialogs = new RepeatingView("dialogs");
        componentArray3[0] = this.dialogs;
        this.add(componentArray3);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        WebSession.get().getLastRefreshDates().put(this.getPageId(), new Date(System.currentTimeMillis() - 1000L));
        this.dialogs.removeAll();
        ArrayList<Component> popupList = new ArrayList<Component>();
        for (int i = 0; i < this.popups.size(); ++i) {
            popupList.add(this.popups.get(i));
        }
        for (Component popup : popupList) {
            Component trigger = popup.getMetaData(TRIGGER);
            if (trigger == null) continue;
            PopupBehavior behavior = trigger.getBehaviors(PopupBehavior.class).get(0);
            behavior.unloadPopup();
        }
    }

    public static BasePage get() {
        if (Context.getComponent() != null) {
            return (BasePage)Context.getComponent().getPage();
        }
        return null;
    }

    protected int getAjaxRefreshInterval() {
        return 0;
    }

    protected int getPageRefreshInterval() {
        return 0;
    }

    protected String getPageTitle() {
        return "QuickBuild - the build lifecycle management server";
    }

    protected boolean isAuthorized() {
        return Context.getUser() != null || SecurityHelper.isAnonymousEnabled();
    }

    protected boolean isBootstrap() {
        return false;
    }

    protected String getBodyCssClass() {
        return "";
    }

    public void renderHead(HtmlHeaderContainer container) {
        if (this.isAuthorized()) {
            super.renderHead(container);
        }
    }

    public Map<Long, Configuration> getConfigurations() {
        return (Map)this.configurationsModel.getObject();
    }

    public Configuration getConfiguration(String path) {
        for (Configuration each : this.getConfigurations().values()) {
            if (!each.getPathName().equals(path)) continue;
            return each;
        }
        return null;
    }

    public IMarkupFragment getMarkup(Component child) {
        if (child != null) {
            IMarkupFragment markup = super.getMarkup(child);
            if (markup != null) {
                return markup;
            }
            if (this.body != null) {
                return this.body.getMarkup(child);
            }
            return null;
        }
        final IMarkupFragment markup = super.getMarkup(child);
        return new IMarkupFragment(){

            public String toString(boolean markupOnly) {
                return markup.toString();
            }

            public int size() {
                return markup.size();
            }

            public MarkupResourceStream getMarkupResourceStream() {
                return markup.getMarkupResourceStream();
            }

            public MarkupElement get(int index) {
                return markup.get(index);
            }

            public IMarkupFragment find(String id) {
                IMarkupFragment found = markup.find(id);
                if (found != null) {
                    return found;
                }
                if (BasePage.this.body != null) {
                    return BasePage.this.body.getMarkup().find(id);
                }
                return null;
            }

            public Iterator<MarkupElement> iterator() {
                return markup.iterator();
            }
        };
    }

    protected final boolean isSessionReady() {
        return SessionManager.getSession() != null;
    }

    public FeedbackPanel getGlobalFeedbackPanel() {
        return this.feedbackPanel;
    }

    public RepeatingView getPopups() {
        return this.popups;
    }

    public RepeatingView getDialogs() {
        return this.dialogs;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public List<Component> getRenderedComponents() {
        return this.renderedComponents;
    }

    protected void onDetach() {
        if (this.configurationsModel != null) {
            this.configurationsModel.detach();
        }
        super.onDetach();
    }
}

