/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.gadget;

import com.pmease.quickbuild.annotation.ConfigurationId;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.extensionpoint.support.GadgetErrorPanel;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.web.component.configuration.ConfigurationTreeView;
import com.pmease.quickbuild.web.page.BasePage;
import java.util.Stack;
import javax.validation.constraints.NotNull;
import org.apache.wicket.markup.html.panel.Panel;

@Editable(name="Configuration Tree", order=10, category={"Configuration and Build"})
public class ConfigurationTreeGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private Long treeRoot;
    private boolean displayTreeRoot = true;
    private boolean displaySchedule;
    private boolean displayRequestCount = true;
    private boolean displayHistoryCount = true;

    @Editable(order=200, description="Specify configuration path of the tree root.")
    @ConfigurationId
    @NotNull
    public Long getTreeRoot() {
        return this.treeRoot;
    }

    public void setTreeRoot(Long treeRoot) {
        this.treeRoot = treeRoot;
    }

    @Editable(order=250, description="Whether or not to include the tree root itself in the tree.")
    public boolean isDisplayTreeRoot() {
        return this.displayTreeRoot;
    }

    public void setDisplayTreeRoot(boolean displayTreeRoot) {
        this.displayTreeRoot = displayTreeRoot;
    }

    @Editable(order=400, description="Whether or not to display schedule of the configurations.")
    public boolean isDisplaySchedule() {
        return this.displaySchedule;
    }

    public void setDisplaySchedule(boolean displaySchedule) {
        this.displaySchedule = displaySchedule;
    }

    @Editable(order=500, description="Whether or not to display total number of build requests of the configurations.")
    public boolean isDisplayRequestCount() {
        return this.displayRequestCount;
    }

    public void setDisplayRequestCount(boolean displayRequestCount) {
        this.displayRequestCount = displayRequestCount;
    }

    @Editable(order=600, description="Whether or not to display total number of history builds of the configurations.")
    public boolean isDisplayHistoryCount() {
        return this.displayHistoryCount;
    }

    public void setDisplayHistoryCount(boolean displayHistoryCount) {
        this.displayHistoryCount = displayHistoryCount;
    }

    public Panel renderBody(String panelId) {
        Configuration parent = BasePage.get().getConfigurations().get(this.treeRoot);
        if (parent != null) {
            return new ConfigurationTreeView(panelId, parent.getId(), this.isDisplayTreeRoot(), this.isDisplaySchedule(), this.isDisplayRequestCount(), this.isDisplayHistoryCount());
        }
        return new GadgetErrorPanel(panelId, "Can not find configuration with id '" + this.getTreeRoot() + "'.");
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("displayQueue").detach();
    }
}

