/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.wizard;

import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.wizard.WizardStep;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public abstract class Wizard
extends Panel {
    private Form form;
    private int activeStepIndex = 0;

    public Wizard(String id, IModel<List<WizardStep>> model) {
        super(id, model);
        this.add(new Component[]{new Label("activeIndex", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return String.valueOf(Wizard.this.activeStepIndex + 1) + ". ";
            }
        })});
        this.add(new Component[]{new Label("stepName", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                WizardStep step = Wizard.this.getActiveStep();
                return EditorHelper.getName(step.getBean().getClass());
            }
        })});
        this.add(new Component[]{new Label("stepsInfo", (IModel)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return String.valueOf(Wizard.this.activeStepIndex + 1) + " of " + Wizard.this.getSteps().size();
            }
        })});
        this.form = new Form("form");
        this.form.add(new Component[]{new Label("description", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                return EditorHelper.getDescription(Wizard.this.getActiveStep().getBean().getClass());
            }
        })});
        this.form.get("description").setEscapeModelStrings(false);
        this.form.add(new Component[]{this.getActiveStep().getEditor("editor")});
        this.form.add(new Component[]{new Link("back"){

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(Wizard.this.activeStepIndex > 0);
            }

            public void onClick() {
                Wizard.this.activeStepIndex--;
                Wizard.this.form.replace((Component)((Object)Wizard.this.getActiveStep().getEditor("editor")));
            }
        }});
        this.form.add(new Component[]{new SubmitLink("next"){

            public void onSubmit() {
                if (Wizard.this.getActiveStep().finish()) {
                    Wizard.this.getActiveStep().finished();
                    Wizard.this.activeStepIndex++;
                    Wizard.this.form.replace((Component)((Object)Wizard.this.getActiveStep().getEditor("editor")));
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(Wizard.this.activeStepIndex < Wizard.this.getSteps().size() - 1);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (this.isEnabled()) {
                    tag.put("type", (CharSequence)"submit");
                } else {
                    tag.put("type", (CharSequence)"button");
                }
            }
        }});
        this.form.add(new Component[]{new Link<Void>("skip"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(Wizard.this.getActiveStep().isOptional());
            }

            public void onClick() {
                Wizard.this.getActiveStep().skipped();
                if (Wizard.this.activeStepIndex < Wizard.this.getSteps().size() - 1) {
                    Wizard.this.activeStepIndex++;
                    Wizard.this.form.replace((Component)((Object)Wizard.this.getActiveStep().getEditor("editor")));
                } else {
                    Wizard.this.finished();
                }
            }
        }});
        this.form.add(new Component[]{new SubmitLink("finish"){

            public void onSubmit() {
                if (Wizard.this.getActiveStep().finish()) {
                    Wizard.this.getActiveStep().finished();
                    Wizard.this.finished();
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(Wizard.this.activeStepIndex == Wizard.this.getSteps().size() - 1);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (this.isEnabled()) {
                    tag.put("type", (CharSequence)"submit");
                } else {
                    tag.put("type", (CharSequence)"button");
                }
            }
        }});
        this.add(new Component[]{this.form});
    }

    private WizardStep getActiveStep() {
        return this.getSteps().get(this.activeStepIndex);
    }

    private List<WizardStep> getSteps() {
        return (List)this.getDefaultModelObject();
    }

    protected abstract void finished();
}

