/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.viewer;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ViewContext
implements Serializable {
    private Class beanClass;
    private List<ViewableProperty> properties = new ArrayList<ViewableProperty>();

    public ViewContext(Object bean) {
        this(bean, new String[0], true);
    }

    public ViewContext(Object bean, String[] propertyNames) {
        this(bean, propertyNames, false);
    }

    public ViewContext(Object bean, String[] propertyNames, boolean exclude) {
        if (bean == null) {
            System.err.println("#######");
        }
        this.beanClass = ClassUtils.unproxy(bean.getClass());
        ArrayList<String> includePropertyNames = new ArrayList();
        if (exclude) {
            List<String> excludePropertyNames = Arrays.asList(propertyNames);
            for (Method viewable : ViewContext.getViewables(this.beanClass)) {
                if (excludePropertyNames.contains(BeanUtils.getPropertyName(viewable))) continue;
                includePropertyNames.add(BeanUtils.getPropertyName(viewable));
            }
        } else {
            includePropertyNames = Arrays.asList(propertyNames);
        }
        this.init(bean, includePropertyNames);
    }

    public static List<Method> getViewables(Class<?> beanClass) {
        List<Method> getters = BeanUtils.getGetters(beanClass);
        Iterator<Method> it = getters.iterator();
        while (it.hasNext()) {
            if (it.next().getAnnotation(Editable.class) != null) continue;
            it.remove();
        }
        EditorHelper.sortAnnotatedElements(getters);
        return getters;
    }

    private void init(Object bean, List<String> propertyNames) {
        TypeConverterRegistry typeConverterRegistry = Quickbuild.getInstance(TypeConverterRegistry.class);
        try {
            for (String propertyName : propertyNames) {
                ViewableProperty viewableProperty;
                Method getter = BeanUtils.getGetter(this.beanClass, propertyName);
                Inheritable inheritable = getter.getAnnotation(Inheritable.class);
                Object value = null;
                if (inheritable != null) {
                    Configuration current = (Configuration)bean;
                    do {
                        try {
                            value = getter.invoke((Object)current, new Object[0]);
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.wrapAsUnchecked(e);
                        }
                    } while (value == null && (current = current.getParent()) != null);
                } else {
                    try {
                        value = getter.invoke(bean, new Object[0]);
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                }
                TypeConverter typeConverter = typeConverterRegistry.getTypeConverter(getter);
                if (typeConverter != null) {
                    viewableProperty = new ViewableProperty(propertyName);
                    viewableProperty.setValue(typeConverter.toString(value));
                    this.properties.add(viewableProperty);
                    continue;
                }
                if (Collection.class.isAssignableFrom(getter.getReturnType())) {
                    ArrayList<ViewContext> list = new ArrayList<ViewContext>();
                    Collection propertyValue = (Collection)value;
                    if (propertyValue != null) {
                        for (Object element : propertyValue) {
                            list.add(new ViewContext(element));
                        }
                    }
                    ViewableProperty viewableProperty2 = new ViewableProperty(propertyName);
                    viewableProperty2.setValue(list);
                    this.properties.add(viewableProperty2);
                    continue;
                }
                if (ClassUtils.isSystemType(getter.getReturnType())) {
                    throw new QuickbuildException(ExceptionUtils.buildMessage("Type is not supported.", "class", this.beanClass.getName(), "property", propertyName));
                }
                viewableProperty = new ViewableProperty(propertyName);
                if (value != null) {
                    viewableProperty.setValue(new ViewContext(value));
                } else {
                    viewableProperty.setValue(null);
                }
                this.properties.add(viewableProperty);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public List<ViewableProperty> getProperties() {
        return this.properties;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public ViewableProperty getProperty(String name) {
        for (ViewableProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage("Can not find editable property.", "class", this.beanClass.getName(), "property", name));
    }

    public static class ViewableProperty
    implements Serializable {
        private String name;
        private Object value;

        public ViewableProperty(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

