/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.viewer;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.ErrorMessage;
import com.pmease.quickbuild.annotation.General;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.MultilineText;
import com.pmease.quickbuild.web.component.configuration.InheritIndicator;
import com.pmease.quickbuild.web.component.viewer.BeanPropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ListPropertyViewer;
import com.pmease.quickbuild.web.component.viewer.PolymorphicPropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public class PropertyViewer
extends Panel {
    public PropertyViewer(String id, Class<?> beanClass, ViewContext.ViewableProperty property) {
        super(id);
        TypeConverter typeConverter;
        Method getter = BeanUtils.getGetter(beanClass, property.getName());
        Configuration inherited = null;
        Configuration override = null;
        Inheritable inheritable = getter.getAnnotation(Inheritable.class);
        if (inheritable != null) {
            inherited = Context.getConfiguration();
            do {
                try {
                    if (getter.invoke((Object)inherited, new Object[0]) == null) continue;
                    break;
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            } while ((inherited = inherited.getParent()) != null);
            for (override = Context.getConfiguration().getParent(); override != null; override = override.getParent()) {
                try {
                    if (getter.invoke((Object)override, new Object[0]) == null) continue;
                    break;
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }
        }
        if ((typeConverter = Quickbuild.getInstance(TypeConverterRegistry.class).getTypeConverter(getter)) != null) {
            Object label;
            String propertyValue = (String)property.getValue();
            if (StringUtils.isNotBlank((String)propertyValue)) {
                if (getter.getAnnotation(Password.class) == null) {
                    if (getter.getAnnotation(ErrorMessage.class) != null) {
                        propertyValue = "<span style='color:red;white-space:normal;'>" + StringUtils.formatAsHtml(propertyValue) + "</span>";
                        label = new Label("viewer", propertyValue);
                        ((Component)label).setEscapeModelStrings(false);
                    } else if (getter.getAnnotation(Scriptable.class) != null || getter.getAnnotation(Script.class) != null || ScriptEngine.instance.interpolative(propertyValue)) {
                        propertyValue = StringUtils.formatAsHtml(propertyValue);
                        propertyValue = StringUtils.replace((String)propertyValue, (String)" ", (String)"&nbsp;");
                        propertyValue = "<span style='white-space:nowrap;'>" + propertyValue + "</span>";
                        label = new Label("viewer", propertyValue);
                        ((Component)label).setEscapeModelStrings(false);
                    } else {
                        label = new MultilineText("viewer", propertyValue);
                    }
                } else {
                    label = new Label("viewer", "********");
                }
            } else {
                label = new Label("viewer", "<i style='color:gray;'>not defined</i>").setEscapeModelStrings(false);
            }
            this.add(new Component[]{label});
        } else if (Collection.class.isAssignableFrom(getter.getReturnType())) {
            this.add(new Component[]{new ListPropertyViewer("viewer", beanClass, property)});
        } else if ((getter.getReturnType().getModifiers() & 0x600) != 0) {
            this.add(new Component[]{new PolymorphicPropertyViewer("viewer", beanClass, property)});
        } else {
            this.add(new Component[]{new BeanPropertyViewer("viewer", beanClass, property)});
        }
        if (property.getValue() != null && inherited != null) {
            String setting = getter.getAnnotation(General.class) != null ? "general" : "advanced";
            this.add(new Component[]{new InheritIndicator("link", inherited, override, setting)});
        } else {
            WebMarkupContainer link = new WebMarkupContainer("link");
            link.setVisible(false);
            this.add(new Component[]{link});
        }
    }
}

