/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.viewer;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.viewer.PropertyViewer;
import com.pmease.quickbuild.web.component.viewer.ViewContext;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class ListPropertyViewer
extends Panel {
    private Class<?> elementType;
    private transient List<Method> columns;

    public ListPropertyViewer(String id, Class beanClass, ViewContext.ViewableProperty property) {
        super(id);
        List contexts;
        WebMarkupContainer table = new WebMarkupContainer("table");
        this.add(new Component[]{table});
        Method getter = BeanUtils.getGetter(beanClass, property.getName());
        try {
            contexts = (List)property.getValue();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        this.elementType = ClassUtils.getCollectionElementType(getter.getGenericReturnType());
        if (this.elementType == null) {
            throw new QuickbuildException(ExceptionUtils.buildMessage("Element type unknown.", "class", beanClass.getName(), "property", property.getName()));
        }
        if (ClassUtils.isSystemType(this.elementType)) {
            throw new QuickbuildException(ExceptionUtils.buildMessage("Not supported element type.", "class", beanClass.getName(), "property", property.getName()));
        }
        table.add(new Component[]{new ListView("headerColumns", (IModel)new AbstractReadOnlyModel(){

            public Object getObject() {
                return ListPropertyViewer.this.getColumns();
            }
        }){

            protected void populateItem(ListItem item) {
                Method column = (Method)item.getModelObject();
                item.add(new Component[]{new Label("name", EditorHelper.getName(column))});
            }
        }});
        table.add(new Component[]{new ListView<ViewContext>("rows", contexts){

            protected void populateItem(ListItem<ViewContext> rowItem) {
                final ViewContext context = (ViewContext)rowItem.getModelObject();
                rowItem.add(new Component[]{new ListView("columns", (IModel)new AbstractReadOnlyModel(){

                    public Object getObject() {
                        return ListPropertyViewer.this.getColumns();
                    }
                }){

                    protected void populateItem(ListItem columnItem) {
                        Method column = (Method)columnItem.getModelObject();
                        PropertyViewer propertyViewer = new PropertyViewer("editor", ListPropertyViewer.this.elementType, context.getProperty(BeanUtils.getPropertyName(column)));
                        columnItem.add(new Component[]{propertyViewer});
                    }
                }});
            }
        }});
        table.setVisible(!contexts.isEmpty());
        this.add(new Component[]{new WebMarkupContainer("notDefined").setVisible(contexts.isEmpty())});
    }

    private List<Method> getColumns() {
        if (this.columns == null) {
            this.columns = ViewContext.getViewables(this.elementType);
        }
        return this.columns;
    }
}

