/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.treetable;

import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.component.treetable.TreeDataProvider;
import com.pmease.quickbuild.web.component.treetable.TreeNode;
import com.pmease.quickbuild.web.component.treetable.TreeState;
import com.pmease.quickbuild.web.component.treetable.TreeTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxCallDecorator;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TreeTable
extends Panel {
    private TreeDataProvider dataProvider;
    private TreeState state;
    private Map<Serializable, TreeNode> treeMap = new LinkedHashMap<Serializable, TreeNode>();
    private Set<Serializable> selectedKeys;
    private TreeTableColumn treeColumn;
    private TreeTableColumn[] tableColumns;
    private AjaxCheckBox allOrNoneSelector;
    private RepeatingView rowsView;
    private Form form;

    public TreeTable(String id, TreeDataProvider dataProvider, TreeState state, TreeTableColumn treeColumn, TreeTableColumn[] tableColumns, boolean rowSelectable) {
        super(id);
        this.dataProvider = dataProvider;
        this.treeColumn = treeColumn;
        this.tableColumns = tableColumns;
        this.state = state;
        this.setOutputMarkupId(true);
        if (rowSelectable) {
            this.selectedKeys = new HashSet<Serializable>();
        }
        Component[] componentArray = new Component[1];
        this.form = new Form("form");
        componentArray[0] = this.form;
        this.add(componentArray);
        IModel selectorModel = new IModel(){

            public Object getObject() {
                return TreeTable.this.selectedKeys.containsAll(TreeTable.this.getVisibleDescendents(null));
            }

            public void setObject(Object object) {
                boolean checked = (Boolean)object;
                if (checked) {
                    TreeTable.this.selectedKeys = new HashSet(TreeTable.this.getVisibleDescendents(null));
                } else {
                    TreeTable.this.selectedKeys.clear();
                }
            }

            public void detach() {
            }
        };
        this.allOrNoneSelector = new AjaxCheckBox("allOrNoneSelector", selectorModel){

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            protected void onUpdate(AjaxRequestTarget target) {
            }
        };
        this.allOrNoneSelector.add(new Behavior[]{new Behavior(){

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                String existingOnClickScript = tag.getAttribute("onclick");
                tag.put("onclick", (CharSequence)("var checked=this.checked;$(this).closest('table').find('.key_selector').each(function() {this.checked = checked;});" + existingOnClickScript));
            }
        }});
        this.allOrNoneSelector.setOutputMarkupId(true);
        WebMarkupContainer allOrNoneSelectorColumn = new WebMarkupContainer("allOrNoneSelectorColumn");
        allOrNoneSelectorColumn.add(new Component[]{this.allOrNoneSelector});
        this.form.add(new Component[]{allOrNoneSelectorColumn});
        if (this.selectedKeys == null) {
            allOrNoneSelectorColumn.setVisible(false);
        }
        Component header = treeColumn.newHeader("treeColumn");
        if (tableColumns.length == 0) {
            header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"last tree-column"))});
        } else {
            header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"tree-column"))});
        }
        this.form.add(new Component[]{header});
        RepeatingView tableColumnsView = new RepeatingView("tableColumns");
        for (int i = 0; i < tableColumns.length; ++i) {
            TreeTableColumn column = tableColumns[i];
            header = column.newHeader(tableColumnsView.newChildId());
            if (i == tableColumns.length - 1) {
                header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"last table-column"))});
            } else {
                header.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"table-column"))});
            }
            tableColumnsView.add(new Component[]{header});
        }
        this.form.add(new Component[]{tableColumnsView});
        for (Serializable nodeKey : dataProvider.getRootNodeKeys()) {
            TreeNode node = new TreeNode();
            node.setKey(nodeKey);
            this.treeMap.put(nodeKey, node);
        }
    }

    public Set<Serializable> getSelectedNodeKeys() {
        if (this.selectedKeys == null) {
            throw new UnsupportedOperationException("Selection support is not enabled.");
        }
        return Collections.unmodifiableSet(this.selectedKeys);
    }

    public void clearSelection() {
        if (this.selectedKeys == null) {
            throw new UnsupportedOperationException("Selection support is not enabled.");
        }
        this.selectedKeys.clear();
    }

    private Pair<String, String> getExpandImageInfo(Serializable nodeKey, Serializable parentNodeKey) {
        if (!this.dataProvider.isExpandable(nodeKey)) {
            if (parentNodeKey != null) {
                List<Serializable> childNodeKeys = this.getChildNodeKeys(parentNodeKey);
                if (childNodeKeys.indexOf(nodeKey) == childNodeKeys.size() - 1) {
                    return new Pair<String, Object>("elbow-end.gif", null);
                }
                return new Pair<String, Object>("elbow.gif", null);
            }
            List<Serializable> rootNodeKeys = this.getRootNodeKeys();
            if (rootNodeKeys.indexOf(nodeKey) == rootNodeKeys.size() - 1) {
                return new Pair<String, Object>("elbow-end.gif", null);
            }
            return new Pair<String, Object>("elbow.gif", null);
        }
        if (parentNodeKey != null) {
            List<Serializable> childNodeKeys = this.getChildNodeKeys(parentNodeKey);
            if (childNodeKeys.indexOf(nodeKey) == childNodeKeys.size() - 1) {
                if (this.state.isExpanded(nodeKey)) {
                    return new Pair<String, String>("elbow-end-minus.gif", "collapse last");
                }
                return new Pair<String, String>("elbow-end-plus.gif", "expand last");
            }
            if (this.state.isExpanded(nodeKey)) {
                return new Pair<String, String>("elbow-minus.gif", "collapse not last");
            }
            return new Pair<String, String>("elbow-plus.gif", "expand not last");
        }
        if (this.state.isExpanded(nodeKey)) {
            List<Serializable> rootNodeKeys = this.getRootNodeKeys();
            if (rootNodeKeys.indexOf(nodeKey) == rootNodeKeys.size() - 1) {
                return new Pair<String, String>("elbow-end-minus.gif", "collapse last");
            }
            return new Pair<String, String>("elbow-minus.gif", "collapse not last");
        }
        List<Serializable> rootNodeKeys = this.getRootNodeKeys();
        if (rootNodeKeys.indexOf(nodeKey) == rootNodeKeys.size() - 1) {
            return new Pair<String, String>("elbow-end-plus.gif", "expand last");
        }
        return new Pair<String, String>("elbow-plus.gif", "expand not last");
    }

    private String getSpacingImageName(Serializable innerNodeKey, Serializable outerNodeKey) {
        if (outerNodeKey != null) {
            List<Serializable> childNodeKeys = this.getChildNodeKeys(outerNodeKey);
            if (childNodeKeys.indexOf(innerNodeKey) == childNodeKeys.size() - 1) {
                return "elbow-blank.gif";
            }
            return "elbow-line.gif";
        }
        List<Serializable> rootNodeKeys = this.getRootNodeKeys();
        if (rootNodeKeys.indexOf(innerNodeKey) == rootNodeKeys.size() - 1) {
            return "elbow-blank.gif";
        }
        return "elbow-line.gif";
    }

    private List<Serializable> getChildNodeKeys(Serializable nodeKey) {
        List<Object> keys;
        TreeNode node = this.treeMap.get(nodeKey);
        Validate.notNull((Object)node);
        if (node.getChildren() == null) {
            keys = this.dataProvider.getChildNodeKeys(nodeKey);
            node.setChildren(new ArrayList<TreeNode>());
            for (Serializable serializable : keys) {
                TreeNode childNode = new TreeNode();
                childNode.setKey(serializable);
                childNode.setParent(node);
                this.treeMap.put(serializable, childNode);
                node.getChildren().add(childNode);
            }
        } else {
            keys = new ArrayList();
            for (TreeNode treeNode : node.getChildren()) {
                keys.add(treeNode.getKey());
            }
        }
        return keys;
    }

    private Serializable getParentNodeKey(Serializable nodeKey) {
        TreeNode node = this.treeMap.get(nodeKey);
        Validate.notNull((Object)node);
        if (node.getParent() != null) {
            return node.getParent().getKey();
        }
        return null;
    }

    private boolean isAncestor(Serializable nodeKey1, Serializable nodeKey2) {
        Serializable parentNodeKey = this.getParentNodeKey(nodeKey2);
        while (parentNodeKey != null) {
            if (parentNodeKey.equals(nodeKey1)) {
                return true;
            }
            parentNodeKey = this.getParentNodeKey(parentNodeKey);
        }
        return false;
    }

    private List<Serializable> getRootNodeKeys() {
        ArrayList<Serializable> rootNodeKeys = new ArrayList<Serializable>();
        for (Map.Entry<Serializable, TreeNode> entry : this.treeMap.entrySet()) {
            if (entry.getValue().getParent() != null) continue;
            rootNodeKeys.add(entry.getKey());
        }
        return rootNodeKeys;
    }

    public TreeDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public TreeState getState() {
        return this.state;
    }

    public void refresh() {
        this.treeMap.clear();
        for (Serializable nodeKey : this.dataProvider.getRootNodeKeys()) {
            TreeNode node = new TreeNode();
            node.setKey(nodeKey);
            this.treeMap.put(nodeKey, node);
        }
    }

    private Fragment newRow(String id, final Serializable nodeKey) {
        Serializable parentNodeKey;
        final Fragment fragment = new Fragment(id, "rowFrag", (MarkupContainer)this, (IModel)new Model(nodeKey));
        fragment.setOutputMarkupId(true);
        AjaxCheckBox keySelector = new AjaxCheckBox("keySelector", new IModel(){

            public Object getObject() {
                return TreeTable.this.selectedKeys.contains(nodeKey);
            }

            public void setObject(Object object) {
                boolean selected = (Boolean)object;
                if (selected) {
                    TreeTable.this.selectedKeys.add(nodeKey);
                } else {
                    TreeTable.this.selectedKeys.remove(nodeKey);
                }
            }

            public void detach() {
            }
        }){

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{TreeTable.this.allOrNoneSelector});
            }
        };
        WebMarkupContainer keySelectorColumn = new WebMarkupContainer("keySelectorColumn");
        keySelectorColumn.add(new Component[]{keySelector});
        if (this.selectedKeys == null) {
            keySelectorColumn.setVisible(false);
        }
        fragment.add(new Component[]{keySelectorColumn});
        RepeatingView spacingsView = new RepeatingView("spacings");
        ArrayList<InternalImage> spacings = new ArrayList<InternalImage>();
        Serializable innerNodeKey = parentNodeKey = this.getParentNodeKey(nodeKey);
        while (innerNodeKey != null) {
            Serializable outerNodeKey = this.getParentNodeKey(innerNodeKey);
            InternalImage spacing = new InternalImage(spacingsView.newChildId(), "/images/tree/" + this.getSpacingImageName(innerNodeKey, outerNodeKey));
            spacings.add(spacing);
            innerNodeKey = outerNodeKey;
        }
        Collections.reverse(spacings);
        Iterator it = spacings.iterator();
        while (it.hasNext()) {
            spacingsView.add(new Component[]{(Component)it.next()});
        }
        fragment.add(new Component[]{spacingsView});
        AjaxLink expandLink = new AjaxLink("expandLink"){

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxCallDecorator(){

                    public CharSequence decorateScript(Component c, CharSequence script) {
                        return "$(this)[0].src='/images/ajax-indicator.gif';" + script + ";";
                    }
                };
            }

            public void onClick(AjaxRequestTarget target) {
                boolean expanded = !TreeTable.this.state.isExpanded(nodeKey);
                TreeTable.this.state.setExpanded(nodeKey, expanded);
                StringBuffer buffer = new StringBuffer("void(0);");
                if (expanded) {
                    String afterId = fragment.getMarkupId();
                    for (Serializable each : TreeTable.this.getVisibleDescendents(nodeKey)) {
                        Fragment row = TreeTable.this.newRow(TreeTable.this.rowsView.newChildId(), each);
                        TreeTable.this.rowsView.add(new Component[]{row});
                        target.add(new Component[]{row});
                        buffer.append(String.format("var item=document.createElement('tr');item.id='%s';insertAfter(item, document.getElementById('%s'));", row.getMarkupId(), afterId));
                        afterId = row.getMarkupId();
                    }
                } else {
                    ArrayList<Fragment> removeRows = new ArrayList<Fragment>();
                    for (Fragment row : TreeTable.this.rowsView) {
                        Serializable rowNodeKey = (Serializable)row.getDefaultModelObject();
                        if (!TreeTable.this.isAncestor(nodeKey, rowNodeKey)) continue;
                        removeRows.add(row);
                        buffer.append(String.format("$('#%s').remove();", row.getMarkupId()));
                    }
                    for (Fragment row : removeRows) {
                        TreeTable.this.rowsView.remove((Component)row);
                    }
                }
                target.prependJavaScript(buffer.toString());
                Fragment expandRow = TreeTable.this.newRow(fragment.getId(), nodeKey);
                expandRow.setMarkupId(fragment.getMarkupId());
                TreeTable.this.rowsView.replace((Component)expandRow);
                target.add(new Component[]{expandRow});
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Pair imageInfo = TreeTable.this.getExpandImageInfo(nodeKey, parentNodeKey);
                tag.put("src", (CharSequence)("/images/tree/" + (String)imageInfo.getFirst()));
                if (imageInfo.getSecond() != null) {
                    tag.put("alt", (CharSequence)imageInfo.getSecond());
                }
            }
        };
        if (!this.dataProvider.isExpandable(nodeKey)) {
            expandLink.setEnabled(false);
        }
        fragment.add(new Component[]{expandLink});
        Component cell = this.treeColumn.newCell("treeColumn", nodeKey);
        if (this.tableColumns.length == 0) {
            cell.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"last tree-column"))});
        } else {
            cell.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"tree-column"))});
        }
        fragment.add(new Component[]{cell});
        RepeatingView tableColumnsView = new RepeatingView("tableColumns");
        for (int i = 0; i < this.tableColumns.length; ++i) {
            TreeTableColumn column = this.tableColumns[i];
            cell = column.newCell(tableColumnsView.newChildId(), nodeKey);
            if (i == this.tableColumns.length - 1) {
                cell.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"last table-column"))});
            } else {
                cell.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"table-column"))});
            }
            tableColumnsView.add(new Component[]{cell});
        }
        fragment.add(new Component[]{tableColumnsView});
        return fragment;
    }

    private List<Serializable> getVisibleDescendents(Serializable nodeKey) {
        List<Serializable> visibleDescendents = nodeKey != null ? new ArrayList<Serializable>(this.getChildNodeKeys(nodeKey)) : this.getRootNodeKeys();
        for (int index = 0; index < visibleDescendents.size(); ++index) {
            Serializable currentNodeKey = visibleDescendents.get(index);
            if (!this.state.isExpanded(currentNodeKey)) continue;
            List<Serializable> children = this.getChildNodeKeys(currentNodeKey);
            visibleDescendents.addAll(index + 1, children);
        }
        return visibleDescendents;
    }

    protected void onBeforeRender() {
        this.rowsView = new RepeatingView("rows");
        for (Serializable nodeKey : this.getVisibleDescendents(null)) {
            this.rowsView.add(new Component[]{this.newRow(this.rowsView.newChildId(), nodeKey)});
        }
        this.form.addOrReplace(new Component[]{this.rowsView});
        super.onBeforeRender();
    }
}

