/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.tabbedpanel;

import com.pmease.quickbuild.web.component.StatefulPanel;
import com.pmease.quickbuild.web.component.tabbedpanel.GroupingTab;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.EmptyPanel;

public class TabbedPanel
extends StatefulPanel<String[]> {
    private static final String PANEL_ID = "panel";
    private List<Tab> tabs;
    private String[] tabIds;
    private Map<String, String> panelParams;

    public TabbedPanel(String panelId, List<Tab> tabs, String[] tabIds, Map<String, String> panelParams) {
        super(panelId);
        this.tabs = tabs;
        this.tabIds = tabIds;
        this.panelParams = panelParams;
    }

    public TabbedPanel(String panelId, List<Tab> tabs) {
        this(panelId, tabs, null);
    }

    public TabbedPanel(String panelId, List<Tab> tabs, String[] tabIds) {
        this(panelId, tabs, tabIds, null);
    }

    protected WebMarkupContainer newTabLink(String linkId, final String[] tabIds) {
        return new Link<Void>(linkId){

            public void onClick() {
                TabbedPanel.this.selectTab(tabIds, null);
            }
        };
    }

    public boolean selectTab(String[] tabIds, Map<String, String> panelParams) {
        for (Tab tab : this.tabs) {
            if (tabIds.length <= 0 || !tab.getId().equals(tabIds[0])) continue;
            if (tab instanceof GroupingTab) {
                GroupingTab groupingTab = (GroupingTab)tab;
                if (tabIds.length == 1) {
                    this.addOrReplace(new Component[]{tab.getPanel(PANEL_ID, null)});
                    this.setState(new String[]{tab.getId(), groupingTab.getChildren().get(0).getId()});
                } else {
                    boolean found = false;
                    for (Tab childTab : groupingTab.getChildren()) {
                        if (!childTab.getId().equals(tabIds[1])) continue;
                        this.addOrReplace(new Component[]{childTab.getPanel(PANEL_ID, panelParams)});
                        this.setState(tabIds);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addOrReplace(new Component[]{tab.getPanel(PANEL_ID, null)});
                        this.setState(new String[]{tab.getId(), groupingTab.getChildren().get(0).getId()});
                    }
                }
            } else {
                if (tabIds.length == 1) {
                    this.addOrReplace(new Component[]{tab.getPanel(PANEL_ID, panelParams)});
                } else {
                    this.addOrReplace(new Component[]{tab.getPanel(PANEL_ID, null)});
                }
                this.setState(new String[]{tab.getId()});
            }
            return true;
        }
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new ListView("tabs", this.tabs){

            protected void populateItem(ListItem item) {
                boolean isLast;
                List<Object> childTabs;
                final Tab tab = (Tab)item.getModelObject();
                WebMarkupContainer tabComponent = new WebMarkupContainer("tab");
                item.add(new Component[]{tabComponent});
                if (((String[])TabbedPanel.this.getState()).length > 0 && ((String[])TabbedPanel.this.getState())[0].equals(tab.getId())) {
                    if (tab instanceof GroupingTab) {
                        tabComponent.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"selected grouping tab"))});
                    } else {
                        tabComponent.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"selected tab"))});
                    }
                } else if (tab instanceof GroupingTab) {
                    tabComponent.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"grouping tab"))});
                } else {
                    tabComponent.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"tab"))});
                }
                WebMarkupContainer link = TabbedPanel.this.newTabLink("link", new String[]{tab.getId()});
                link.add(new Component[]{new Label("label", tab.getTitleModel())});
                tabComponent.add(new Component[]{link});
                if (tab instanceof GroupingTab) {
                    GroupingTab groupingTab = (GroupingTab)tab;
                    childTabs = groupingTab.getChildren();
                } else {
                    childTabs = new ArrayList();
                }
                WebMarkupContainer children = new WebMarkupContainer("children");
                children.setVisible(!childTabs.isEmpty());
                boolean bl = isLast = item.getIndex() == this.getList().size() - 1;
                if (childTabs.isEmpty() && isLast) {
                    tabComponent.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"last"))});
                }
                item.add(new Component[]{children});
                children.add(new Component[]{new ListView("tabs", childTabs){

                    protected void populateItem(ListItem item) {
                        Tab childTab = (Tab)item.getModelObject();
                        if (((String[])TabbedPanel.this.getState()).length > 0 && ((String[])TabbedPanel.this.getState())[0].equals(tab.getId())) {
                            if (((String[])TabbedPanel.this.getState()).length > 1 && childTab.getId().equals(((String[])TabbedPanel.this.getState())[1]) || ((String[])TabbedPanel.this.getState()).length == 1 && item.getIndex() == 0) {
                                item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"selected tab"))});
                            } else {
                                item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"tab"))});
                            }
                        } else {
                            item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"tab"))});
                        }
                        WebMarkupContainer link = TabbedPanel.this.newTabLink("link", new String[]{tab.getId(), childTab.getId()});
                        link.add(new Component[]{new Label("label", childTab.getTitleModel())});
                        item.add(new Component[]{link});
                        if (isLast && item.getIndex() == this.getList().size() - 1) {
                            item.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"last"))});
                        }
                    }
                }});
            }
        }});
        if (!this.tabs.isEmpty()) {
            boolean selected = false;
            if (this.tabIds != null) {
                selected = this.selectTab(this.tabIds, this.panelParams);
            } else if (this.getState() != null) {
                selected = this.selectTab((String[])this.getState(), null);
            }
            if (!selected) {
                this.add(new Component[]{this.tabs.get(0).getPanel(PANEL_ID, null)});
                this.setState(new String[]{this.tabs.get(0).getId()});
            }
        } else {
            this.add(new Component[]{new EmptyPanel(PANEL_ID)});
        }
    }
}

