/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.tabbedpage;

import com.pmease.quickbuild.web.component.tabbedpage.DefaultTabItem;
import com.pmease.quickbuild.web.component.tabbedpage.Tab;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;

public class TabbedPage
extends Panel {
    public TabbedPage(String id, List<Tab> tabs) {
        super(id);
        this.add(new Component[]{new ListView("tabs", tabs){

            protected void populateItem(ListItem item) {
                Tab tab = (Tab)item.getModelObject();
                String cssClass = "tab-" + tab.getPageClasses()[0].getSimpleName() + " ";
                cssClass = cssClass + "tab" + item.getIndex() + " ";
                if (tab.isSelected(this.getPage())) {
                    cssClass = cssClass + "selected ";
                }
                if (item.getIndex() == 0) {
                    cssClass = cssClass + " first ";
                }
                if (item.getIndex() == this.getViewSize() - 1) {
                    cssClass = cssClass + " last ";
                }
                cssClass = cssClass + "tab";
                item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)cssClass))});
                TabbedPage.this.renderTabItem(item, "tab", tab);
                item.get("tab").setRenderBodyOnly(true);
            }
        }});
    }

    protected void renderTabItem(ListItem item, String componentId, Tab tab) {
        item.add(new Component[]{new DefaultTabItem(componentId, tab)});
    }
}

