/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.help;

import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.help.EnumHelpPanel;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.springframework.util.StringUtils;

public class ClassHelpPanel
extends Panel {
    private WebMarkupContainer home;

    public ClassHelpPanel(final String id, final Class<?> clazz, final WebMarkupContainer home, final Component previous) {
        super(id);
        this.home = home;
        this.setOutputMarkupId(true);
        this.add(new Component[]{new Label("className", clazz.getName())});
        this.add(new Component[]{new AjaxLink("home"){

            public void onClick(AjaxRequestTarget target) {
                ClassHelpPanel.this.replaceWith((Component)home);
                target.add(new Component[]{home});
            }
        }});
        this.add(new Component[]{new AjaxLink("back"){

            public void onClick(AjaxRequestTarget target) {
                ClassHelpPanel.this.replaceWith(previous);
                target.add(previous);
            }
        }});
        ScriptApi scriptApi = clazz.getAnnotation(ScriptApi.class);
        String description = scriptApi != null ? StringUtils.replace((String)clazz.getAnnotation(ScriptApi.class).value(), (String)"$docroot", (String)Bootstrap.docroot) : "";
        Label descriptionLabel = new Label("description", description);
        descriptionLabel.setVisible(description.trim().length() != 0);
        descriptionLabel.setEscapeModelStrings(false);
        this.add(new Component[]{descriptionLabel});
        AjaxLink link = new AjaxLink("superClassLink"){

            public void onClick(AjaxRequestTarget target) {
                ClassHelpPanel newPanel = new ClassHelpPanel(id, clazz.getSuperclass(), home, (Component)((Object)ClassHelpPanel.this));
                ClassHelpPanel.this.replaceWith((Component)((Object)newPanel));
                target.add(new Component[]{newPanel});
            }

            protected void onConfigure() {
                super.onConfigure();
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    this.setVisible(true);
                    if (superClass.getAnnotation(ScriptApi.class) != null) {
                        this.setEnabled(true);
                    } else {
                        this.setEnabled(false);
                    }
                } else {
                    this.setVisible(false);
                }
            }
        };
        link.add(new Component[]{new Label("superClassLabel", clazz.getSuperclass() != null ? clazz.getSuperclass().getName() : "")});
        this.add(new Component[]{link});
        this.add(new Component[]{new ListView("subClasses", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                ArrayList subClasses = new ArrayList(ClassHelpPanel.this.getSubClasses(clazz));
                Collections.sort(subClasses, new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> class1, Class<?> class2) {
                        return class1.getName().compareTo(class2.getName());
                    }
                });
                return subClasses;
            }
        }){

            protected void populateItem(final ListItem item) {
                item.add(new Component[]{new WebMarkupContainer("comma"){

                    protected void onConfigure() {
                        super.onConfigure();
                        this.setVisible(item.getIndex() != 0);
                    }
                }});
                final Class subClass = (Class)item.getModelObject();
                AjaxLink link = new AjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        ClassHelpPanel newPanel = new ClassHelpPanel(id, subClass, home, (Component)((Object)ClassHelpPanel.this));
                        ClassHelpPanel.this.replaceWith((Component)((Object)newPanel));
                        target.add(new Component[]{newPanel});
                    }
                };
                link.add(new Component[]{new Label("label", subClass.getName())});
                item.add(new Component[]{link});
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(!this.getModelObject().isEmpty());
            }
        }});
        this.add(new Component[]{new ListView("methods", (IModel)new LoadableDetachableModel(){

            protected Object load() {
                ArrayList<Method> methods = new ArrayList<Method>();
                HashSet<String> examinedMethods = new HashSet<String>();
                for (Class current = clazz; current != null; current = current.getSuperclass()) {
                    for (Method method : current.getDeclaredMethods()) {
                        String methodSignature = ClassUtils.getMethodSignature(method);
                        if (examinedMethods.contains(methodSignature)) continue;
                        if (method.getAnnotation(ScriptApi.class) != null) {
                            methods.add(method);
                        }
                        examinedMethods.add(methodSignature);
                    }
                }
                Collections.sort(methods, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        return m1.getName().compareTo(m2.getName());
                    }
                });
                return methods;
            }
        }){

            protected void populateItem(final ListItem item) {
                Method method = (Method)item.getModelObject();
                item.add(new Component[]{new TypeFrag("returnType", method.getReturnType(), method.getGenericReturnType())});
                item.add(new Component[]{new Label("name", method.getName())});
                item.add(new Component[]{new ListView("params", (IModel)new LoadableDetachableModel(){

                    protected Object load() {
                        Method method = (Method)item.getModelObject();
                        ArrayList typeInfos = new ArrayList();
                        for (int i = 0; i < method.getParameterTypes().length; ++i) {
                            Pair typeInfo = new Pair(method.getParameterTypes()[i], method.getGenericParameterTypes()[i]);
                            typeInfos.add(typeInfo);
                        }
                        return typeInfos;
                    }
                }){

                    protected void populateItem(final ListItem item) {
                        item.add(new Component[]{new WebMarkupContainer("comma"){

                            protected void onConfigure() {
                                super.onConfigure();
                                this.setVisible(item.getIndex() != 0);
                            }
                        }});
                        item.get("comma").setRenderBodyOnly(true);
                        Pair typeInfo = (Pair)item.getModelObject();
                        item.add(new Component[]{new TypeFrag("paramType", (Class)typeInfo.getFirst(), (Type)typeInfo.getSecond())});
                        item.get("paramType").setRenderBodyOnly(true);
                    }
                }});
                String description = StringUtils.replace((String)method.getAnnotation(ScriptApi.class).value(), (String)"$docroot", (String)Bootstrap.docroot);
                Label descriptionLabel = new Label("description", description);
                descriptionLabel.setEscapeModelStrings(false);
                item.add(new Component[]{descriptionLabel});
            }
        }});
    }

    private Collection<Class<?>> getSubClasses(Class<?> clazz) {
        Collection implementations;
        ImplementationProvider implementationProvider = clazz.getAnnotation(ImplementationProvider.class);
        if (implementationProvider != null) {
            Class<?> providerClass = implementationProvider.clazz();
            if (providerClass != Void.class) {
                clazz = providerClass;
            }
            implementations = (Collection)ClassUtils.invokeStaticMethod(clazz, implementationProvider.method());
        } else {
            implementations = ClassUtils.findImplementations(clazz, clazz);
        }
        Iterator<Class<?>> it = implementations.iterator();
        while (it.hasNext()) {
            Class<?> implementation = it.next();
            if (implementation.getAnnotation(ScriptApi.class) != null) continue;
            it.remove();
        }
        return implementations;
    }

    private class SimpleTypeFrag
    extends Fragment {
        public SimpleTypeFrag(String id, final Class<?> clazz) {
            super(id, "simpleTypeFrag", (MarkupContainer)ClassHelpPanel.this);
            AjaxLink link = new AjaxLink("typeLink"){

                public void onClick(AjaxRequestTarget target) {
                    Panel newPanel = !clazz.isEnum() ? new ClassHelpPanel(ClassHelpPanel.this.getId(), clazz, ClassHelpPanel.this.home, (Component)((Object)ClassHelpPanel.this)) : new EnumHelpPanel(ClassHelpPanel.this.getId(), clazz, ClassHelpPanel.this.home, (Component)((Object)ClassHelpPanel.this));
                    ClassHelpPanel.this.replaceWith((Component)newPanel);
                    target.add(new Component[]{newPanel});
                }

                protected void onConfigure() {
                    super.onConfigure();
                    this.setEnabled(clazz.isEnum() || clazz.getAnnotation(ScriptApi.class) != null);
                }
            };
            link.add(new Component[]{new Label("typeName", clazz.getName())});
            this.add(new Component[]{link});
        }
    }

    private class TypeFrag
    extends Fragment {
        public TypeFrag(String id, Class<?> clazz, Type type) {
            super(id, "typeFrag", (MarkupContainer)ClassHelpPanel.this);
            this.add(new Component[]{new SimpleTypeFrag("type", clazz)});
            if (ClassUtils.getCollectionElementType(type) != null) {
                Fragment genericParamsFrag = new Fragment("genericParams", "collectionGenericParamsFrag", (MarkupContainer)this);
                genericParamsFrag.add(new Component[]{new SimpleTypeFrag("elementType", ClassUtils.getCollectionElementType(type))});
                this.add(new Component[]{genericParamsFrag});
            } else if (ClassUtils.getMapKeyType(type) != null && ClassUtils.getMapValueType(type) != null) {
                Fragment genericParamsFrag = new Fragment("genericParams", "mapGenericParamsFrag", (MarkupContainer)this);
                genericParamsFrag.add(new Component[]{new SimpleTypeFrag("keyType", ClassUtils.getMapKeyType(type))});
                genericParamsFrag.add(new Component[]{new SimpleTypeFrag("valueType", ClassUtils.getMapValueType(type))});
                this.add(new Component[]{genericParamsFrag});
            } else {
                this.add(new Component[]{new WebMarkupContainer("genericParams").setVisible(false)});
            }
        }
    }
}

