/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.component.editor;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.typeconverter.TypeConverter;
import com.pmease.quickbuild.typeconverter.TypeConverterRegistry;
import com.pmease.quickbuild.util.AccessListener;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.component.editor.PropertyEditor;
import com.pmease.quickbuild.web.component.editor.PropertyUsageCallback;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class TypeEditor
extends Panel {
    private Class<?> beanClass;
    private EditContext.EditableProperty property;
    private Set<String> usedPropertyPaths = new HashSet<String>();
    private transient Method getter;
    private transient TypeConverter typeConverter;

    public TypeEditor(String id, Class<?> beanClass, EditContext.EditableProperty property) {
        super(id);
        this.beanClass = beanClass;
        this.property = property;
        this.setOutputMarkupId(true);
    }

    protected Class<?> getBeanClass() {
        return this.beanClass;
    }

    public EditContext.EditableProperty getProperty() {
        return this.property;
    }

    protected Method getGetter() {
        if (this.getter == null) {
            this.getter = BeanUtils.getGetter(this.beanClass, this.property.getName());
        }
        return this.getter;
    }

    protected TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = TypeConverterRegistry.instance.getTypeConverter(this.getGetter());
        }
        return this.typeConverter;
    }

    protected IModel<String> getStringValueModel() {
        return new IModel<String>(){

            public String getObject() {
                return (String)TypeEditor.this.property.getValue();
            }

            public void setObject(String object) {
                TypeEditor.this.property.setValue(object);
            }

            public void detach() {
            }
        };
    }

    protected IModel getObjectValueModel() {
        return new IModel(){

            public Object getObject() {
                return TypeEditor.this.getTypeConverter().toObject(TypeEditor.this.getGetter().getReturnType(), (String)TypeEditor.this.getStringValueModel().getObject());
            }

            public void setObject(Object object) {
                TypeEditor.this.getStringValueModel().setObject((Object)TypeEditor.this.getTypeConverter().toString(object));
            }

            public void detach() {
            }
        };
    }

    protected boolean isRequired() {
        return EditorHelper.isPropertyRequired(this.beanClass, this.property.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T trackPropertyUsage(PropertyUsageCallback<T> callback) {
        AccessListener<String> accessListener = new AccessListener<String>(){

            @Override
            public void onAccess(String propertyPath) {
                TypeEditor.this.usedPropertyPaths.add(propertyPath);
            }
        };
        EditContext.EditableProperty.registerAccessListener(accessListener);
        Context.pushComponent((Component)((Object)this));
        try {
            this.usedPropertyPaths.clear();
            T t = callback.execute();
            return t;
        }
        finally {
            Context.popComponent();
            EditContext.EditableProperty.unregisterAccessListener(accessListener);
        }
    }

    public Set<String> getUsedPropertyPaths() {
        return this.usedPropertyPaths;
    }

    class PropertyChangeBehavior
    extends AjaxFormComponentUpdatingBehavior {
        public PropertyChangeBehavior(String event) {
            super(event);
        }

        protected void onUpdate(AjaxRequestTarget target) {
            PropertyEditor propertyEditor = (PropertyEditor)((Object)TypeEditor.this.findParent(PropertyEditor.class));
            if (propertyEditor != null) {
                propertyEditor.onPropertyChanged(target);
            }
        }
    }
}

